package com.firestick.main;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;

import com.firestick.graphics.povray.PovrayIniFile;

public class MakePov {

	private static String baseSrcDir = "d:/yick/";
	private static String makeIni = "make.ini";
	
	private static PovrayIniFile ini;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {
		ini = new PovrayIniFile(baseSrcDir  + makeIni);
		writeMakeFile("makep1.cmd", ini.getStartFrame());
		writeMakeFile("makep2.cmd", ini.getEndFrame());
		
	}

	private static void writeMakeFile(String makeFileName, int startFrame) throws IOException {
		Writer writer = null;
		DecimalFormat format= new DecimalFormat("000"); 
		
		try { 
			writer = new FileWriter(new File(baseSrcDir + makeFileName));
			for (int idx=startFrame;idx<ini.getEndFrame();idx+=2) {
				writer.write("IF NOT EXIST " + ini.getOutputFileName() + ini.getInputFileNameNoExtension() + format.format(idx) +  ".bmp ");
				writer.write ("pvengine /EXIT /RENDER " + makeIni + " +SF" + idx + " +EF" +idx);
				writer.write ("\n\n");
			}
		} finally {
			if (writer != null) {
				writer.close();
			}
		}
		
		
		
	}
	
}
