package com.firestick.stream;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;



public class DelimitedStreamLineReader {

    private IDelimitedStreamLineEventListener lineEventListener;
    private BufferedReader reader;
    private String delimeters;
    private boolean discardEmptyFields;

    public DelimitedStreamLineReader (Reader reader, IDelimitedStreamLineEventListener lineEventListener,String delimiters, boolean discardEmptyFields) {
        this.lineEventListener = lineEventListener;
        this.reader = new BufferedReader(reader);  
        this.delimeters = delimiters;
        this.discardEmptyFields = discardEmptyFields;
    }
   
    public void start () {
        long lineNumber = 0;
        String line;
        try {
            while ((line = reader.readLine()) != null) {
                lineEventListener.lineEvent(split(line), lineNumber ++);
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
    
    
    private List<String> split (String line) {
    	ArrayList list = new ArrayList<String>();
    	StringTokenizer tokenizer = new StringTokenizer (line, delimeters);
    	while (tokenizer.hasMoreTokens()) {
    		String token = tokenizer.nextToken();
    		if (discardEmptyFields) {
    			if (token.length() > 0) {
    				list.add(token);
    			}
    		} else {
    			list.add(token);
    		}
    	}
    	return list;
    }
    
}
