// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.6
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.6;

#declare numberOfFrames = 900;

                                 




 // ----------------------------------------
// QUALITY
// ----------------------------------------


#declare Photons=off; 
#declare complexBodyTexture=off;  
#declare complexBodyBabyTexture=off;
#declare complexlighting=on;

;
#declare includeRoom=on; 
#declare atmosphere=on;  
#declare showGlitterBall= on;    
#declare sideSpots=off;   
#declare blueLaser=off;   
#declare backLight=on;
#declare strobeAlwaysOn=off;  
#declare includeDancer=on;

// ----------------------------------------
// SCENE DEFINITION
// ----------------------------------------


#local ballSize = 3;
#local thingyFactor = 80;   
#local floorLevel = -80;
#local ceilingLevel=120;
#local roomWidth=220;   
                                   

#local musicBallDriftEndSec = 17.8;
// explosion best over 7 seconds                                   
#local bodyExplosionStartSec = 18;  // makes the last frame of character 540, 
#local bodyExplosionStartEnd = 25;                   
                      


#declare poser_inc_number = frame_number;

#if (poser_inc_number >= 599) 
    #declare poser_inc_number = 599;
#end

#include "colors.inc"  
#include "rsdebug.inc"
#include "rsclock.inc" 
#include "skies.inc"
                            
                            
#include concat ("d:/carpet/poser/pov/body_", str(poser_inc_number+1,0,0),"_stats.inc") 



//**********************************************************************************
// CAMERA
//
// 0 - production
// 1 - look at ball
// 2 - ceiling camera
// 3 - side camera
//**********************************************************************************


#local cameraNumber=0;


// ----------------------------------------
// INTERNAL
// ----------------------------------------

global_settings {
  assumed_gamma 1.0
  max_trace_level 5
  #if (Photons)          // global photon block
    photons {
      spacing 0.02                 // specify the density of photons 
      media 200  
      gather 10, 30
      //count 100000               // alternatively use a total number of photons

      //gather min, max            // amount of photons gathered during render [20, 100]
      //media max_steps [,factor]  // media photons
      //jitter 1.0                 // jitter phor photon rays
      //max_trace_level 5          // optional separate max_trace_level
      //adc_bailout 1/255          // see global adc_bailout
      //save_file "filename"       // save photons to file
      //load_file "filename"       // load photons from file
      //autostop 0                 // photon autostop option
      //radius 10                  // manually specified search radius
      // (---Adaptive Search Radius---)
      //steps 1
      //expand_thresholds 0.2, 40
    }

  #end
}


#local musicBallHoldFrameNumber = 134; 
#local musicBallThrowFrameNumber = 178;
#local musicBallFinalHeightFrameNumber = 190;




//#local ballPosition = <0,roomSize * 0.6,-roomSize>;
#declare ballPosition = <0,-ceilingLevel/6,roomWidth/3>;

#local bottomCorner = <-roomWidth,floorLevel,-roomWidth>;
#local topCorner = <roomWidth,ceilingLevel,roomWidth>;   




#local ballSpotRadius = ballSize * 1;             


#declare dancerPositionVec = <0,floorLevel,-100>;    


#local bodyVecCorrectionMultiplier = 150;
#local actualDancerCenter = (body_center * bodyVecCorrectionMultiplier) + dancerPositionVec;


#include concat ("d:/carpet/poser/pov/hands_", str(poser_inc_number+1,0,0),"_stats.inc")
#local currentHandCenter = hands_center;
                                                                                    



#if (showGlitterBall)                                            
    
    
    
    #include concat ("d:/carpet/poser/pov/hands_", str(musicBallFinalHeightFrameNumber+1,0,0),"_stats.inc")  
    #local finalBallHightHandCenter = hands_center;                                                                                  


    #local actualBallHigherVec = <0,40,0>;

    #local actualHandsCenter = (currentHandCenter * bodyVecCorrectionMultiplier) + dancerPositionVec;   
    #local actualFinalBallHightHandCenter = (finalBallHightHandCenter * bodyVecCorrectionMultiplier) + dancerPositionVec;
    //#debugPoint(actualDancerCenter, 10) 
    
    #local musicBallHoldSystemClockStart = (1/numberOfFrames) *  musicBallHoldFrameNumber;
    #local musicBallHoldSystemClockEnd = (1/numberOfFrames) * musicBallThrowFrameNumber;
    #local musicBallHoldClock = rsclock(clock, musicBallHoldSystemClockStart, musicBallHoldSystemClockEnd);
    
    #local musicBallThrowSystemClockStart = (1/numberOfFrames) *  musicBallThrowFrameNumber;
    #local musicBallThrowSystemClockEnd = (1/numberOfFrames) * musicBallThrowFrameNumber;
    #local musicBallThrowClock = rsclock(clock, musicBallThrowSystemClockStart, musicBallThrowSystemClockEnd);


    
    #local musicBallDriftSystemClockStart = (1/numberOfFrames) *  (musicBallFinalHeightFrameNumber + 30 * 3);
    #local musicBallDriftSystemClockEnd = (1/numberOfFrames) * musicBallDriftEndSec * 30;
    #local musicBallDriftClock = rsclock(clock, musicBallDriftSystemClockStart, musicBallDriftSystemClockEnd);
    
    
    
    #local musicBallRotationSystemClockStart = (1/numberOfFrames) *  musicBallHoldFrameNumber;
    #local musicBallRotationSystemClockEnd = (1/numberOfFrames) * numberOfFrames;
    #local musicBallRotationClock = rsclock(clock, musicBallRotationSystemClockStart, musicBallRotationSystemClockEnd);

    #local ballDisplaceMent = <0,5,0>;
    
    
    
    
    #if (musicBallHoldClock > 0) 
    
        #include "glitterBall.inc"
    
        #if (frame_number < musicBallFinalHeightFrameNumber)    
            #declare ballPosition = actualHandsCenter + ballDisplaceMent + actualBallHigherVec * musicBallThrowClock;
        #else     
            #declare ballPosition = actualFinalBallHightHandCenter + ballDisplaceMent + <0,-80 * musicBallDriftClock,0> + actualBallHigherVec * (1-musicBallDriftClock);
        #end


        light_source {
            0*x                  // light's position (translated below)
            color rgb <0.8,0,0>    // light's color

            fade_distance 30
            fade_power 3
            
            projected_through {
                object {
                    glitterBall
                    scale (ballSize/2) + (ballSize/2) * musicBallHoldClock
                    rotate <9 * musicBallRotationClock * 360,10 * musicBallRotationClock * 360,11 * musicBallRotationClock * 360>
                    
                } 
            }
             
             
            looks_like {
                 object {
                    glitterBall
                    scale ballSize * musicBallHoldClock
                    rotate <9 * musicBallRotationClock * 360,10 * musicBallRotationClock * 360,11 * musicBallRotationClock * 360>
                    
                } 
            }
            
            
            translate ballPosition   
        }
    
         
   
         
    #end
    
#end


 

#local sideSpot_A_Pos = <bottomCorner.x * 4, bottomCorner.y *0.9, -roomWidth>;
//#debugPoint (sideSpot_A_Pos, 3) 

#if (cameraNumber = 0)
    
    
    
    #local camPos = <0.0, 0, 0-(roomWidth - (ballSize*3))>;
    #declare cameraClock = rsclock (clock,(1/numberOfFrames)*603, (1/numberOfFrames)*660);
    #if (cameraClock >= 0.5)  
        #declare includeDancer=off;
        #declare cameraClock = 1;
    #end
    
    #if (frame_number>602)
         
    
    
        camera {
         location   camPos * (1-cameraClock) + (ballPosition + <0, 20, 0>) * cameraClock
          direction  (0.6 + (1.4 * cameraClock)) *z
          right     x*image_width/image_height
          look_at   ballPosition
        } 
    #else
        camera {
          location  camPos
          direction  0.6*z
          right     x*image_width/image_height
          look_at   <0,0,0>
        }
    #end

#end

#if (cameraNumber = 1)
    camera {
      location  <0.0, 0, -roomSize * 0.9>
      direction  1.5*z
      right     x*image_width/image_height
      look_at   ballPosition
    }
#end


#if (cameraNumber = 2)
    camera {
      location  <0.0, ceilingLevel * 3, 0>
      direction  0.5*z
      right     x*image_width/image_height
      look_at   <0,0,0>    
      }
    #debugFrame(bottomCorner, topCorner, 10)
#end


#if (cameraNumber = 3) 
    #local debugCamZ = -roomWidth * 0.9;
    camera {
      location  <-roomWidth, ceilingLevel * 0.5, debugCamZ>
      direction  0.5*z
      right     x*image_width/image_height
      look_at   <roomWidth,ceilingLevel * 0.5,debugCamZ>    
      }
     #debugFrame(bottomCorner, topCorner, 10)
#end

//#debugFrame(bottomCorner, topCorner, 10)


#if(complexlighting)
    #include "lights_complex.inc"
#else
    // create a regular point light source
light_source {
  0*x                  // light's position (translated below)
  color rgb <1,1,1>    // light's color
  translate <-20, 40, -20>
}

#end







#if(includeDancer)                 

    #local bodyExpClock = pow(rsclock (clock, bodyExplosionStartSec * 30/numberOfFrames, bodyExplosionStartEnd * 30/numberOfFrames),1.2);



    #declare bodyexplosionAmmount = 20 * bodyExpClock;
    #declare bodyexpRndSeed = 34;
    #declare bodyexpVariance = 0.5;

    #include "dancer.inc"
    
#end    



#if(frame_number>602)
    #include "baby.inc"
#end






  

#if (includeRoom)   
  box
  {     
   <-roomWidth,floorLevel,-roomWidth>, <roomWidth, ceilingLevel, roomWidth>
   
  
  #if(atmosphere)
  pigment { rgbt 1 } hollow
   interior
   { media
     { 
     
     scattering { 3, 0.001 extinction 0}  
     samples 80,400
     
     }
    
   }
   
     //photons { pass_through }
  #else
     pigment { rgb 1 } 
  #end
  }  
#end  
       
       
  



 
      
 
 
       