#declare PLASTIC_TUBE=texture {
		pigment { color rgbt<0.0,1,1,0.85> }
		finish {
			ambient 0.4
			diffuse 0.6
			specular 1
			roughness 0.02
			reflection {rgb<0.6,0.2,0.05>*0.1}
		}
		
	};

#declare PLASTIC_FRAME=texture {
		pigment { color rgb 1 }
		finish {
			ambient 0.6
			diffuse 0.4
			specular 0.5
			roughness 0.1
			reflection {rgb<0.6,0.2,0.05>*0.1}
		}
		
	};

#declare METAL=texture {
		pigment { color rgb<1,0.8,0.3> }
		finish {
			ambient 0.2
			diffuse 0.2
			specular 1
			roughness 0.02
			reflection {rgb<0.6,0.2,0.05>}
		}
		
	};

#macro SMOOTH_RECT_SPLINE(INNER, OUTER, SHIFT)
	<SHIFT+-OUTER,-INNER>,<SHIFT+-OUTER,0>,<SHIFT+-OUTER,0>,<SHIFT+-OUTER,INNER>,
	<SHIFT+-OUTER,INNER>,<SHIFT+-OUTER,OUTER>,<SHIFT+-OUTER,OUTER>,<SHIFT+-INNER,OUTER>
	<SHIFT+-INNER,OUTER>,<SHIFT+0,OUTER>,<SHIFT+0,OUTER>,<SHIFT+INNER,OUTER>,
	<SHIFT+INNER,OUTER>,<SHIFT+OUTER,OUTER>,<SHIFT+OUTER,OUTER>,<SHIFT+OUTER,INNER>,
	<SHIFT+OUTER,INNER>,<SHIFT+OUTER,0>,<SHIFT+OUTER,0>,<SHIFT+OUTER,-INNER>,
	<SHIFT+OUTER,-INNER>,<SHIFT+OUTER,-OUTER>,<SHIFT+OUTER,-OUTER>,<SHIFT+INNER,-OUTER>,
	<SHIFT+INNER,-OUTER>,<SHIFT+0,-OUTER>,<SHIFT+0,-OUTER>,<SHIFT+-INNER,-OUTER>,
	<SHIFT+-INNER,-OUTER>,<SHIFT+-OUTER,-OUTER>,<SHIFT+-OUTER,-OUTER>,<SHIFT+-OUTER,-INNER>
#end

#macro EDGED_RECT_SPLINE(SIZE)
	<-SIZE,-SIZE>,<0,-SIZE>,<0,-SIZE>,<SIZE,-SIZE>,
	<SIZE,-SIZE>,<SIZE,0>,<SIZE,0>,<SIZE,SIZE>,
	<SIZE,SIZE>,<0,SIZE>,<0,SIZE>,<-SIZE,SIZE>,
	<-SIZE,SIZE>,<-SIZE,0>,<-SIZE,0>,<-SIZE,-SIZE>
#end

#declare STRUT_RADIUS=0.05;

#declare gridbox=union {
	cylinder { <-5,-5,-5>,<5,-5,-5>, STRUT_RADIUS }
	cylinder { <-5,5,-5>,<5,5,-5>, STRUT_RADIUS }
	cylinder { <-5,-5,5>,<5,-5,5>, STRUT_RADIUS }
	cylinder { <-5,5,5>,<5,5,5>, STRUT_RADIUS }
	
	cylinder { <-5,-5,-5>,<-5,5,-5>, STRUT_RADIUS }
	cylinder { <5,-5,-5>,<5,5,-5>, STRUT_RADIUS }
	cylinder { <-5,-5,5>,<-5,5,5>, STRUT_RADIUS }
	cylinder { <5,-5,5>,<5,5,5>, STRUT_RADIUS }
	
	cylinder { <-5,-5,-5>,<-5,-5,5>, STRUT_RADIUS }
	cylinder { <5,-5,-5>,<5,-5,5>, STRUT_RADIUS }
	cylinder { <-5,5,-5>,<-5,5,5>, STRUT_RADIUS }
	cylinder { <5,5,-5>,<5,5,5>, STRUT_RADIUS }
	texture { PLASTIC_FRAME }
	no_shadow
}

#declare frame=union {
	prism {
		bezier_spline -5.1, -4.9, 48
		EDGED_RECT_SPLINE(1.1)
		SMOOTH_RECT_SPLINE(0.5,0.9,0)
	}
	cylinder { <-1,-5,-1>, <-5,-5,-5>, STRUT_RADIUS}
	cylinder { <1,-5,-1>, <5,-5,-5>, STRUT_RADIUS}
	cylinder { <-1,-5,1>, <-5,-5,5>, STRUT_RADIUS}
	cylinder { <1,-5,1>, <5,-5,5>, STRUT_RADIUS}
	texture { PLASTIC_FRAME }
	no_shadow
}

#declare frame_x=object {frame rotate z*-90}

#declare frame_y=object{frame}

#declare frame_z=object {
	frame
	rotate x*90
}

#declare straight_tube=prism {
	bezier_spline -4.9, 4.9, 64
	SMOOTH_RECT_SPLINE(0.6,1.0,0)
	SMOOTH_RECT_SPLINE(0.5,0.9,0)
	
	texture { PLASTIC_TUBE }
}

#declare curved_tube=intersection {
	lathe {
		bezier_spline 64
		SMOOTH_RECT_SPLINE(0.6,1.0,5)
		SMOOTH_RECT_SPLINE(0.5,0.9,5)
	}
	box{<0,-2,0>,<7,2,7>}
	translate <-5,0,-5>
	texture { PLASTIC_TUBE }
}

#declare tube16=union {object {straight_tube} object {frame_z} }
#declare tube61=union {object {straight_tube} object {frame_z} }

#declare tube25=union {object {straight_tube rotate z*90 } object {frame_x} }
#declare tube52=union {object {straight_tube rotate z*90 } object {frame_x} }

#declare tube34=union {object {straight_tube rotate x*90 } object {frame_z} }
#declare tube43=union {object {straight_tube rotate x*90 } object {frame_z} }

#declare tube35=union {object {curved_tube rotate y*-90} object {frame_z} }
#declare tube53=union {object {curved_tube rotate y*-90} object {frame_z} }

#declare tube45=object {curved_tube rotate y*180}
#declare tube54=object {curved_tube rotate y*180}

#declare tube24=union {object {curved_tube rotate y*90} object {frame_x} }
#declare tube42=union {object {curved_tube rotate y*90} object {frame_x} }

#declare tube23=union {object {curved_tube rotate y*0} object {frame_x} object {frame_z}}
#declare tube32=union {object {curved_tube rotate y*0} object {frame_x} object {frame_z}}

#declare tube12=union {object {curved_tube rotate x*-90 rotate y*0} object {frame_y} object {frame_x}}
#declare tube21=union {object {curved_tube rotate x*-90 rotate y*0} object {frame_y} object {frame_x}}

#declare tube14=union {object {curved_tube rotate x*-90 rotate y*90} object {frame_y}}
#declare tube41=union {object {curved_tube rotate x*-90 rotate y*90} object {frame_y}}

#declare tube13=union {object {curved_tube rotate x*-90 rotate y*270} object {frame_y} object {frame_z}}
#declare tube31=union {object {curved_tube rotate x*-90 rotate y*270} object {frame_y} object {frame_z}}

#declare tube15=union {object {curved_tube rotate x*-90 rotate y*180} object {frame_y}}
#declare tube51=union {object {curved_tube rotate x*-90 rotate y*180} object {frame_y}}

#declare tube62=union {object {curved_tube rotate x*90 rotate y*0} object {frame_x}}
#declare tube26=union {object {curved_tube rotate x*90 rotate y*0} object {frame_x}}

#declare tube65=object {curved_tube rotate x*90 rotate y*180}
#declare tube56=object {curved_tube rotate x*90 rotate y*180}

#declare tube64=object {curved_tube rotate x*90 rotate y*90}
#declare tube46=object {curved_tube rotate x*90 rotate y*90}

#declare tube63=union {object {curved_tube rotate x*90 rotate y*270} object {frame_z}}
#declare tube36=union {object {curved_tube rotate x*90 rotate y*270} object {frame_z}}

// tubes with "activators" inside

#declare roll=union {
	union {
		cylinder { <-0.15,-1,0>,<-0.05,-1,0>, 0.35}
		cylinder { <0.15,-1,0>,<0.05,-1,0>, 0.35}
		cylinder { <-0.05,-1,0>,<0.05,-1,0>, 0.25}
		
		texture{METAL}
	}
	
	union {
		cylinder { <-0.3,-1,0>,<0.3,-1,0>, 0.05}
		cylinder { <-0.3,-1,0>,<-0.3,-0.5,0>, 0.05}
		cylinder { <0.3,-1,0>,<0.3,-0.5,0>, 0.05}
		cylinder { <-0.3,-0.5,0>,<0.3,-0.5,0>, 0.05}
		cylinder { <0,-0.5,0>,<0,0,0>, 0.05}
	
		no_shadow
		texture{PLASTIC_FRAME}
	}
}

#declare pulley_frame=union {
	union {
		cylinder { <-5,5,-5>, <0,5,-1.5>, STRUT_RADIUS}
		cylinder { <5,5,-5>, <0,5,-1.5>, STRUT_RADIUS}
		cylinder { <-5,5,5>, <0,5,1.5>, STRUT_RADIUS}
		cylinder { <5,5,5>, <0,5,1.5>, STRUT_RADIUS}
		cylinder { <0,5,-2.5>, <0,5,1.5>, STRUT_RADIUS}
		texture{PLASTIC_FRAME}
		no_shadow
	}
	object { roll translate<0,5,-1.5>}
	object { roll translate<0,5,1.5>}
	
}

#macro MAKE_ACTIVATOR(ACTIVE)
union {
	prism {
		linear_spline -0.75, 0.75, 5,
		<-4,-0.9>,<0,-0.9+(1-ACTIVE)*1.8>,
		<0,-1+(1-ACTIVE)*1.8>,<-4,-1>,
		<-4,-0.9>
		
		rotate x*-90
	}
	cylinder{<0,-0.95+(1-ACTIVE)*1.9,-1.2>,<0,-0.95+(1-ACTIVE)*1.9,1.2>,0.05}
	texture{PLASTIC_FRAME}
}
#end

#macro MAKE_ROPE(p0,p1,p2,axis)
	union {
	#local tmpv=p0;
	#while (tmpv.y<p1.y)
		sphere{tmpv, 0.05}
		#local tmpv=tmpv+<0,0.1,0>;
	#end
	#local tmpv=vnormalize(tmpv-p1)*0.3+p1;
	#while(tmpv.y>p1.y)
		sphere{tmpv, 0.05}
		#local tmpv=vrotate(tmpv-p1, axis*19.098)+p1;
	#end
	#local tmpv=<p2.x, tmpv.y, p2.z >;
	#while (tmpv.y>=p2.y)
		sphere{tmpv, 0.05}
		#local tmpv=tmpv-<0,0.1,0>;
	#end
		texture{METAL}
	}
#end

#declare closed_gate=union {
	box{<-0.1,-1,-1>,<0.1,1,1>}
	box{<-0.1,-2.9,-1>,<0.1,-2.8,1>}
	box{<-0.1,-2.9,-1>,<0.1,0,-0.9>}
	box{<-0.1,-2.9,1>,<0.1,0,0.9>}
	cylinder{<0,1,-1.8>,<0,1,1.8>,0.1}
	
	texture{PLASTIC_FRAME}
}

#declare open_gate=union {
	box{<-0.1,0.9,-1>,<0.1,1,1>}
	box{<-0.1,-2.9,-1>,<0.1,-0.9,1>}
	box{<-0.1,-2.9,-1>,<0.1,1,-0.9>}
	box{<-0.1,-2.9,1>,<0.1,1,0.9>}
	cylinder{<0,1,-1.8>,<0,1,1.8>,0.1}
	
	texture{PLASTIC_FRAME}
}

#macro MAKE_GATE(state, mode)
union {
	MAKE_ACTIVATOR(state)
	object {pulley_frame}
	
	MAKE_ROPE(<0,-0.95+1.8-1.8*state,-1.2>,<0,4,-1.5>,<0,1.8*state-9,-1.8>,-x)
	MAKE_ROPE(<0,-0.95+1.8-1.8*state,1.2>,<0,4,1.5>,<0,1.8*state-9,1.8>,x)
	
	object { mode translate <0,-10+1.8*state,0>}
}
#end

#declare tube125=union {
	difference {
		object {straight_tube rotate z*90 }
		box{<-4,-1.25,-0.75>,<0,-0.75,0.75> texture{PLASTIC_TUBE}}
		box{<-0.1,-3,-3>,<+0.1,0.89,3> texture{PLASTIC_TUBE}}
	}
	object {frame_x}
}

#declare tube225=union {
	difference {
		object {straight_tube rotate z*90 }
		box{<-0.1,-3,-3>,<+0.1,3,3> texture{PLASTIC_TUBE}}
	}
	object {frame_x}
}

#declare tube152=union {
	difference {
		object {straight_tube rotate z*90 }
		box{<-4,-1.25,-0.75>,<0,-0.75,0.75> texture{PLASTIC_TUBE}}
		box{<-0.1,-3,-3>,<+0.1,0.89,3> texture{PLASTIC_TUBE}}
		rotate y*180
	}
	object {frame_x}
}

#declare tube252=union {
	difference {
		object {straight_tube rotate z*90 }
		box{<-0.1,-3,-3>,<+0.1,3,3> texture{PLASTIC_TUBE}}
		rotate y*180
	}
	object {frame_x}
}

#declare tube352=union {
	difference {
		object {straight_tube rotate z*90 }
		box{<-5,-0.8,0>,<5,0.8,2> texture{PLASTIC_TUBE}}
	}
	difference {
		object {frame_x}
		box{<-10,-0.8,0>,<10,0.8,2> texture{PLASTIC_FRAME}}
	}
}

