import grid, random
from math import sin, cos, pi

blocked={(3,5,6): 1}

class Ant:
	def __init__(self, x, y, z, direction, tube):
		self.state=int(random.random()*12)
		self.direction=direction
		self.x=0
		self.y=0
		self.z=0
		self.cell=(x, y, z)
		self.tube=tube
		self.progress=0
		self.p_in_tube=0
	def advance(self):
		# FIXME: check if blocked
		if self.cell[0]<0: return False
		if self.cell[1]<0: return False
		if self.cell[2]<0: return False
		if self.cell[0]>9: return False
		if self.cell[1]>9: return False
		if self.cell[2]>9: return False
		p=grid.grid[self.cell[1]][self.cell[2]][self.cell[0]]
		
		if p==225:
			if (self.p_in_tube==-15) and blocked.has_key(self.cell):
				return True
		
		self.p_in_tube=self.p_in_tube+1
		self.progress=self.progress+1
		self.state=(self.state+1)%12
		if (p==25) or (p==125) or (p==225) or (p==325):
			self.x=self.p_in_tube*0.1
			self.y=0
			self.z=0
			self.direction=0
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=-5
				self.cell=(self.cell[0]+1, self.cell[1], self.cell[2])
		elif (p==52) or (p==352):
			self.x=-self.p_in_tube*0.1
			self.y=0
			self.z=0
			self.direction=-180
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=5
				self.cell=(self.cell[0]-1, self.cell[1], self.cell[2])
		elif p==34:
			self.x=0
			self.y=0
			self.z=self.p_in_tube*0.1
			self.direction=-90
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=-5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]+1)
		elif p==43:
			self.x=0
			self.y=0
			self.z=-self.p_in_tube*0.1
			self.direction=-270
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]-1)
		elif p==23:
			self.x=-5+5*sin((self.p_in_tube+50)*pi/200)
			self.z=-5+5*cos((self.p_in_tube+50)*pi/200)
			self.direction=0+0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=+5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]-1)
		elif p==24:
			self.x=-5+5*sin((self.p_in_tube+50)*pi/200)
			self.z=+5-5*cos((self.p_in_tube+50)*pi/200)
			self.direction=0-0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=-5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]+1)
		elif p==35:
			self.x=+5-5*cos((self.p_in_tube+50)*pi/200)
			self.z=-5+5*sin((self.p_in_tube+50)*pi/200)
			self.direction=-90+0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=-5
				self.cell=(self.cell[0]+1, self.cell[1], self.cell[2])
		elif p==32:
			self.x=-5+5*cos((self.p_in_tube+50)*pi/200)
			self.z=-5+5*sin((self.p_in_tube+50)*pi/200)
			self.direction=-90-0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=5
				self.cell=(self.cell[0]-1, self.cell[1], self.cell[2])
		elif p==54:
			self.x=+5-5*sin((self.p_in_tube+50)*pi/200)
			self.z=+5-5*cos((self.p_in_tube+50)*pi/200)
			self.direction=-180+0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=-5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]+1)
		elif p==53:
			self.x=+5-5*sin((self.p_in_tube+50)*pi/200)
			self.z=-5+5*cos((self.p_in_tube+50)*pi/200)
			self.direction=-180-0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.z=+5
				self.cell=(self.cell[0], self.cell[1], self.cell[2]-1)
		elif p==45:
			self.x=+5-5*cos((self.p_in_tube+50)*pi/200)
			self.z=+5-5*sin((self.p_in_tube+50)*pi/200)
			self.direction=180-0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=-5
				self.cell=(self.cell[0]+1, self.cell[1], self.cell[2])
		elif p==42:
			self.x=-5+5*cos((self.p_in_tube+50)*pi/200)
			self.z=+5-5*sin((self.p_in_tube+50)*pi/200)
			self.direction=180+0.9*(self.p_in_tube+50)
			if self.p_in_tube==50:
				self.p_in_tube=-50
				self.x=+5
				self.cell=(self.cell[0]-11, self.cell[1], self.cell[2])
		else:
			print self.cell
			print p
			panic()
		return True
	def generate_model(self):
		if self.state<0: obj="ant_standing"
		else: obj="ant_walk%d" % self.state
		x=self.x+self.cell[0]*10
		y=self.y+self.cell[1]*10
		z=self.z+self.cell[2]*10
		return "object {%s rotate y*%f translate<%f, %f-1, %f>}" \
			% (obj, self.direction, x, y, z)

tubes={}
for e in grid.entrance:
	tubes[e]=[]

def can_create_ant(tube):
	if not tube: return True
	ant=tube[-1]
	return ant.progress>=30

def create_new_ants():
	for e in grid.entrance:
		t=tubes[e]
		if not can_create_ant(t): continue
		p=grid.grid[e[1]][e[2]][e[0]]
		if p==25: direction=0
		elif p==34: direction=-90
		elif p==52: direction=-180
		elif p==43: direction=-270
		ant=Ant(e[0], e[1], e[2], direction, t)
		t.append(ant)

def advance_ants():
	for e,ants in tubes.items():
		n=0
		last=1000000
		while n<len(ants):
			ant=ants[n]
			if ant.progress<=last-30:
				if ant.advance():
					n=n+1
				else:
					del ants[n]
			else:
				n=n+1
			last=ant.progress
			

def generate_state():
	p='#include "ant_pose.inc"\n'
	for e,ants in tubes.items():
		for ant in ants:
			p=p+ant.generate_model()+"\n"
	return p
			
for t in range(0, 1000):
	create_new_ants()
	f=file("state/state%03d.inc" % t, "w")
	f.write(generate_state())
	advance_ants()
	if (t==360): del blocked[(3,5,6)]
	if (t==730): blocked[(6,5,6)]=1
	print t
