#declare Apple = union {
	object {
		torus { 0.25, 0.5 translate y*0.5}
		texture {
			pigment {
				bozo
				turbulence 0.2
				lambda 6
				color_map  {
					[0.0 0.1 color rgb <1, 0.5, 0> color rgb <1, 0.5, 0>]
					[0.70 color rgb <1, 0.3, 0>]
					[1.0 color rgb <1, 0, 0>]
				}
				scale <0.02, 0.1, 0.02>
			}
			finish {
				ambient 0.25
				diffuse 0.8
			}
		}
		texture {
			pigment {
				gradient y
				color_map {
					[0 0.6 color rgb <1, 1, 0> color rgbf <1, 1, 1, 1>]
					[0.6 0.7 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
					[0.7 1 color rgbf <1, 1, 1, 1> color rgb <0.95, 1, 0>]
				}
			}
			finish {
				ambient 0.25
				diffuse 0.8
			}
		}
		translate -y*0.5
	}
	cone {
		<0, 0.3, 0>, 0.01
		<0, 0.8, 0>, 0.02
		texture {
			pigment {color rgb <0.2, 0.1, 0>}
			finish {ambient 0.25 diffuse 0.7 phong 0.2}
		}
	}
}

#declare Bite = plane {
	x, -0.5
	pigment {color rgb <0.95, 1, 0.75>}
	finish {ambient 0.4 phong 1 phong_size 50}
	normal {bumps 0.15 scale 0.02}
}

#declare Bitten_apple = object {
	difference {
		object {Apple}
		object {Bite rotate -z*20 rotate y*40}
	}
	translate z*0.25
	scale 0.2
	translate <0, 0.1, 1>
}

#declare Pear = object {
	blob {
		threshold 0.600000
		component 1.000000, 1.006428, <0, 2.204692, 0.000000>
		component 1.000000, 1.590798, <0, 0.922053, 0.000000>
		component 1.000000, 2.054459, <0, 0.028517, 0.000000>
		component 1.000000, 0.829366, <0, 1.508474, 0.000000>
	}
	pigment {color rgb <0.5, 0.6, 0>}
	normal {bumps 0.05 scale 0.05}
	finish {
		ambient 0.1
		diffuse 0.8
	}
	translate y*2
	scale 0.07
	rotate <30, -10, 0>
}

#declare Gr = object {
	sphere {<0, 0, 0>, 0.015}
	texture {
		pigment { color rgbf <0.1, 0.6, 0, 0.3> }
		finish {
			ambient 0.25
			phong 0.7 phong_size 10
			reflection 0.15
			refraction 1
			ior 1.5
		}
	}
}

#declare Grapes = object {
	union {
		object {Gr translate <-0.06, 0.157, 0.48>}	//1

		object {Gr translate <-0.06, 0.19, 0.495>}	//2
		object {Gr translate <-0.06, 0.19, 0.465>}

		object {Gr translate <-0.03, 0.205, 0.48>}

		object {Gr translate <-0.07, 0.22, 0.48>}	//3
		object {Gr translate <-0.06, 0.22, 0.51>}
		object {Gr translate <-0.06, 0.22, 0.45>}

		object {Gr translate <-0.045, 0.235, 0.465>}
		object {Gr translate <-0.045, 0.235, 0.495>}

		object {Gr translate <-0.07, 0.25, 0.495>}	//4
		object {Gr translate <-0.07, 0.25, 0.465>}
		object {Gr translate <-0.04, 0.25, 0.525>}
		object {Gr translate <-0.07, 0.25, 0.435>}

		object {Gr translate <-0.045, 0.265, 0.465>}
		object {Gr translate <-0.045, 0.265, 0.495>}

		object {Gr translate <-0.07, 0.28, 0.48>}	//5
		object {Gr translate <-0.06, 0.28, 0.51>}
		object {Gr translate <-0.07, 0.28, 0.45>}
		object {Gr translate <-0.07, 0.28, 0.42>}

		object {Gr translate <-0.045, 0.295, 0.435>}
		object {Gr translate <-0.045, 0.295, 0.465>}
		object {Gr translate <-0.045, 0.295, 0.495>}

		object {Gr translate <-0.07, 0.31, 0.495>}	//6
		object {Gr translate <-0.07, 0.31, 0.465>}
		object {Gr translate <-0.055, 0.31, 0.525>}
		object {Gr translate <-0.07, 0.31, 0.435>}

		object {Gr translate <-0.06, 0.34, 0.48>}	//7
		object {Gr translate <-0.05, 0.34, 0.51>}
		object {Gr translate <-0.07, 0.34, 0.45>}
		object {Gr translate <-0.06, 0.34, 0.42>}

		object {Gr translate <-0.04, 0.36, 0.495>}	//8
		object {Gr translate <-0.05, 0.36, 0.465>}
		object {Gr translate <-0.05, 0.36, 0.435>}
	}
	translate <-0.25, 0.07, -0.14>
}

#declare Half_lemon = object {
	difference {
		sphere {
			<0.5, 0.5, 0>, 0.5
			pigment {color rgb <0.9, 0.9, 0.1>}
			normal {bumps 0.4 scale 0.05}
			finish {ambient 0.25 phong 0.6}
		}
		plane {
			z, 0
			texture {
				pigment {
					image_map {
						gif "lemon.gif"
						once
						map_type 0
						interpolate 2
					}
				}
				finish { ambient 0.6 phong 0.6 }
				scale <1.01, 1.01, 1>
				translate <-0.005, -0.005, 1>
			}
			texture {
				pigment { color rgbf <1, 1, 1, 1> }
				normal {
					bump_map {
						gif "lemon_b.gif"
						once
						map_type 0
						interpolate 2
						use_color
						bump_size -0.4
					}
				}
			}
		}
	}
	scale <0.3, 0.3, 0.4>
}

#declare Slice = object {
	difference {
		cylinder {
			<0.5, 0.5, -0.1>, <0.5, 0.5, 0.05>, 0.5
			pigment {color rgb <0.9, 0.9, 0.2>}
			normal {bumps 0.4 scale 0.01}
			finish {ambient 0.25 phong 0.6}
		}
		plane {
			z, -0.05
			texture {
				pigment {
					image_map {
						gif "lemon.gif"
						once
						map_type 0
						interpolate 2
					}
				}
				finish { ambient 0.6 phong 0.6 }
				scale <1.01, 1.01, 1>
				translate <-0.005, -0.005, 1>
			}
			texture {
				pigment { color rgbf <1, 1, 1, 1> }
				normal {
					bump_map {
						gif "lemon_b.gif"
						once
						map_type 0
						interpolate 2
						use_color
						bump_size -0.3
					}
				}
			}
		}
	}
	scale 0.3
}

#declare Slices = union {
	object {Half_lemon}
	object {Slice rotate x*30 translate -z*0.15}
	object {Slice rotate x*90 translate <0, 0.017, -0.5>}
}

#declare Lemon = union {
	object {Slices rotate y*90 translate <0.1, 0.014, 1.1>}
	object {Plate scale <0.34, 0.35, 0.3> translate <-0.1, 0, 1>}
	scale 0.8
	translate <-0.15, 0, 0.8>
}








