#declare Chocolate = object {
	union {
		difference {
			object {
				box {<0, 0, 0>, <1, 0.25, 0.2>}
				texture {
					pigment {
						color rgb <0.9, 0.9, 1>
					}
					finish {ambient 0.3 reflection 0.8}
					normal {wrinkles 0.3 scale 0.2}
				}
			}
			plane {y, 0.248 inverse}
			pigment {color rgbf <1, 1, 1, 1>}
		}
		object {
			difference {
				object {
					box {<0, 0, 0>, <1, 1, 0.2>}
				}
				object {
					plane {y, 0.6 inverse}
					texture {
						pigment {
							image_map {
								gif "nuts.gif"
								map_type 0
								filter 1, 1
								interpolate 2
							}
							scale 0.27
							rotate x*90
							scale <1.2, 1, 1>
						}
						normal {bumps 0.2 scale 0.2}
						finish { ambient 0.3 phong 0.3}
					}
					rotate -x*10
				}
				cylinder {<0, -0.1, 0>, <0, 1.1, 0>, 0.05}
				cylinder {<1, -0.1, 0>, <1, 1.1, 0>, 0.05}
				cylinder {<1/3, -0.1, 0>, <1/3, 1.1, 0>, 0.05}
				cylinder {<2/3, -0.1, 0>, <2/3, 1.1, 0>, 0.05}

				cylinder {<-0.1, 0.2, 0>, <1.1, 0.2, 0>, 0.05}
				cylinder {<-0.1, 0.4, 0>, <1.1, 0.4, 0>, 0.05}
				cylinder {<-0.1, 0.6, 0>, <1.1, 0.6, 0>, 0.05}
				cylinder {<-0.1, 0.8, 0>, <1.1, 0.8, 0>, 0.05}
			}
			pigment {color rgb <0.2, 0.1, 0>}
			finish {ambient 0.3 phong 0.5 phong_size 40}
			scale 0.99
			translate <0.005, 0.005, 0.005>
		}
	}
	scale <0.3, 0.3, 0.1>
	rotate y*180
	rotate -x*90
	translate y*0.02
}

#declare Ashtray = object {
	difference {
		union {
			cylinder {<0, 0, 0>, <0, 0.005, 0>, 0.09}
			cone { <0, 0.005, 0>, 0.09, <0, 0.01, 0>, 0.08}
			cylinder {<0, 0.01, 0>, <0, 0.04, 0>, 0.08}
		}
		cylinder {<-0.1, 0.04, 0>, <0.1, 0.04, 0>, 0.015}
		cylinder {<0, 0.04, -0.1>, <0, 0.04, 0.1>, 0.015}
		cylinder {<0, 0.005, 0>, <0, 0.05, 0>, 0.06}
	}
	texture {
		PinkAlabaster
		finish {
			ambient 0.25
			phong 0.6
			phong_size 10
			reflection 0.2
		}
		scale 0.3
	}
}

#declare Cigarette1 = object {
	union {
		difference {
			object {
				cylinder {<-0.07, 0.006, 0>, <0.06, 0.006, 0>, 0.006}
				texture {
					pigment {color rgb <1, 1, 1>}
					normal {bumps 0.2 scale 0.01}
					finish {ambient 0.35}
				}
				texture {
					pigment {
						gradient x
						color_map {
						[0 1/3 color rgb <1, 0.6, 0> color rgb <1, 0.6, 0>]
						[1/3 1 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
						}
						scale <0.12, 1, 1>
						translate -x*0.06
					}
					normal {bumps 0.2 scale 0.01}
					finish {ambient 0.35}
				}
				texture {
					pigment {
						gradient x
						color_map {
						[0 0.2 color rgbf <1, 0, 0, 0.3> color rgbf <1, 1, 1, 1>]
						[0.2 0.9 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
						[0.9 1 color rgbf <1, 1, 1, 1> color rgbf <0.5, 0.5, 0.5, 0.2>]
						}
						scale <0.12, 1, 1>
						translate -x*0.06
					}
					finish {ambient 0.35}
				}
			}
			plane {x, -0.06 			//cap
				texture {
					pigment {color rgb <1, 1, 1>}
					normal {bumps 0.2 scale 0.01}
					finish {ambient 0.35}
				}
			}
		}
		object {						//ash
			sphere {<0.06, 0.006, 0>, 0.006
				 texture {
					pigment {
						gradient x
						color_map {
						[0 0.4 color rgb <1, 0, 0> color rgb <0.15, 0.15, 0.15>]
						[0.4 1 color rgb <0.15, 0.15, 0.15> color rgb <0.3, 0.3, 0.3>]
						}
						scale 0.006
						translate <0.06, 0.01, 0>
					}
					normal {bumps 0.2 scale 0.01}
					finish {ambient 1}
				 }
			}
		}
	}
}

#declare Cigarette2 = object {
	union {
		object {
			cylinder {<-0.07, 0.01, 0>, <0.06, 0.01, 0>, 0.006}
			texture {
				pigment {
					gradient x
					color_map {
					[0 1/3 color rgb <1, 0.6, 0> color rgb <1, 0.6, 0>]
					[1/3 1 color rgb <1, 1, 1> color rgb <1, 1, 1>]
					}
					scale <0.12, 1, 1>
					translate -x*0.06
				}
				normal {bumps 0.2 scale 0.01}
				finish {ambient 0.35}
			}
		}
		object {						//ash
			sphere {<0.06, 0.01, 0>, 0.006
				 texture {
					pigment {
						gradient x
						color_map {
						[0 0.4 color rgb <0.8, 0, 0> color rgb <0.3, 0.3, 0.3>]
						[0.4 1 color rgb <0.3, 0.3, 0.3> color rgb <0.3, 0.3, 0.3>]
						}
						scale 0.006
						translate <0.06, 0.01, 0>
					}
					normal {bumps 0.2 scale 0.01}
					finish {ambient 1}
				 }
			}
		}
		object {			// smoke
			blob {
				threshold 0.7
				component 1.0, 0.07, <0, -0.035, 0>
				component 1.0, 0.09, <-0.0625, 0.035, 0>
				component 1.0, 0.09, <0, 0.07, -0.0625>
				component 1.0, 0.1, <0.0625, 0.105, 0>
				component 1.0, 0.1, <0, 0.14, 0.0625>
				component 1.0, 0.1, <-0.0625, 0.175, 0>
				component 1.0, 0.1, <0, 0.21, -0.0625>
				component 1.0, 0.1, <0.0625, 0.245, 0>
				component 1.0, 0.1, <0, 0.28, 0.0625>
			}
			texture {
				pigment {
					marble
					color_map {
					[0.0 0.4 color rgbf <1, 1, 1, 1> color rgbf <0.9, 0.9, 0.9, 0.65>]
					[0.4 1.0 color rgbf <1, 1, 1, 0.7> color rgbf <1, 1, 1, 1>]
					}
					turbulence 0.8
				}
				finish { phong 0.2}
			}
			translate <0, 0.07, 0>
			scale <0.3, 1.6, 0.5>
			rotate -z*17
			translate <0.06, 0.01, 0>
		}

	}
}

#declare Smoking = object {
	union {
		object {Ashtray}
		object {
			Cigarette1
			translate -x*0.03
			rotate z*17
			translate <-0.08, 0.025, 0>
		}
		object {
			Cigarette2
			translate -x*0.03
			rotate z*17
			rotate y*180
			translate <0.08, 0.025, 0>
		}
	}
	scale 2
}

#declare Ring = object {
	union {
		difference {
			cylinder {<0, -0.07, -0.01>, <0, -0.07, 0.01>, 0.1}
			cylinder {<0, -0.07, -0.1>, <0, -0.07, 0.1>, 0.099}
			cylinder {<0, 0, 0>, <0, 0.2, 0>, 0.1 scale <0.5, 1, 1>}
		}
		union {
			difference {
				cylinder {<0, 0, 0>, <0, 0.05, 0>, 0.1}
				cylinder {<0, -0.1, 0>, <0, 0.06, 0>, 0.099}
			}
			difference {
				sphere {<0, 0, 0>, 0.099}
				plane {y, 0}
				texture {
					pigment { color rgbf <1, 0, 0, 0.8> }
					finish {
						ambient 0.25
						phong 0.8 phong_size 20
						reflection 0.5
						refraction 1
						ior 1.5
					}
				}
			}
			scale <0.5, 0.5, 1>
		}
	}
	pigment { color rgb <1, 0.7, 0.2> }
	finish {
		metallic
		ambient 0.25
		phong 1 phong_size 50
		reflection 0.2
	}
	translate <0, 0.17, 0.01>
}











