// Persistence Of Vision Raytracer version 2.0

#include "colors.inc"
#include "stones.inc"
#include "textures.inc"

#declare final = camera {  
   location <0, 0, -135>
   direction <0, 0, 1>
   look_at <0,10,0>
}

#declare test = camera {  
   location <0, 0, -55>
   direction <0, 0, 1>
   look_at <0,0,0>
}

camera {final}

light_source {<200, 50, -100> color White}
light_source {<201, 51, -100> color White}

#declare Deepness = color red 0.4 green 0.05 blue 0.5

#declare dendrite1 = merge {
#include "dendrite5.pov"
texture {Silver3}
}

#declare valleyobject = intersection {
	box {<-2,-90,-2>,<2,8,2>}
	plane {x, 1 rotate <0,0,-5> rotate <0,0,0>}
	plane {x, 1 rotate <0,0,-5> rotate <0,60,0>}
	plane {x, 1 rotate <0,0,-5> rotate <0,120,0>}
	plane {x, 1 rotate <0,0,-5> rotate <0,180,0>}
	plane {x, 1 rotate <0,0,-5> rotate <0,240,0>}
	plane {x, 1 rotate <0,0,-5> rotate <0,300,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,0,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,60,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,120,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,180,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,240,0>}
	plane {x, 3 rotate <0,0,30> rotate <0,300,0>}
	scale <4,4,4>
	texture {pigment {Gold}}
	}

#declare valley = union {
	#include "valleymaker.pov"
}

#declare alien_synapse = union {
	object {dendrite1 rotate<0,90,0>}
	object {dendrite1 rotate <0,-70,0> rotate <120,120,0>}
	object {dendrite1 rotate <120,-120,0>}
	object {dendrite1 rotate <0,120,0> rotate <120,0,0>}
	sphere {<0,0,0>,45 texture {Glass}}
}

object {alien_synapse rotate <5,20,7>}
object {alien_synapse rotate <-30,0,0> translate <90,25,80>}
object {valley translate <0,50,0>}
object {valley scale <1,-1,1> translate <0,50,0>}


background {color Deepness}
fog {distance 280 color Deepness}


