/*  astplant.pov    (The Asteroid Plant)  */
/* "Alien Worlds" image    John P. Beale <beale@jump.stanford.edu> 8/28/95  */

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
// #include "stones.inc"

//  x to the left,   y is into screen,    z is down
// -x to the right, -y is out of screen, -z is up

camera {
	location        <1, -.13, -.4>
	direction       <0, 0, 0.8>
//        direction       <0, 0, .9>
	up              <0, 0, 1>
	right           <4/3, 0, 0>
	look_at         <1, .5, -.2>
}

// based on 'brass_valley' texture
#declare P_splotch = 
 texture 
  {pigment    {granite
     color_map 
      {[0.0, 0.3   color DustyRose  color BlueViolet]
       [0.3, 0.6   color Black color BlueViolet]
       [0.6, 1.001 color Feldspar  color Quartz]
      }    }
   finish {metallic brilliance 5.0 reflection 0.8 diffuse 1.6 phong 0.8}
}

/*
/* yellowish light */
object { light_source { <3, -2, -0.5>  color red 1 green .75 blue .5
  area_light <0.2, 0, 0> <0,0,-2.5> 4, 14
  adaptive 1
  jitter
  } 
}
*/
/* yellowish light #2 */   /* was <3 -2 -.8> */
object { light_source { <3, -1, -1>  color red 1 green .75 blue .5 } }

/*
/* reddish light */
object { light_source { <-3, -3, -.7> color red .35 green .14 blue .06
    area_light <.5, -.5, 0> <0, 0, -1> 4, 20
    adaptive 1
    jitter
   }
}

*/

/* sky background fill light */
object { light_source { <1, .5, -10>  color red .07 green .15 blue .25
  spotlight
  point_at <1,0.3,0>
  radius 2.5
  falloff 5
  } 
}

/* foreground landscape heightfield */
object {
	 height_field {tga "topo2.tga" }
	 scale < 2, 0.25, 1 >              // reduce height (was ys=0.20)
	 rotate < -90, 0, 0 >              // flip up from xz plane to xy plane
	 translate < 0, 0, 0 >
	 texture { 
		      pigment {color White}
		      finish { diffuse 1 ambient 0.02 }
		    }
       } /* end object */

/* a cratered moon */
object {
#include "moon.inc"
  rotate <0,-90,0>   /* rotate pole to vertical */
  scale <0.12,0.12,0.12>
  translate <1.0,1.2,-0.4> 
  texture {  pigment {color red .45 green .6 blue .8}
		    finish { diffuse 1.2 ambient 0.02 }
	 }
}

/* an asteroid field */
union{
#include "ast.inc"
   // rotate <0,0,0>
   texture {  pigment {color red .45 green .6 blue .8}
		    finish { diffuse 1.4 ambient 0.02 }
	 }
}

/* Alien-looking plant. Thistle? Crystal? hmmm. */

object{             
   #include "spiky.inc"
   rotate <0,-90,0>
   scale <.022,.022,.022>
   translate <1.25,0.25,-0.32>
   texture {P_splotch
            scale <0.05 0.05 0.05>
	   }
} 

/* spike/stem object */
object {
	 height_field {tga "stem.tga" }
	 translate <-.5, 0, -.5>          // center on x=0,z=0
	 scale <0.1,0.12,0.1>              // now 0.2 on a side, y=elevation
	 rotate < -90, 0, 0 >              // flip up from xz plane to xy plane
	 translate < 1.25,0.25,-0.18 >
	 texture {  pigment {color red .55 green .65 blue .9}
		    finish { diffuse 1.3 ambient 0.02 
			     phong 0.5 phong_size 150 metallic }
	 }
} /* end object */
