// Persistence Of Vision raytracer version 2.2.

//****************** AN AERO BIKE ********************* Vaughn Dettmann '95

#include "colors.inc"
#include "surfaces.inc"
#include "textures.inc"
#include "shapes.inc"

#declare BCURVE = intersection {
 torus { 5, .8  rotate x*90 }
  plane { x, 1 rotate  z*0 }
  plane { x, 1 rotate z*-90 }
   bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { My_Chrome2 }}

#declare BAR = union {
 object { BCURVE }
 cylinder { <0, 5, 0>, <8, 5, 0>, .8 }
 cylinder { <-5, 0, 0>, <-5, -15, 0>, .8 }
 object { Ellipsoid scale <.5, 1.2, 1.2> translate <8, 5, 0> }  
 object { Ellipsoid scale <.5, 1.4, 1.4> translate <2, 5, 0> }  
  texture { My_Chrome2 }}

#declare HANDLEBARS = union {
 object { BAR translate x*8 }
 object { BAR rotate y*180 translate x*-8 }}

#declare SCURVE = intersection {
 torus { 15, 8 rotate x*90 }
  plane { x, 1 rotate  z*40 }
  plane { x, 1 rotate z*-40 }
   bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { My_Chrome4 }}

#declare SEAT = 
 object { SCURVE rotate y*90 }

#declare PEGS = union {
 cylinder { <-17, 0, 0>, <17, 0, 0>, 1 }
 object { Ellipsoid scale <.7, 1.4, 1.4> translate <-17, 0, 0> }  
 object { Ellipsoid scale <.7, 1.4, 1.4> translate <17, 0, 0> }
 object { Ellipsoid scale <.7, 1.9, 1.9> translate <-7, 0, 0> }  
 object { Ellipsoid scale <.7, 1.9, 1.9> translate <7, 0, 0> }
  texture { My_Chrome2 }}

#declare C1 = difference {
 object { Ellipsoid scale <12, 9, 22> }
 box { <-15, -15, -20>, <15, -3, 20> }  
 object { Ellipsoid scale <4, 2, 15> rotate z*5 translate <-5, 1, -20> }  
 object { Ellipsoid scale <4, 2, 15> rotate z*-5 translate <5, 1, -20> }
  bounded_by { sphere { <0, 0, 0>, 40 }}
   texture { My_Chrome5 }}
  
#declare LIGHTS = 
 object { Ellipsoid scale <11.8, 8.8, 21.8>
  pigment { Cyan } finish  { diffuse 0 ambient 1 }}

#declare C2 = union {
 object { C1 }
 object { C1 scale <1, .8, 1.2>  rotate <-10, 0, 180> translate y*-4 }
 object { LIGHTS }
  bounded_by { sphere { <0, 0, 0>, 40 }}}

#declare COWLING = difference {
 object { C2 }
 object { Ellipsoid scale <7, 4, 11> translate <-7, -3, -3> }  
 object { Ellipsoid scale <7, 4, 11> translate <7, -3, -3> }
  bounded_by { sphere { <0, 0, 0>, 40 }}
   texture { My_Chrome5 }}

#declare SUPPORT = union {
 object { BCURVE }
 cylinder { <-5, 0, 0>, <-5, -20, 0>, .8 }
  texture { My_Chrome2 }}

#declare SUPPORTS = union {
 object { SUPPORT rotate y*2 translate x*10.5 }
 object { SUPPORT rotate y*178 translate x*-10.5 }}

#declare FRONTFIN = difference {
 object { Ellipsoid scale <2, 2, 13> }
 object { Ellipsoid scale <2, 2, 15> translate <-.5, -.5, 0> }}

#declare FINS = union {
 object { FRONTFIN rotate <0, 7, 0>  translate x*11 }
 object { FRONTFIN rotate <0, -187, 0> translate x*-11 }
   texture { My_Chrome4 }}

#declare TANK = union {
 object { Ellipsoid scale <5, 3, 10> translate <0, 4, 9> } 
 object { Ellipsoid scale <9, 6, 15> }  
 object { Ellipsoid scale <10, 6, 17> rotate x*-4 translate y*-1 }
   texture { My_Chrome5 }}

#declare TAIL = union {
 object { Ellipsoid scale <5, 2, 7> translate <0, 3, 9> } 
 object { Ellipsoid scale <6, 4, 10> }  
 object { Ellipsoid scale <7, 5, 13> rotate x*4 translate <0, -1, 5> }
   texture { My_Chrome5 }}

#declare FCURVE = intersection {
 torus { 5, .8  rotate x*90 }
  plane { x, 1 rotate  z*10 }
  plane { x, 1 rotate z*-110 }
   bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { My_Chrome5 }}

#declare FRAME = 
 object { FCURVE scale 6 rotate y*-90 }

#declare FOIL =
 object { Ellipsoid scale <6, 3, 15> 
  texture { My_Chrome5 }}

#declare WINDSHIELD = difference {
 object { Ellipsoid scale <10, 8, 21> }
 object { Ellipsoid scale <15, 6, 10> translate z*17 }
 box { <-15, -15, -20>, <15, 0, 20> }  
  bounded_by { sphere { <0, 0, 0>, 40 }}
   texture { My_Chrome3 } texture { pigment { image_map { 
   gif "grid.gif" map_type 2 filter 251 1 } scale 20 }
    finish {
     ambient .3
     diffuse .7
     reflection .35
     brilliance 8
     specular .8
     roughness .01 }}}

#declare BUBBLE = union {
 object { Ellipsoid scale <5, 2.5, 9> translate <-5.7, -3, -3> }  
 object { Ellipsoid scale <5, 2.5, 9> translate <5.7, -3, -3> }
  texture { My_Chrome3 } texture { pigment { image_map { 
  gif "grid.gif" map_type 2 filter 251 1 } scale 20 }
   finish {
     ambient .3
     diffuse .7
     reflection .2
     brilliance 8
     specular .8
     roughness .0001 }}}

#declare FRAME2 = difference {
 box { <-3, -9, -14>, <3, 8.1, 10> }  
 cylinder { <-10, 5, 0>, <10, 5, 0>, 8 translate <0, -10, 14> }
 cylinder { <-10, 5, 0>, <10, 5, 0>, 9 translate <0, -11, -17> }
     texture { My_Chrome6 }} 

#declare FORKS = union {
 object { SUPPORTS rotate x*-110 translate <0, -53, -63> }
 object { FINS rotate x*-5 translate <0, -54.2, -63> }}

#declare AEROBIKE = union { 
 object { HANDLEBARS rotate x*45 translate <0, -18.5, -11> }
 object { SEAT rotate x*90 translate <0, -22, 19> }
 object { PEGS translate <0, -48, 29.5> }
 object { FORKS rotate x*3 translate <0, -1, 3> } 
 object { COWLING rotate x*-20 translate <0, -36, -35> }
 object { WINDSHIELD rotate x*-20 translate <0, -31, -30> }
 object { BUBBLE rotate x*-24 translate <0, -36.7, -36> }
 object { TANK translate <0, -30, -5> }
 object { TAIL rotate y*180 translate <0, -29, 40> }
 object { FRAME rotate x*55 translate <0, -65, -5> }
 object { FOIL  rotate x*-14 translate <0, -48, 21> }
 object { FINS scale 1.2 rotate y*180 translate <0, -30, 35> }
 object { FRAME2 scale 1 translate <0, -37, 23> }}
