// Persistence Of Vision raytracer version 2.2.

//***** A SPACE MARINE SITTING FOR AEROBIKE *********** Vaughn Dettmann '95

#include "colors.inc"
#include "surfaces.inc"
#include "textures.inc"
#include "shapes.inc"
#include "neck.inc"

#declare M1 = intersection {
 object { Ellipsoid scale <3, 2.5, 2> }
  plane { z, 1 inverse }
     texture { Gold_Tex }}

#declare CENTER =
 object { Ellipsoid scale <2.8, 2.2, 2> 
     texture { Polished_Chrome }}

#declare W1 = difference {
 object { Ellipsoid  scale <2, 5, 9> }  
 object { Ellipsoid  scale <3, 6, 13> 
    rotate z*5 translate <2, 0, 0> }
     texture { Gold_Tex }}

#declare WING = intersection {
 object { W1 }
  plane { z, .5  }
  plane { z, -.5 inverse }
  plane { y, -1 inverse }
     texture { Gold_Tex }}

#declare M2 = union {
 object { M1 }
 object { WING rotate z*-80 translate <2.1, 0, 1.5> }
 object { WING rotate <0, 180, 80> translate <-2.1, 0, 1.5> }
 object { WING rotate z*-90 translate <1.5, -1, 1.5> }
 object { WING rotate <0, 180, 90> translate <-1.5, -1, 1.5> }
 object { WING rotate z*-100 translate <0, -1.6, 1.5> }
 object { WING rotate <0, 180, 100> translate <0, -1.6, 1.5> }}

#declare  MEDAL = union {
 object { CENTER translate <0, 0, 2.2> }
 object { M2 }}

#declare S1 = difference {
 object { Ellipsoid 
   scale <5.6, 6, 7> 
 texture { Gold_Tex }}
     box { <-15, -5, -15>, <15, 5, 15> translate < 0, -8.3, 0 >
      pigment { Black }}}

#declare DIFF =intersection {
 object { Ellipsoid
   scale <5.6, 6, 7> }
  plane { z, -1.8 rotate 20*x }  
  plane { y, -1.8 inverse }
  plane { y, 1.26 }
   texture { Gold_Tex }}

#declare V1 =intersection {
 object { Ellipsoid scale <5.5, 6, 6.9> }
  plane { z, -1.8 rotate 20*x }  
  plane { y, -1.8 inverse }
  plane { y, 1.26 }
   texture { Glass }}

#declare DIFFV2 =intersection {
 object { Ellipsoid scale <5.45, 5.95, 6.85> }
  plane { z, -1.8 rotate 20*x }  
  plane { y, -1.8 inverse }
  plane { y, 1.26 }
   texture { Glass }}

#declare VISOR = difference {
 object { V1 }
 object { DIFFV2 }}

#declare SHELL = difference {
 object { S1 }
 object { S1 scale <.9, .9, .9 > }
 object { DIFF scale <1.1, 1.1, 1.1> }}

#declare CHIN = difference {
 object { Ellipsoid
   scale <5.6, 7, 7> }
    sphere { <0, 7, 1>, 10 }  
     texture { Gold_Tex }}

#declare CHINPIECE = intersection {
 object { CHIN }
  plane { y, -3 inverse }}

#declare HELMET = union {
 object { SHELL }
 object { VISOR rotate x*8 translate <0, -.5, .5> }
 object { CHINPIECE rotate x*-10 translate <0, -1.5, -.4> }}

#declare UPPER = union {
//Torso
  object { Ellipsoid scale <7, 15, 6> translate <0, -20, 0> }
  object { Ellipsoid scale <10, 8, 5> translate <0, -12.6, 0> }
//Trap muscles
 object { Ellipsoid scale <2.7, 5.5, 3.5> 
    rotate z*-65 translate <-9, -10, -.3> }
 object { Ellipsoid scale <2.7, 5.5, 3.5> 
    rotate z*65 translate <9, -10, -.3> }
//Pecs
  object { Ellipsoid scale <5.6, 4, 1.5> 
     rotate <14, -5, 0> translate <4.7, -11.3, -4> }
  object { Ellipsoid scale <5.6, 4, 1.5> 
     rotate <14, 5, 0> translate <-4.7, -11.3, -4> }
//Collar bones
  object { Ellipsoid scale <3.7, 1, 1> 
     rotate <0, -11, 6> translate <3.7, -7.8, -3.23> }
  object { Ellipsoid scale <3.7, 1, 1> 
     rotate <0, 11, -6> translate <-3.7, -7.8, -3.23> }
   texture { My_Chrome }}

#declare UPPER2 = difference {
//Stomach pit
 object { UPPER }
 object { Ellipsoid scale <5, 7, 5> translate <0, -22, -5>
 texture { My_Chrome }}}

#declare TORSO1 = union {
//Ab muscles
 object { UPPER2 }
 object { Ellipsoid scale <3.5, 2.5, 2> translate <2, -19, -2.8> }
 object { Ellipsoid scale <3.5, 2.5, 2> translate <-2, -19, -2.8> }
 object { Ellipsoid scale <3.3, 2.5, 2> translate <2, -21.2, -3.2> }
 object { Ellipsoid scale <3.3, 2.5, 2> translate <-2, -21.2, -3.2> }
 object { Ellipsoid scale <3.1, 2.5, 2> translate <2, -23.2, -3.1> }
 object { Ellipsoid scale <3.1, 2.5, 2> translate <-2, -23.2, -3.1> }
//Rib muscles
 object { Ellipsoid scale <1.5, .5, .5> 
             rotate <0, -15, 24> translate <6.7, -16.5, -2.7> }
 object { Ellipsoid scale <1.5, .5, .5> 
             rotate <0, 15, -24> translate <-6.7, -16.5, -2.7> }
 object { Ellipsoid scale <1.2, .5, .5> 
             rotate <0, -15, 24> translate <6.3, -17.3, -3> }
 object { Ellipsoid scale <1.2, .5, .5> 
             rotate <0, 15, -24> translate <-6.3, -17.3, -3> }
 object { Ellipsoid scale <1, .5, .5> 
             rotate <0, -15, 24> translate <5.7, -18.3, -3> }
 object { Ellipsoid scale <1, .5, .5> 
             rotate <0, 15, -24> translate <-5.7, -18.3, -3> }
   texture { My_Chrome }}

#declare TORSO = intersection {
 object { TORSO1 }
  plane { y, -28 inverse }
   texture { My_Chrome }}

#declare WRISTBAND = intersection {
 object { Ellipsoid scale <2, 10, 2> }
  plane { y, -.5 }
  plane { y, -6 inverse }
   texture { Gold_Tex }}

#declare HAND = union {
 object { Ellipsoid scale <2, 1.2, 2.8> translate y*.6 }
 object { Ellipsoid scale <1.8, 1.3, 1.3> translate z*-1.5 }
 sphere { <-1.5, 0, -2.5>, .62 }
 sphere { <-.5, 0, -2.6>, .67 }
 sphere { <.5, 0, -2.6>,  .67 }
 sphere { <1.5, 0, -2.5>, .62 }
 cylinder { <0, -2.6, 0>, <0, 0, 0>, .5 translate <-1.5, 0, -2.4> } 
 cylinder { <0, -2.7, 0>, <0, 0, 0>, .5 translate <-.5, 0, -2.6> }
 cylinder { <0, -2.7, 0>, <0, 0, 0>, .5 translate <.5, 0, -2.6> }
 cylinder { <0, -2.6, 0>, <0, 0, 0>, .5 translate <1.5, 0, -2.4> }
 sphere { <-1.5, -2.5, -2.5>, .6 }
 sphere { <-.5, -2.6, -2.6>, .6 }
 sphere { <.5, -2.6, -2.6>,  .6 }
 sphere { <1.5, -2.5, -2.5>, .6 }
 cylinder { <-1.5, -2.5, -2.3>, <-1.4, -2, -.5>, .5 } 
 cylinder { <-.5, -2.6, -2.5>, <-.4, -2, -.5>, .5 }
 cylinder { <.5, -2.6, -2.5>, <.4, -2, -.5>, .5 }
 cylinder { <1.5, -2.5, -2.4>, <1.4, -2, -.5>, .5 }
  texture { Gold_Tex }}
 
#declare R_ARM = union {
//shoulder
 object { Ellipsoid scale <3.5, 4.5, 3.9> 
             rotate <-13, 0, -25> translate <-11.2, -12.2, -.3> }
//tricep
object { Ellipsoid scale <3.1, 6, 3.2> 
             rotate <-15.5, 0, -20> translate <-11.8, -17, 2.3> }
//bicep
 object { Ellipsoid scale <3, 6, 3.6> 
             rotate <-16, 0, -20> translate <-11.75, -16.3, 1.7> }
//forearm
 object { Ellipsoid scale <2.8, 5, 2.5> 
             rotate <105, 0, -10> translate <-11.7, -21, -1.5> }
 object { Ellipsoid scale <1.5, 4, 1.5> 
             rotate <108, 5, -10> translate <-13, -21, -1.5> }
 object { Ellipsoid scale <1.8, 6, 1.7> 
             rotate <107, 0, -10> translate <-11.5, -20.9, -4.5> }
//elbow
 object { Ellipsoid scale <2.2, 3, 2.2> 
    rotate x*100 translate <-11.6, -21,2> }
 object { Ellipsoid scale <2.2, 3, 2.2> 
    rotate x*100 translate <-12.3, -21,2> }
 object { WRISTBAND rotate <107, 1, -10> translate <-11.5, -20.4, -5.7> }
 object { HAND rotate <15, 0, 10> translate <-11.5, -19, -13> }
   texture { My_Chrome }}

#declare L_ARM = union {
//shoulder
 object { Ellipsoid scale <3.5, 4.5, 3.9> 
             rotate <-13, 0, 25> translate <11.2, -12.2, -.3> }
//tricep
object { Ellipsoid scale <3.1, 6, 3.2> 
             rotate <-15.5, 0, 20> translate <11.8, -17, 2.3> }
//bicep
 object { Ellipsoid scale <3, 6, 3.6> 
             rotate <-16, 0, 20> translate <11.75, -16.3, 1.7> }
//forearm
 object { Ellipsoid scale <2.8, 5, 2.5> 
             rotate <105, 0, 10> translate <11.7, -21, -1.5> }
 object { Ellipsoid scale <1.5, 4, 1.5> 
             rotate <108, -5, 10> translate <13, -21, -1.5> }
 object { Ellipsoid scale <1.8, 6, 1.7> 
             rotate <107, 0, 10> translate <11.5, -20.9, -4.5> }
//elbow
 object { Ellipsoid scale <2.2, 3, 2.2> 
    rotate x*100 translate <11.6, -21, 2> }
 object { Ellipsoid scale <2.2, 3, 2.2> 
    rotate x*100 translate <12.3, -21, 2> }
 object { WRISTBAND rotate <107, -1, 10> translate <11.5, -20.4, -5.7> }
 object { HAND rotate <15, 0, -10> translate <11.5, -19, -13> }
   texture { My_Chrome }}

#declare WAIST1 = union {
  object { Ellipsoid scale <5.4, 7, 5.2> translate <2, 0, .5> }
  object { Ellipsoid scale <5.4, 7, 5.2> translate <-2, 0, .5> }
   texture { My_Chrome }}

#declare WAIST2 = difference {
 object { WAIST1 }
  object { Ellipsoid scale <15, 5, 14> translate <0, 8, 0> }
  object { Ellipsoid scale <4.5, 4.3, 4> translate <4, -4, -1.5> }
  object { Ellipsoid scale <4.5, 4.3, 4> translate <-4, -4, -1.5> }}

#declare WAIST = union {
 object { WAIST2 }
 object { Ellipsoid scale <5, 6.5, 5.2> translate <2.1, 1, 1.8> }
 object { Ellipsoid scale <5, 6.5, 5.2> translate <-2.1, 1, 1.8> }
 object { Ellipsoid scale <3.2, 3.6, 2.4> translate y*2 
  rotate x*-5 translate <.6, -1.5, -3.5>}
   texture { My_Chrome }}

#declare CURVE = intersection {
 torus { 5, 2.5  rotate x*90}
  plane { x, 1 rotate  z*-43  }
  plane { x, 1 rotate z*43  }
   bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { My_Chrome }}

#declare B1 =  intersection {
 object { Ellipsoid scale <4, 16, 4.6> translate <0, 3.5, 0> }
  plane { y, 2 rotate x*-30 }
  plane { y, -10 inverse }
   texture { Gold_Tex }}

#declare CURVE2 = intersection {
 torus { 5, 2.5  rotate x*90 }
  plane { x, 1 rotate  z*-23  }
  plane { x, 1 rotate z*73  }
   bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { Gold_Tex }}

#declare FOOT = intersection {
 object { Ellipsoid scale <3.1, 3.2, 7> }
  plane { y, -1 inverse }
  bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { Gold_Tex }}

#declare HEEL = intersection {
 object { Ellipsoid scale <2.8, 4, 3.6> }
  plane { y, -3 inverse }
  bounded_by { sphere { <0, 0, 0>, 10 }}
    texture { Gold_Tex }}

#declare BOOT = union {
 object { B1 }
 object { CURVE2 rotate y*90 translate <0, -7.4, -5.8> }
 object { FOOT rotate x*-10 translate <0, -13.5, -5.4> }
 object { HEEL rotate x*-11 translate <0, -10.8, 0> }}

#declare LEG = union {
//thigh
 object { Ellipsoid scale <4.6, 12.4, 4.95>
    rotate <65, 0, 7> translate <0, -38.3, -2.2> }
 object { Ellipsoid scale <4, 10.6, 4.8> 
    rotate <65, 0, 7> translate <0, -37.82, -2.8> }
//knee
 object { Ellipsoid scale <2.2, 3.4, 2> 
    rotate x*3 translate <0, -44.6, -12> }
 object { Ellipsoid scale <1.4, 2.7, 1.6> 
    rotate x*-13 translate <0,-49, -11> }
 object { CURVE rotate y*-90 translate <0, -46.7, -4> }
//calf
 object { Ellipsoid scale <3, 7, 3.5> 
    rotate x*-27 translate <0, -54, -4.6> }
 object { Ellipsoid scale <3,  8,  2> 
    rotate x*-35 translate <0, -56.7, -6> }
 object { BOOT rotate x*-31 translate <0, -56, -4> }
   texture { My_Chrome }}

#declare MARINE = union {
 object { HELMET scale 1.03 rotate x*20 translate <0, -.55, 2.25> } 
 object { NECK scale <4.8, 4.6, 4> rotate x*3 translate <0, -3, 0> }
 object { L_ARM rotate <45, -10, 10> translate <-2.85, -5.8, 6.3> }
 object { R_ARM rotate <45, 10, -10> translate <2.85, -5.8, 6.3> }
 object { TORSO }
 object { WAIST rotate x*10 translate <0, -30, -1> }
 object { LEG scale <1.1, .8, .85> 
    rotate <20, -25, 5> translate <0, -3.5, 6> }
 object { LEG scale <1.1, .8, .85 > 
    rotate <20, 25, -5> translate <-0, -3.5, 6> }
 object { MEDAL scale <.6, .6, .6> rotate x*1 translate <0, -8, -5.5> }}
