#declare Skin = texture {
	pigment {
		granite
		color_map {
		[0 0.8 color rgb <0.5, 0.4, 0> color rgb <0.3, 0.2, 0>]
		[0 0.8 color rgb <0.3, 0.2, 0> color rgb <0.2, 0.1, 0>]
		}
	}
	finish {ambient 0.2 phong 0.5 phong_size 60}
	normal {bumps 0.4 scale 0.04}
	scale 0.2
}

#declare Neck = blob {
   threshold 0.6
   component 1, 0.450201, <0, 0, 0>
   component 1, 0.419278, <0, -0.007605, 0.159627>
   component 1, 0.397752, <0, -0.022814, 0.311652>
   component 1, 0.397752, <0, 0.007605, 0.442748>
   component 1, 0.397752, <0, 0.022814, 0.580153>
   component 1, 0.397752, <0, 0.053232, 0.732824>
   component 1, 0.359524, <0, 0.114068, 0.870229>
   component 1, 0.359524, <0, 0.174905, 0.977099>
   component 1, 0.359524, <0, 0.235741, 1.099237>
   component 1, 0.341123, <0, 0.311787, 1.193399>
   component 1, 0.330483, <0, 0.448669, 1.315019>
   component 1, 0.312168, <0, 0.631179, 1.375829>
   component 1, 0.304672, <0, 0.798479, 1.436639>
   component 1, 0.298399, <0, 0.965779, 1.482247>
   component 1, 0.287764, <0, 1.133080, 1.497449>
   component 1, 0.381259, <0, 1.294601, 1.508091>
   component 1, 0.615346, <0, 1.572015, 1.512956>
   component 1, 0.304672, <0, 1.591483, 1.240526>
   component 1, 0.204935, <0, 1.591483, 1.084853>
   component 1, 0.143215, <0.21, 1.73, 1.707548>
   component 1, 0.143215, <-0.21, 1.73, 1.707548>
   component 1, 0.289824, <0.007601, 1.552548, 1.795115>

	texture {Skin scale <1, 0.8, 0.8>}
}

#declare Head = union {
	object {Neck scale 0.2}
	sphere {		// left eye
		<0.21, 1.73, 1.76>, 0.07
		pigment {color rgb <1, 1, 1>}
		finish {ambient 0.3 phong 1}
		scale 0.2
	}
	sphere {		// right eye
		<-0.21, 1.73, 1.76>, 0.07
		pigment {color rgb <1, 1, 1>}
		finish {ambient 0.3 phong 1}
		scale 0.2
	}
	difference {	// high jaw
		sphere {<0, 0, 0>, 0.2}
		sphere {<0, 0, 0>, 0.19
			pigment {color rgb <1, 0, 0>}
			finish {ambient 0.3 phong 1}
		}
		plane {y, 0}
		plane {z, 0}
		scale <0.15, 0.2, 2>
		translate <0, 0.314, 0.32>
	}
	difference {	// low jaw
		sphere {<0, 0, 0>, 0.2}
		sphere {<0, 0, 0>, 0.19
			pigment {color rgb <1, 0, 0>}
			finish {ambient 0.3 phong 1}
		}
		plane {-y, 0}
		plane {z, 0}
		scale <0.12, 0.18, 1.8>
		rotate x*20
		translate <0, 0.314, 0.32>
	}
	translate z*0.18
	pigment {color rgb <0.85, 0.85, 0.6>}
	finish {ambient 0.2 phong 1 phong_size 30}
}

#declare Wing = object {
	union {
		difference {
			box {<0, -0.0001, 0>, <1.3, 0.0001, 0.6>}
			plane {-z, 0 rotate y*8.07 translate <0.6, 0, 0.6>}
			plane {-z, 0 rotate -y*34 translate <0.6, 0, 0.6>}
			cylinder {<1.36, -0.1, 0>, <1.36, 0.1, 0>, 0.5}
			cylinder {<0.81, -0.1, -0.29>, <0.81, 0.1, -0.29>, 0.5}
			cylinder {<0.355, -0.1, -0.48>, <0.355, 0.1, -0.48>, 0.6}
		}
		sphere {<0, 0, 0>, 0.707/2
			translate <0.707/2, 0, 0>
			scale <1, 0.02, 0.02>
			rotate y*8.07
			translate <0.6, 0, 0.6>
		}
		sphere {<0, 0, 0>, 0.5/2
			translate <0.5/2, 0, 0>
			scale <1, 0.03, 0.03>
			rotate y*53.13
			translate <0.6, 0, 0.6>
		}
		sphere {<0, 0, 0>, 0.51/2
			translate <0.51/2, 0, 0>
			scale <1, 0.03, 0.03>
			rotate y*101.3
			translate <0.6, 0, 0.6>
		}
		sphere {<0, 0, 0>, 0.72/2
			translate <0.72/2, 0, 0>
			scale <1, 0.03, 0.03>
			rotate y*146
			translate <0.6, 0, 0.6>
		}
	}
	texture {Skin}
}

#declare Body = sphere {
	<0, 0, 0>, 0.2
	scale <0.6, 0.6, 1>
	translate z*0.1
	texture {Skin scale <1, 1, 0.8>}
}

#declare Leg = blob {
   threshold 0.600000
   component 1.000000, 0.800749, <0.007601, 0.007605, 0.000000>
   component 1.000000, 0.417632, <0.007601, -0.311787, -0.448475>
   component 1.000000, 0.416454, <0.007601, -0.494297, -0.782930>
   component 1.000000, 0.576629, <0.000000, -0.707224, -1.208601>
   component 1.000000, 0.340472, <0.007601, -0.988593, -0.896949>
   component 1.000000, 0.286504, <0.007601, -1.186312, -0.638506>
   component 1.000000, 0.339155, <0.007601, -1.528517, -0.220437>
   component 1.000000, 0.233210, <0.007601, -1.421141, 0.048648>
   component 1.000000, 0.206045, <0.007601, -1.382205, 0.204322>
   component 1.000000, 0.185656, <0.007601, -1.382205, 0.340537>
   component 1.000000, 0.147800, <0.007601, -1.421141, 0.437833>
   component 1.000000, 0.147800, <0.007601, -1.469810, 0.486481>
   component 1.000000, 0.147800, <0.007601, -1.547681, 0.544859>
   component 1.000000, 0.123014, <0.007601, -1.625551, 0.564318>
   component 1.000000, 0.099768, <0.007601, -1.701475, 0.564318>
   component 1.000000, 0.099768, <0.007601, -1.755985, 0.548751>
   component 1.000000, 0.233210, <-0.200857, -1.502294, 0.048648>
   component 1.000000, 0.185656, <-0.226362, -1.530160, 0.198484>
   component 1.000000, 0.147800, <-0.255056, -1.569095, 0.307456>
   component 1.000000, 0.147800, <-0.255056, -1.639179, 0.361942>
   component 1.000000, 0.123014, <-0.229551, -1.709262, 0.354158>
   component 1.000000, 0.099768, <-0.184916, -1.755985, 0.323023>
   component 1.000000, 0.083941, <-0.146657, -1.794920, 0.284105>
   component 1.000000, 0.286504, <0.007601, -1.338403, -0.425671>
   component 1.000000, 0.687755, <0.007601, 0.212928, 0.456076>
   component 1.000000, 0.148452, <0.007601, -1.597284, -0.405998>
   component 1.000000, 0.117361, <0.007601, -1.572366, -0.485703>
   component 1.000000, 0.095056, <0.007601, -1.582333, -0.575371>
   component 1.000000, 0.095056, <0.007601, -1.617219, -0.615223>
   component 1.000000, 0.074226, <0.007601, -1.667056, -0.635150>
   component 1.000000, 0.062983, <0.007601, -1.706926, -0.645113>
   component 1.000000, 0.062983, <0.007601, -1.746796, -0.625186>
   component 1.000000, 0.233210, <0.219189, -1.503092, 0.048648>
   component 1.000000, 0.185656, <0.243100, -1.534988, 0.198484>
   component 1.000000, 0.147800, <0.267012, -1.566884, 0.307456>
   component 1.000000, 0.147800, <0.263027, -1.638649, 0.361942>
   component 1.000000, 0.123014, <0.247086, -1.706428, 0.354158>
   component 1.000000, 0.099768, <0.219189, -1.750285, 0.323023>
   component 1.000000, 0.075105, <0.175351, -1.786167, 0.284105>

   pigment {color rgb <0.9, 0.7, 0.4>}
   finish {ambient 0.2 phong 0.3 phong_size 50}
   normal {bumps 0.4 scale 0.02}
}

#declare Tail = union {
	sphere { < -1.65922, 4.81250, -0.75195 > 0.11013}
	sphere { < -1.57158, 4.75000, -0.82054 > 0.11519}
	sphere { < -1.47687, 4.68750, -0.87898 > 0.12025}
	sphere { < -1.37624, 4.62500, -0.92652 > 0.12532}
	sphere { < -1.27096, 4.56250, -0.96259 > 0.13038}
	sphere { < -1.16232, 4.50000, -0.98674 > 0.13544}
	sphere { < -1.05167, 4.43750, -0.99866 > 0.14051}
	sphere { < -0.94038, 4.37500, -0.99822 > 0.14557}
	sphere { < -0.82983, 4.31250, -0.98542 > 0.15063}
	sphere { < -0.72139, 4.25000, -0.96040 > 0.15570}
	sphere { < -0.61640, 4.18750, -0.92350 > 0.16076}
	sphere { < -0.51616, 4.12500, -0.87515 > 0.16582}
	sphere { < -0.42191, 4.06250, -0.81597 > 0.17089}
	sphere { < -0.33482, 4.00000, -0.74668 > 0.17595}
	sphere { < -0.25597, 3.93750, -0.66814 > 0.18101}
	sphere { < -0.18633, 3.87500, -0.58133 > 0.18608}
	sphere { < -0.12678, 3.81250, -0.48732 > 0.19114}
	sphere { < -0.07803, 3.75000, -0.38727 > 0.19620}
	sphere { < -0.04071, 3.68750, -0.28243 > 0.20127}
	sphere { < -0.01527, 3.62500, -0.17408 > 0.20633}
	sphere { < -0.00202, 3.56250, -0.06358 > 0.21139}
	sphere { < -0.00114, 3.50000, 0.04770 > 0.21646}
	sphere { < -0.01262, 3.43750, 0.15840 > 0.22152}
	sphere { < -0.03634, 3.37500, 0.26713 > 0.22658}
	sphere { < -0.07199, 3.31250, 0.37256 > 0.23165}
	sphere { < -0.11914, 3.25000, 0.47337 > 0.23671}
	sphere { < -0.17719, 3.18750, 0.56832 > 0.24177}
	sphere { < -0.24544, 3.12500, 0.65623 > 0.24684}
	sphere { < -0.32303, 3.06250, 0.73601 > 0.25190}
	sphere { < -0.40900, 3.00000, 0.80667 > 0.25696}
	sphere { < -0.50230, 2.93750, 0.86735 > 0.26203}
	sphere { < -0.60176, 2.87500, 0.91728 > 0.26709}
	sphere { < -0.70615, 2.81250, 0.95585 > 0.27215}
	sphere { < -0.81418, 2.75000, 0.98258 > 0.27722}
	sphere { < -0.92451, 2.68750, 0.99715 > 0.28228}
	sphere { < -1.03578, 2.62500, 0.99936 > 0.28734}
	sphere { < -1.14661, 2.56250, 0.98919 > 0.29241}
	sphere { < -1.25562, 2.50000, 0.96678 > 0.29747}
	sphere { < -1.36146, 2.43750, 0.93239 > 0.30253}
	sphere { < -1.46283, 2.37500, 0.88645 > 0.30759}
	sphere { < -1.55846, 2.31250, 0.82953 > 0.31266}
	sphere { < -1.64718, 2.25000, 0.76234 > 0.31772}
	sphere { < -1.72788, 2.18750, 0.68571 > 0.32278}
	sphere { < -1.79957, 2.12500, 0.60058 > 0.32785}
	sphere { < -1.86135, 2.06250, 0.50801 > 0.33291}
	sphere { < -1.91246, 2.00000, 0.40916 > 0.33797}
	sphere { < -1.95228, 1.93750, 0.30523 > 0.34304}
	sphere { < -1.98030, 1.87500, 0.19753 > 0.34810}
	sphere { < -1.99618, 1.81250, 0.08738 > 0.35316}
	sphere { < -1.99972, 1.75000, -0.02386 > 0.35823}
	sphere { < -1.99087, 1.68750, -0.13480 > 0.36329}
	sphere { < -1.96976, 1.62500, -0.24407 > 0.36835}
	sphere { < -1.93663, 1.56250, -0.35031 > 0.37342}
	sphere { < -1.89191, 1.50000, -0.45222 > 0.37848}
	sphere { < -1.83613, 1.43750, -0.54852 > 0.38354}
	sphere { < -1.77001, 1.37500, -0.63804 > 0.38861}
	sphere { < -1.69434, 1.31250, -0.71965 > 0.39367}
	sphere { < -1.61008, 1.25000, -0.79234 > 0.39873}
	sphere { < -1.51825, 1.18750, -0.85523 > 0.40380}
	sphere { < -1.42001, 1.12500, -0.90752 > 0.40886}
	sphere { < -1.31657, 1.06250, -0.94857 > 0.41392}
	sphere { < -1.20921, 1.00000, -0.97787 > 0.41899}
	sphere { < -1.09925, 0.93750, -0.99506 > 0.42405}
	sphere { < -0.98807, 0.87500, -0.99993 > 0.42911}
	sphere { < -0.87703, 0.81250, -0.99241 > 0.43418}
	sphere { < -0.76752, 0.75000, -0.97260 > 0.43924}
	sphere { < -0.66089, 0.68750, -0.94075 > 0.44430}
	sphere { < -0.55845, 0.62500, -0.89724 > 0.44937}
	sphere { < -0.46149, 0.56250, -0.84262 > 0.45443}
	sphere { < -0.37119, 0.50000, -0.77756 > 0.45949}
	sphere { < -0.28869, 0.43750, -0.70288 > 0.46456}
	sphere { < -0.21499, 0.37500, -0.61948 > 0.46962}
	sphere { < -0.15102, 0.31250, -0.52842 > 0.47468}
	sphere { < -0.09756, 0.25000, -0.43081 > 0.47975}
	sphere { < -0.05528, 0.18750, -0.32787 > 0.48481}
	sphere { < -0.02469, 0.12500, -0.22086 > 0.48987}
	sphere { < -0.00619, 0.06250, -0.11112 > 0.49494}
	sphere { < 0.00000, 0.00000, 0.00000 > 0.50000}

	texture {Skin scale <1, 1, 0.8>}
	scale <0.1, 0.2, 0.1>
}

#declare Monster1 = union {
	object {Wing scale 1.25 rotate <-10, 0, 20> translate <0.04, 0.04, 0>}
	object {Wing scale 1.25 rotate <10, 0, 160> translate <-0.04, 0.04, 0>}
	object {Body}
	object {Tail rotate -x*90 translate <0, 0, -0.05>}
	object {Head}
	object {Leg scale <0.1, 0.15, 0.15> rotate x*20 translate <-0.1, -0.06, 0>}
	object {Leg scale <0.1, 0.15, 0.15> rotate x*20 translate <0.1, -0.06, 0>}
	scale 1.5
	no_shadow
}

#declare Monster2 = union {
	object {Wing scale 1.25 rotate z*10 translate <0.04, 0.04, 0>}
	object {Wing scale 1.25 rotate z*170 translate <-0.04, 0.04, 0>}
	object {Body}
	object {Tail rotate -x*110 translate <0, 0, -0.05>}
	object {Head}
	object {Leg scale <0.1, 0.15, 0.15> rotate -x*20 translate <-0.1, -0.06, 0>}
	object {Leg scale <0.1, 0.15, 0.15> rotate -x*20 translate <0.1, -0.06, 0>}
	scale 1.5
	no_shadow
}

#declare Monster3 = union {
	object {Wing scale 1.25 rotate <0, 0, 60> translate <0.04, 0.04, 0>}
	object {Wing scale 1.25 rotate <0, 0, 120> translate <-0.04, 0.04, 0>}
	object {Body}
	object {Tail rotate -x*90 translate <0, 0, -0.05>}
	object {Head}
	object {Leg scale <0.1, 0.15, 0.15> rotate -x*50 translate <-0.1, -0.06, 0.1>}
	object {Leg scale <0.1, 0.15, 0.15> rotate -x*50 translate <0.1, -0.06, 0.1>}
	scale 1.5
	no_shadow
}




