#declare Sea = plane {
	y, 0
	texture {
		pigment {color rgb <0, 0.5, 0.8>}
		finish { ambient 0.1 phong 1 phong_size 70 reflection 0.5}
		normal { bumps 0.08 scale <0.005, 0.1, 0.003>}
	}
}

#declare Sky = sphere {<0, 0, 0>, 1
	texture {
		pigment {
			gradient y
			color_map {
				[0.0 0.3 color rgb<1, 0.8, 0.7> color rgb<1, 0.5, 0.1>]
				[0.3 0.5 color rgb<1, 0.5, 0.1> color rgb<1, 0.3, 0.1>]
				[0.5 1.0 color rgb<1, 0.3, 0.1> color rgb<0.6, 0.1, 0>]
			}
		}
		finish {ambient 1.4}
	}
	texture {
		pigment {
			gradient z
			color_map {
				[0.0 0.4 color rgb<0, 0, 0.2> color rgb<0, 0, 0.4>]
				[0.4 0.85 color rgb<0, 0, 0.4> color rgbf<0, 0, 0.4, 1>]
				[0.85 1.0 color rgbf<0, 0, 0.4, 1> color rgbf<0, 0, 0.4, 1>]
			}
		}
		scale 2
		translate -z*1
		finish {ambient 1.4}
	}
	rotate <6, 0, -30>
	rotate -y*25
	scale <1000, 400, 1000>
}

#declare Clouds = plane {y, 20 inverse
	texture {
		pigment {
			bozo
			turbulence 0.5
			lambda 6
			color_map {
			[0.0 0.15 color rgbf <0.6, 0.7, 0.7, 0.7> color rgbf <0.6, 0.7, 0.7, 0.7>]
			[0.15 0.4 color rgbf <0.6, 0.7, 0.7, 0.7> color rgbf <0.8, 1, 1, 0.9>]
			[0.4 0.45 color rgbf <0.8, 1, 1, 0.9> color rgbf <1, 1, 1, 1>]
			[0.4 1.0 color rgbf <1, 1, 1, 1> color rgbf <1, 1, 1, 1>]
			}
		}
		finish { ambient 1 diffuse 0 }
		scale <10, 1, 7>
		translate z*10
	}
	no_shadow
}

#declare Lights = union {			// white lights
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*0 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*5 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*10 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*15 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*20 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*25 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*30 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*35 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*40 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*45 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*50 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*55 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*60 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*65 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*70 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*75 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*80 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*85 translate y*0.25}
	sphere {<0, 0, 0>, 0.0013 translate -x*0.198 rotate z*90 translate y*0.25}
	pigment {color rgb <1, 1, 1>}
	finish {ambient 3}
}

#declare Part = union {
	difference {
		union {
			cylinder {<-0.02, 0.05, -0.03>, <-0.02, 0.25, -0.03>, 0.0005}
			cylinder {<-0.04, 0.05, -0.03>, <-0.04, 0.25, -0.03>, 0.0005}
			cylinder {<-0.06, 0.05, -0.03>, <-0.06, 0.25, -0.03>, 0.0005}
			cylinder {<-0.08, 0.05, -0.03>, <-0.08, 0.25, -0.03>, 0.0005}
			cylinder {<-0.10, 0.05, -0.03>, <-0.10, 0.25, -0.03>, 0.0005}
			cylinder {<-0.12, 0.05, -0.03>, <-0.12, 0.25, -0.03>, 0.0005}
			cylinder {<-0.14, 0.05, -0.03>, <-0.14, 0.25, -0.03>, 0.0005}
			cylinder {<-0.16, 0.05, -0.03>, <-0.16, 0.25, -0.03>, 0.0005}
			cylinder {<-0.18, 0.05, -0.03>, <-0.18, 0.25, -0.03>, 0.0005}

			cylinder {<-0.02, 0.05, 0.03>, <-0.02, 0.25, 0.03>, 0.0005}
			cylinder {<-0.04, 0.05, 0.03>, <-0.04, 0.25, 0.03>, 0.0005}
			cylinder {<-0.06, 0.05, 0.03>, <-0.06, 0.25, 0.03>, 0.0005}
			cylinder {<-0.08, 0.05, 0.03>, <-0.08, 0.25, 0.03>, 0.0005}
			cylinder {<-0.10, 0.05, 0.03>, <-0.10, 0.25, 0.03>, 0.0005}
			cylinder {<-0.12, 0.05, 0.03>, <-0.12, 0.25, 0.03>, 0.0005}
			cylinder {<-0.14, 0.05, 0.03>, <-0.14, 0.25, 0.03>, 0.0005}
			cylinder {<-0.16, 0.05, 0.03>, <-0.16, 0.25, 0.03>, 0.0005}
			cylinder {<-0.18, 0.05, 0.03>, <-0.18, 0.25, 0.03>, 0.0005}
		}
		cylinder {<0, 0.25, -0.05>, <0, 0.25, 0.05>, 0.199}
	}
	difference {
		union {
			cylinder {<0, 0.25, -0.03>, <0, 0.25, 0.03>, 0.2}
			box {<-0.2, -0.05, -0.03>, <-0.192, 0.25, 0.03>}
		}
		cylinder {<0, 0.25, -0.1>, <0, 0.25, 0.1>, 0.198}
		plane {y, 0.25 inverse}
		plane {-x, 0}
		box {<-0.3, -0.1, -0.028>, <0.1, 0.25, 0.028>}
	}
	object {Lights translate z*0.03}
	object {Lights translate -z*0.03}
	texture {
		pigment {color rgb <0, 0.5, 0.4>}
		finish { ambient 0.2 phong 0.4}
	}
}

#declare Prolet = union {
	object {Part}
	object {Part rotate y*180 translate -x*0.4}
}

#declare Bridge = union {
	box {
		<-2, 0.05, -0.03>, <0, 0.048, 0.03>
		texture {
			pigment {color rgb <0, 0.5, 0.4>}
			finish { ambient 0.2 phong 0.4}
		}
	}
/*	sphere {<0, 0, 0>, 0.01
		translate <-1.44, 0.05+0.01, 0>
		pigment {color rgb <1, 0, 0>}
		finish {ambient 0.3 phong 1}
	}*/
	object {Prolet translate -x*0.6}
	object {Prolet translate -x*1.0}
	object {Prolet translate -x*1.4}
	no_shadow
	translate x*0.1
}

#declare Shore = difference {
	plane {y, 0.05}
	plane {x, 0}
	plane {z, 0.7 inverse}
	texture {
		pigment {
			granite
			color_map {
			[0 0.4 color rgb <0.2, 0.2, 0.2> color rgb <0.2, 0.2, 0.2>]
			[0.4 1 color rgb <0.5, 0.5, 0.5> color rgb <0.5, 0.5, 0.5>]
			}
		}
		finish { ambient 0.2 phong 0.2}
		scale 0.001
	}
	rotate -y*10
	translate <1.2, 0, -0.5>
}

#declare Mountain = object {
	height_field {
		tga "mount.tga" smooth
	}
	texture {
		pigment {color rgb <0.6, 0.5, 0.4>}
		finish {
			ambient 0.3
			specular .1
			phong 0.5
		}
	}
	scale <20, 4, 20>
	rotate -z*3
	translate <-11, -2, 15>
}














