// Persistence of Vision Raytracer Version 2.0
//Created by James Miller
// body and wing mounts for the generic TIE and TIE Advanced fighters

#include "d:\povray2\include\textures.inc"

#declare TFGray10 = color red 0.10 green 0.10 blue 0.10
#declare TFGray35 = color red 0.35 green 0.35 blue 0.35
#declare TFGray50 = color red 0.50 green 0.50 blue 0.50
#declare TFGray55 = color red 0.55 green 0.55 blue 0.55
#declare TFGray = color red 0.752941 green 0.752941 blue 0.752941
#declare TFClear = color red 1.0 green 1.0 blue 1.0 filter 1.0
#declare TFBlack = color red 0.0 green 0.0 blue 0.0
#declare TFRed = color red 1.0
#declare TFGlass3 = texture
	{pigment{color red 0.98 green 0.98 blue 0.98 filter 0.9}
	finish 
	{ambient 0.1
	diffuse 0.1
	specular 0.8
	reflection 0.1
	refraction 0.9
	ior 1.45
	roughness 0.0003
	phong 1 phong_size 400}
	}

#declare FST_Body=difference{
	object{sphere{<0,0,0>,.875}} //1 3/4 total
	object{union{
		object{sphere{<0,0,0>,.8125}
			pigment{TFBlack}
			texture {TFGlass3}} //1 3/4-1/16 make it hollow
		object{cylinder{<0,0,-.876>,<0,0,0>,.515625}} // front hole
		object{cylinder{<0,0,0>,<0,0,.876>,.5}} //back door
		object{intersection{ //top windows
			object{union{
				object{box{<.1875,0,1>,<.09375,.876,-.15>}}
				object{box{<-.1875,0,1>,<-.09375,.876,-.15>}}
				object{box{<.203125,0,1>,<.275625,.876,-.05>}}
				object{box{<-.203125,0,1>,<-.275625,.876,-.05>}}
				}}
			object{cylinder{<0,0,0>,<0,.877,0>,.28225}}
			}} //end intersection
		}} //end union
	texture{pigment {TFGray}} //end texture
	bounded_by{object{sphere{<0,0,0>,.876}}}
	} //end difference - object
//-----------------------------------------------------
//-----------------------------------------------------
#declare TF_top_one=intersection{
	object{union{
		object{difference{
			object{cylinder{<0,0,0>,<0,1.5,0>,.376}}
			object{difference{
				object{cylinder{<0,-.1,0>,<0,1.6,0>,.3135}}
				object{plane{z,0} translate z*-.0625}
				}}
			}}
		object{box{<-.0625,0,-.376>,<.0625,1.5,.376>}}
		}}
	object{sphere{<0,0,0>,.875} translate y*.03125}
	}
#declare TF_top_door=difference{
	object{TF_top_one}
	object{union{
		object{box{<-.25,-.1,0>,<-.0625,1.6,-.1875>}}
		object{box{<.0625,-.1,0>,<.25,1.6,-.1875>}}
		}}
	pigment{TFGray35}
	}
//-----------------------------------------------------
//-----------------------------------------------------
#declare TF_wingmount_one=difference{
	object{box{<0,0,-.0625>,<.3125,.5,.0625>}}
	object{union{
		object{plane{y,0}
			rotate z*-194.03625//14.036249
			translate y*.5
			}
		object{plane{y,0}
			rotate z*-262.87 //180 + (90 - 8.13)
			translate x*.3125
			}
		}} 
	texture{pigment{TFGray}} //end texture
	bounded_by{object{box{<-.1,-.1,-.0626>,<.3126,.51,.0626>}}}
	} //end difference - object
#declare TF_wingmount_two=object{difference{
	object{box{<0,0,-.25>,<.75,.3125,.25>}}
	object{union{
		object{plane{y,0} //cut top
			rotate z*-187.01563
			translate y*.3125}
		object{plane{z,0}
			rotate x*31
			translate z*-.25}
		object{plane{z,-0}
			rotate x*-211
			translate z*.25}
		object{difference{
			object{box{<.6,.0125,-.251>,<.76,.3126,.251>}}
			object{union{
				object{plane{y,0}
					rotate z*-7.01563
					translate y*.125
					translate x*.76}
				object{plane{y,0}
					rotate z*-82.87
					translate x*.65}
				}} //end union
			}} //end difference
		}}
	texture{pigment{TFGray}} //end texture
	bounded_by{object{box{<-.1,-.1,-.251>,<.751,.31251,.251>}}}
	}} //end object
#declare TF_wingmount_three=difference{
	object{box{<0,0,-.03125>,<.9375,.5,.03125>}}
	object{union{
		object{plane{y,0}
			rotate z*-187.01563//14.036249
			translate y*.4
			}
		object{plane{y,0}
			rotate z*-262.87 //180 + (90 - 8.13)
			translate x*.9375
			}
		}} 
	texture{pigment{TFGray}} //end texture
	bounded_by{object{box{<-.1,-.1,-.03126>,<.9376,.51,.03126>}}}
	} //end difference - object
#declare TF_wingmount_four=object{cylinder{<0,0,0>,<1.5,0,0>,.1875}
	texture{pigment{TFGray}}
	bounded_by{object{cylinder{<-.1,0,0>,<1.6,0,0>,.1876}}}}//central shaft
#declare TF_wingmount_five=object{cylinder{<0,0,0>,<.0625,0,0>,.25}
	texture{pigment{TFGray}}
	bounded_by{object{cylinder{<-.1,0,0>,<1.51,0,0>,.1876}}}}
#declare TF_wingmount_six=difference{
	object{box{<0,0,-.03125>,<.3125,.125,.03125>}}
	object{plane{y,0} rotate z*201.8} //180+21.8}
	texture{pigment{TFGray}}
	bounded_by{object{box{<-.1,-.1,-.03126>,<.3126,.1251,.03126>}}}}
#declare TF_wingmounts=union{
	object{TF_wingmount_one}
	object{TF_wingmount_one rotate x*180}
	object{TF_wingmount_two}
	object{TF_wingmount_two rotate x*180}
	object{TF_wingmount_three}
	object{TF_wingmount_three rotate x*180}
	object{TF_wingmount_four}
	object{TF_wingmount_five translate x*.75}
	object{TF_wingmount_five translate x*1.125}
	object{TF_wingmount_six translate x*1.1875 translate y*.1875}
	object{TF_wingmount_six rotate x*180 translate x*1.1875 translate y*-.1875}
	object{TF_wingmount_six rotate x*-90 translate x*1.1875 translate z*-.1875}
	object{TF_wingmount_six rotate x*90 translate x*1.1875 translate z*.1875}
	texture{pigment{TFClear}}
	}//end union - object
//-----------------------------------------------------
//-----------------------------------------------------
// TIE Advanced Wing Mounts and Solar Panels

#declare TA_Wing_Mount=difference{
	difference{
		object{box{<0,-.73,-.65>,<1.65,.73,.73>}}
		union{
			object{plane{y,0} rotate z*-195.896 translate y*.73}  // top
			object{plane{y,0} rotate z*15.896 translate y*-.73}    // bottom
			object{plane{z,0} rotate <195,15,0> translate z*.65} // rear bottom
			object{plane{z,0} rotate <165,15,0> translate z*.65} // rear top
			object{plane{z,0} rotate <15,-15,0> translate z*-.65}  // top front
			object{plane{z,0} rotate <-15,-15,0> translate z*-.65} // bottom front
			}
		pigment{TFGray}
		}
	object{sphere{<0,0,0>,.875}}
	}

#declare TA_Center_Panel=union{
	union{
	difference{
		object{box{<-.03125,-.8,-1>,<.03125,.8,2>}}
		union{
			object{box{<-.03120,-.7375,-.9375>,<.03126,.7375,1.9375>}}
			object{box{<-.1,.7,-.3125>,<.1,.03125,-.9375>}}
			object{box{<-.1,-.7,-.3125>,<.1,-.03125,-.9375>}}
			} // end union
		} // end difference
	object{box{<-.03125,-.8,-.0625>,<.03125,.8,.0625>}}
	object{sphere{<.03125,.7,0>,.015625}}
	object{sphere{<.03125,-.7,0>,.015625}}
	object{cylinder{<.03125,-.7,0>,<.03125,.7,0>,.015625}}
	pigment{TFGray}
	}
	intersection{
		object{plane{x,0} translate x*.00001}
		object{box{<-.03120,-.7375,-.9375>,<.03126,.7375,1.9375>}}
	pigment{TFBlack}
	} // end intersection
} // end union

#declare TA_Top_Bot_Panel=union{
union{
	difference{
		difference{
			object{box{<-.03125,0,-1>,<.03125,1,2>}} // outside shape
			object{union{
				object{plane{z,0} rotate x*35 translate z*-1}
				object{plane{z,0} rotate x*145 translate z*2}
				}}
			}
		difference{
			object{box{<-.1,.0625,-.9375>,<.1,.9375,1.9375>}} // hole cut for solar panel
			object{union{
				object{plane{z,0} rotate x*35 translate z*-.9375}
				object{plane{z,0} rotate x*145 translate z*1.9375}
			 	}}
			}
		}
	object{box{<-.03125,.01,-.0625>,<.03125,.99,.0625>}}
	object{sphere{<.03125,.9,0>,.015625}}
	object{sphere{<.03125,.1,0>,.015625}}
	object{cylinder{<.03125,.1,0>,<.03125,.9,0>,.015625}}

	object{box{<-.03125,.01,-.0625>,<.03125,.99,.0625>}}
	object{sphere{<-.03125,.9,0>,.015625}}
	object{sphere{<-.03125,.1,0>,.015625}}
	object{cylinder{<-.03125,.1,0>,<-.03125,.9,0>,.015625}}

	pigment {TFGray}
	}
	intersection{
		object{plane{x,0} pigment{TFBlack}}
		object{difference{
			object{box{<-.01,.0625,-.9375>,<.01,.9375,1.9375>}} // hole cut for solar panel
			object{union{
				object{plane{z,0} rotate x*35 translate z*-.9375}
				object{plane{z,0} rotate x*145 translate z*1.9375}
				}}
			}pigment{Clear}}

	} // end intersection
}

#declare TA_Wing=union{
	object{TA_Center_Panel}
	object{TA_Top_Bot_Panel rotate z*30 translate y*.8}
	object{TA_Top_Bot_Panel rotate z*-210 translate y*-.8}
	}

#declare TA_back=intersection{
	difference{
		union{
			object{box{<-.4,-.4375,0>,<.4,.4375,1.65>}} // middle box
			object{box{<-1.65,-.23,0>,<1.65,.23,1.65>}} // large flat box
			}
		object{sphere{<0,0,0>,.875}}
	}
	object{sphere{<0,0,0>,1} scale <3,2,1.5>}
	pigment{TFGray}
	}

//----------------------------------------------------
//----------------------------------------------------

#declare TF_back_window=object{difference{
	object{box{<-.1,-.1,-.1>,<.1,.1,.2>}}
	object{union{
		object{plane{y,0} rotate z*-330 translate <.02257,-.09375,0>}
		object{plane{y,0} rotate z*-210 translate <.02257,.09375,0>}
		object{plane{y,0} rotate z*210 translate <-.02257,.09375,0>}
		object{plane{y,0} rotate z*330 translate <-.02257,-.09375,0>}
	}}
	pigment{TFGray}}}
#declare TF_back_glass=object{disc{<0,0,-.01>,<0,0,1>,.354} pigment{TFBlack}
	texture {TFGlass3}}
#declare TF_back_door=union{
	difference{
		object{cone{<0,0,0>,.51,<0,0,.125>,.35375}}
		object{union{
			object{TF_back_window scale 1.65}
			object{cone{<0,0,0>,.2,<0,0,.12501>,.3275}}
			}}
		}//end difference
	object{box{<-.09375,.3125,0>,<.09375,.515,.11>} pigment{TFGray}}
	object{sphere{<-.046875,.4375,.11>,.02} pigment {TFRed}}
	object{sphere{<.046875,.4375,.11>,.02} pigment {TFRed}}
	object{TF_back_glass}
	texture{pigment{TFGray50}}
	}
//-----------------------------------------------------
//-----------------------------------------------------
// front glass
#declare TF_front_one=object{box{<-.015625,-.48438,0>,<.015625,.48438,-.125>}}
#declare TF_front_two=union{
	object{TF_front_one}
	object{TF_front_one rotate z*90}
	object{TF_front_one rotate z*45}
	object{TF_front_one rotate z*135}
	}
#declare TF_front_three=difference{
	object{cylinder{<0,0,0>,<0,0,-.125>,.515625}}
	object{cylinder{<0,0,.1>,<0,0,-.2>,.484375}}}
#declare TF_front_four=object{difference{
	object{box{<-.25,-.25,0>,<.25,.25,-.125>}}
	object{union{
		object{plane{y,0} rotate z*-247.5 translate x*.25}
		object{plane{y,0} rotate z*-202.5 translate y*.25}
		object{plane{y,0} rotate z*247.5 translate x*-.25}
		object{plane{y,0} rotate z*202.5 translate y*.25}
		object{plane{y,0} rotate z*67.5 translate x*.25}
		object{plane{y,0} rotate z*22.5 translate y*-.25}
		object{plane{y,0} rotate z*-67.5 translate x*-.25}
		object{plane{y,0} rotate z*-22.5 translate y*-.25}
		}}
	bounded_by{object{box{<-.26,-.26,.1>,<.26,.26,-.2>}}}
	}}
#declare TF_front_five=object{difference{
	object{TF_front_four}
	object{TF_front_four scale<.85,.85,3> translate z*.1}
	}}
#declare TF_front_window=intersection{
	object{union{
		object{difference{
			object{TF_front_two}
			object{TF_front_four scale <.95,.95,3> translate z*.1}
			}}   //bars
		object{TF_front_three} //outside cylinder
		object{TF_front_five}
	}}//end union
	object{cone{<0,0,0>,.7,<0,0,-.125>,.251}}
	texture{pigment{TFGray55}}}
#declare TF_front_glass=object{cone{<0,0,0>,.7,<0,0,-.125>,.251}
	translate z*.03125
	pigment {TFBlack}
	texture {TFGlass3}}
//-----------------------------------------------------
//-----------------------------------------------------
#declare TIE_Body=union{
	object{FST_Body}

	object{TF_back_door translate z*.725}
	object{TF_front_window translate z*-.67}
	object{intersection{
		object{TF_front_glass translate z*-.67}
		object{cylinder{<0,0,0>,<0,0,-2>,.515}}
		}}
	object{TF_top_door}
	}
//			WINGS
#declare TF_bottom_texture=texture{
	pigment{gradient <0,1,0>
	color_map {[0,0.5 color TFGray10 color TFBlack]
		[0.5,1 color TFBlack color TFGray10]}}
	rotate z*45
	finish {ambient 0.2} 
	scale <0.015,0.015,0.015>
	}
#declare TF_top_texture=texture{
	pigment{gradient <0,1,0>
	color_map {[0,0.7 color TFClear color TFGray10]
		[0.7,1 color TFGray10 color TFClear]}}
	rotate z*-45
	finish {ambient 0.2} 
	scale <0.015,0.015,0.015>
	}

#declare TF_wing_main_box=object{box{<-1.75,-2.625,-.0625>,<1.75,2.625,.0625>}
	pigment{TFGray}}
#declare TF_left_cutting=object{union{
	object{plane{x,0}
		rotate z*-14.036243
		translate x*-1.75
		}
	object{plane{x,0}
		rotate z*14.036243
		translate x*-1.75
		}
	}}
#declare TF_back_cutting=object{union{
	object{plane{x,0}
		rotate z*194.036243
		translate x*1.75}
	object{plane{x,0}
		rotate z*-194.036243
		translate x*1.75
		}
	}}
#declare TF_left_cut=object{difference{
	object{TF_wing_main_box}
	object{TF_left_cutting}
	}}
#declare TF_wing_shape=object{difference{
	object{TF_left_cut}
	object{TF_back_cutting}
	}}
#declare TF_wing_outer_rim=union{
	object{TF_wing_shape scale <.2,.2.1>} //part at wing mount
	object{difference{
		object{TF_wing_shape}
		object{TF_wing_shape scale <.95,.95,1.2>}
		}}
	}

#declare TF_panel1=object{difference{
	object{box{<-2,-2.62,-.001>,<2,2.62,.001>}}
	object{TF_left_cutting}
	}}
#declare TF_panel2=object{difference{
	object{TF_panel1}
	object{TF_back_cutting}
	texture{TF_bottom_texture}
	texture{TF_top_texture}
	}}

#declare TIE_wing=union{
	object{TF_wing_outer_rim}
	object{box{<-1.7,-.05,-.0625>,<1.7,.05,.0625>} //horizontal spoke
		pigment{TFGray}}
	object{box{<-2.766993,-.05,-.0625>,<2.766993,.05,.0625>}
		rotate z*-68
		pigment {TFGray}} //spoke from top left to bottom right
	object{box{<-2.766993,-.05,-.0625>,<2.766993,.05,.0625>}
		rotate z*68
		pigment {TFGray}} //spoke from top right to bottom left
	object{TF_panel2}
	}

#declare TIE_Laser=object{union{
	object{difference{
		object{union{
			object{sphere{<0,0,0>,.0625}}
			object{cylinder{<0,0,0>,<0,.12,0>,.0625}}
			}}
		object{plane{z,0}}
		pigment{TFGray}
		}}
	object{sphere{<0,0,0>,.03125} pigment{TFGray35}}
	}}

#declare TIE_Fighter=union{
	object{TIE_Body}
	object{TF_wingmounts
		translate x*.735}
	object{TF_wingmounts
		rotate y*180
		translate x*-.735}
	object{TIE_wing rotate y*90 translate x*-2.2}
	object{TIE_wing rotate y*90 translate x*2.2}
	object{TIE_Laser translate <.2,-.61,-.66>}
	object{TIE_Laser translate <-.2,-.61,-.66>}
	}

#declare TA_Fighter=union{
	object{TIE_Body}
	object{TA_back}
	object{TA_Wing_Mount}
	object{TA_Wing_Mount rotate z*180}

	object{TA_Wing translate x*1.65}
	object{TA_Wing rotate z*180 translate x*-1.65}

	object{TIE_Laser translate <.2,-.61,-.66>}
	object{TIE_Laser translate <-.2,-.61,-.66>}
	}

#declare org_Tie_Laser_Bolt = union{
	cylinder{<0,0,0>,<0,0,-.5>,.015625}
	sphere{<0,0,-.5>,.015625}
	cone{<0,0,0>,.015625 <0,0,.5>,0}
	pigment{Green}
	finish{ambient 1}
	}

#declare Tie_Laser_Bt = union{
	cylinder{<0,0,0>,<0,0,-.5>,.015625}
	sphere{<0,0,-.5>,.015625}
	cone{<0,0,0>,.015625 <0,0,.5>,0}
	}

#declare Tie_Laser_Bolt=union{
	object{Tie_Laser_Bt
		pigment{Green}
		finish{ambient 1diffuse 1}
		}
	object{Tie_Laser_Bt
		scale <1.5,1.5,1.2>
		translate z*.1
		pigment{green 1 filter .3}
		finish{ambient 1 diffuse 1}
		}
	}