//
// @(#)aw1.pov:v1.0
//
// Author       : Kevin B Black
// Date written : 02 August 1995
// Abstract     :
//
// ALIEN WORLDS; MAIN SCENE FILE
//
// This POV-ray scene file for entry into "August" 1995 comp.graphics.
// raytracing competition. The subject matter this time is "Alien Worlds".
//
// Standard includes
//
#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"

//
// Local includes
//
#include "ship.inc"
#include "planet.inc"
#include "geodomes.inc"

//
// Declare local textures
//
#declare CloudySky = texture
{
   pigment
   {
      bozo
      turbulence 0.5
      octaves 3
      lambda 6
      color_map
      {
         [0.0 0.1 color SkyBlue color SkyBlue]
         [0.70 color rgb <4/5, 4/5, 5/6>]
         [1.0 color White]
      }
   }
   finish { ambient 1 diffuse 0 }
   scale 1/6
}

//
// Set the camera location and viewing details
//
camera {
   location  <0.0, 0.0, -5.0>
   direction <0.0, 0.0,  1.0>
   up        <0.0, 1.0,  0.0>
   right     <4/3, 0.0,  0.0>
}

//
// Define the ocean surface
//
// the ocean surface is a large sphere (to simulate a planet), with waves,
// the large sphere is offset, so <0,0,0> is just above the surface.
//
/*
sphere
{
   <0.0, -395005.0, 0.0>, 395000.0
//   pigment { colour red 0.5 green 0.6 }
   pigment { colour red 0.8 green 0.7 blue 0.8 }
   normal
   {
      waves 0.05
      frequency 14000
      phase .275
      scale 3000
   }
//   finish { reflection 0.85 }
   finish { reflection 0.88 }
   rotate <0.0, 45.0, 0.0>
}
*/
//
// Put a floor underneath to catch any errant waves from the ripples
//
sphere
{
   <0.0, -395005.0, 0.0>, 394998.0
//   pigment { colour red 0.5 green 0.7} // green was 0.4
//   pigment { colour red 0.5 green 0.7 blue 0.8 }
     pigment { colour red 0.8 green 0.7 blue 0.8 }
   finish { ambient 1 diffuse 0 }
}

//
// Now draw the sky.
//
// So that off planet objects are still visible special handling for the
// sky is required. It is not practical to mimick the real reason why
// we have a blue sky with POV-Ray, whilst allowing the off planet
// objects to be visible. Hence we use two sky spheres. The first encompases
// the the planet, at a low altitude, but just above the clouds. It is
// largely transparent, it's presence is there mainly to add a bit 
// of authenticity to the appearance of the off planet objects. The second
// sphere encompasses ALL objects in the scene.
//
/*
fog { colour SkyBlue distance 299999.99 }
*/
sphere
{
//   <0.0, -395005.0, 0.0>, 396000.0
   <0.0, -395005.0, 0.0>, 2000000
   texture
   {
      pigment
      {
         gradient y
         colour_map {
            [0, 0.2    colour red 0.5 green 0.5 blue 0.7
                       colour red 0.36 green 0.36 blue 0.7 ]
            [0.2, 0.6  colour red 0.36 green 0.36 blue 0.7
                       colour red 0.36 green 0.36 blue 0.8 ]
            [0.6, 1    colour red 0.36 green 0.36 blue 0.8
                       colour red 0.0 green 1.0 blue 1.0 ]
         }
//         scale 3000.0
         scale 1500000.0
      }
   }
   finish
   {
      ambient 0.7 
      diffuse 0.0   // Prevents clouds and other objects casting shadows on the sky
   }
}

/*
plane // Plane required, as objects are casting shadows on sphere
{
   -z, -7000000.0
   pigment
   {
      colour SkyBlue
   }
   finish
   {
      ambient 0.7 
      diffuse 0
   }
}
*/

// 
// Put in the clouds
//
// So that off planet objects are still visible, a filter needs to be
// applied to the clouds.
//
/*
sphere
{
   <0, 0.0, 0>, 395199.0
   pigment
   {
      bozo
      turbulence 0.7 // 0.6
      octaves 1 // 4
      lambda 7.0 // 0.5 // 5.7
      color_map
      {
//         [0.0 0.1 colour Clear colour Clear ]
//         [0.40 colour rgb <4/5, 4/5, 5/6> filter 0.5]
//         [1.0 colour White]
         [0.0 0.4 colour Clear colour Clear ]
         [0.60 colour rgb <4/5, 4/5, 5/6> filter 0.5]
         [1.0 colour White]
      }
      quick_color red 0.36 green 0.36 blue 1.0
      scale 200.0 // 500.0
   }
   finish { ambient 0.8 diffuse 0.0 }
   rotate <0, 50, 0>
   rotate <-1.0, 0.0, 1.0>
   translate <0, -395005.0, 0>
}
*/

//
// Place a near planet. This is 1/4 the size of the planet from which we are viewing
// the scene. It's also pretty close, SciFi or what?
//
object { Planet0 scale 9.88 rotate <-30, 0.0, 30.0> rotate <0, 10.0, 0.0>
         translate <120000.0, 120000.0, 300000.0>
       }

//
// Place the landmass using a height field.
//
// NOTE : In landmass.gif, palletten entry 56 is our ordinance datum
//        for positioning things; it is the large flat area. 38 is
//        good for sea level.
//
/*
height_field
{
   gif "landmass.gif"
// NOTE : Next line based in camera location and hieght field's initial scaling
   water_level 37/256
   scale <1,.1,1>
   texture
   {
      pigment
      { 
         image_map { gif "landmass.gif" }
         rotate x*90
         scale <1.0,0.1,1.0>
     }
     finish
     {
        crand 0.04
        reflection 0.0
        diffuse 0.6
        ambient 0.2}
     }
//     smooth                            // comment out this line to speed rendering
     translate <-0.704,0.0,-0.125>
     scale 50.0
     rotate <0.0, 60, 0.0>
// NOTE : Next line based in camera location and hieght field's initial scaling
     translate <0.0, -(5.0+(38/256*0.1)), -0.0>
}
*/
//
// Construct a small off-shore island
//
/*
height_field
{
   gif "island.gif"
// NOTE : Next line based in camera location and hieght field's initial scaling
   water_level 37/256
   scale <1,.3,1>
   texture
   {
      pigment
      { 
         image_map { gif "island.gif" }
         rotate x*90
         scale <1.0,0.3,1.0>
     }
     finish
     {
        crand 0.04
        reflection 0.0
        diffuse 0.6
        ambient 0.2}
     }
//     smooth                            // comment out this line to speed rendering
     translate <-0.704,0.0,-0.125>
     scale 65.0
     rotate <0.0, 60, 0.0>
// NOTE : Next line based in camera location and hieght field's initial scaling
     translate <-70.0, -(5.0+(42/256*0.3)), 80.0>
}
*/
//
// Add a radar tower to the off-shore island
//
/*
union
{
   cylinder
   { <0.0, 0.0, 0.0>, <0.0, 0.4, 0.0>, 0.04
      texture { pigment { Gray } }
   }
   object
   {
      geodome2
      scale 0.12
      translate <0.0, 0.4, 0.0>
      texture { pigment { White } }
   }
   scale 3.0
   translate <-10, 00.0, 30.0>
}
*/
//
// Habitat domes.....
//
/*
   object
   {
      geodome3
      texture { pigment { White } }
      scale 0.5
      translate <-0.4, -(3.9-(56-38)/256*0.1),7.0>
   }
   object
   {
      geodome2
      texture { pigment { White } }
      scale 0.3
      translate <-0.6, 0.0, 0.0>
      rotate y*-45
      translate <-0.4, -(3.9-(56-38)/256*0.1),7.0>
   }
   object
   {
      geodome2
      texture { pigment { White } }
      scale 0.3
      translate <-1.2, 0.0, 0.0>
      rotate y*-45
      translate <-0.4, -(3.9-(56-38)/256*0.1),7.0>
   }
   object
   {
      geodome2
      texture { pigment { White } }
      scale 0.3
      translate <-0.6, 0.0, 0.0>
      rotate y*-45
      translate <-0.4, -(3.9-(56-38)/256*0.1),7.0>
      translate <-0.4, 0.0, 0.4>
   }
   object
   {
      geodome2
      texture { pigment { White } }
      scale 0.3
      translate <-1.2, 0.0, 0.0>
      rotate y*-45
      translate <-0.4, -(3.9-(56-38)/256*0.1),7.0>
      translate <-0.4, 0.0, 0.4>
   }
*/

//
// Put in a space craft, in flight
//
// NOTE : Ships are scaled by 0.5, to make them, look right
//
//oldobject { Ship_GearUp rotate <0.0, 40, 0.0> translate <-1.6, 0.8, -1.2 > }
//oldobject { Ship_Lights rotate <0.0, 40, 0.0> translate <-1.6, 0.8, -1.2 > }
//object { Ship_GearUp no_shadow scale 0.5 rotate <0.0, -40, 0.0> translate <-1.0, 0.7, -2.8 > }
//object { Ship_Lights scale 0.5 rotate <0.0, -40, 0.0> translate <-1.0, 0.7, -2.9 > }

//
// Put in a space craft, on the ground (on the height field)
//
union {
object { Ship_GearDown no_shadow scale 0.5 rotate <0.0, 15, 0.0> translate <1.0, -(1.0-(56-38)/256*0.1)+0.562,-2.0> }
object { Ship_Lights scale 0.5 rotate <0.0, 15, 0.0> translate <1.0, -(1.0-(56-38)/256*0.1)+0.562,-2.0> }
light_source { <0, 1, -3> colour White }
}

//
// Light things up
//
// Default light source
//
//light_source { <0, 1, -3> colour White }

//
// "Sun", shine some light on the near moon etc
//
/*
light_source
{ <-1200000, -400000.0, 500000.0>
   colour White
   looks_like { sphere {<0.0, 0.0, 0.0>, 100.0 } }
}
*/