/*Title: Past and Present
* Author: Bob Belas
* Contribution to the August '95 Raytracing Competition
* "Alien Worlds" Theme
* All Rights Reserved
*/




//  Persistance of Vision Raytracer V2.0
//  Texture include file for bob.mdl scene.
//
//  This file was generated for POV-Ray V2.0 by
//  MORAY.EXE (c) '91 '92 '93 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//
//  NOTE: Do *NOT* remove the comment lines containing '$MRY$'.
//

// *******  T E X T U R E S  *******

#declare Soil_Texture =
  texture {
		pigment
 			{granite
  				turbulence 0.5
  				color_map
   				{	[0.000, 0.178   color rgbf <0.804, 0.569, 0.494, 0.000>
                    color rgbf <0.816, 0.725, 0.537, 0.000>]
    					[0.178, 0.356   color rgbf <0.816, 0.725, 0.537, 0.000>
                    color rgbf <0.820, 0.580, 0.522, 0.000>]
    					[0.356, 0.525   color rgbf <0.820, 0.580, 0.522, 0.000>
                    color rgbf <0.882, 0.725, 0.537, 0.000>]
    					[0.525, 0.729   color rgbf <0.882, 0.725, 0.537, 0.000>
                    color rgbf <0.855, 0.729, 0.584, 0.000>]
    					[0.729, 1.001   color rgbf <0.855, 0.729, 0.584, 0.000>
                    color rgbf <0.804, 0.569, 0.494, 0.000>]
   }
 }
		turbulence .75
		octaves 12
    finish { diffuse 0.13 ambient 0.25 }
  scale <250, 250, 250>       	
  }


#declare Groundfog_Texture1 =
  texture {
  		pigment 
  			{bozo
   			turbulence 0
   			color_map 
    				{[0.0, 0.1  color red 0.91 green 0.82 blue 0.80 filter 0.25
                 		color red 0.91 green 0.98 blue 0.96 filter 0.50]
     					[0.1, 0.5  color red 0.91 green 0.98 blue 0.96 filter 0.50
                 		color Clear]
     					[0.5, 1.001 color Clear
                 		color Clear]
    }
  }
		turbulence .95
		octaves 13
		scale <50, 50, 50>
  finish {
		ambient 0.4
		crand 0.005			//Is this an improvement????
	}
  }



#declare Groundfog_Texture2 =
  texture {
  		pigment 
  			{bozo
   			turbulence 0
   			color_map 
    				{[0.0, 0.1  color red 0.95 green 0.92 blue 0.90 filter 0.50
                 		color red 0.91 green 0.98 blue 0.96 filter 0.75]
     					[0.1, 0.5  color red 0.91 green 0.98 blue 0.96 filter 0.75
                 		color Clear]
     					[0.5, 1.001 color Clear
                 		color Clear]
    }
  }
		turbulence .35
		octaves 3
		lambda 5
		omega 0.1
		scale <20, 20, 20>
  finish {
		ambient 0.4
	}
  }


//  $MRY$: 'Temple_Tex1'
#declare Temple_Tex1 =
texture {
	pigment
 {granite
  color_map
   {[0.000, 0.168   color rgbf <0.824, 0.725, 0.584, 0.600>
                    color rgbf <0.514, 0.584, 0.533, 0.600>]
    [0.168, 0.301   color rgbf <0.514, 0.584, 0.533, 0.600>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.301, 0.398   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.263, 0.337, 0.282, 0.700>]
    [0.398, 0.558   color rgbf <0.263, 0.337, 0.282, 0.700>
                    color rgbf <0.431, 0.506, 0.451, 0.600>]
    [0.558, 0.655   color rgbf <0.431, 0.506, 0.451, 0.600>
                    color rgbf <0.529, 0.631, 0.471, 0.500>]
    [0.655, 0.735   color rgbf <0.529, 0.631, 0.471, 0.500>
                    color rgbf <0.333, 0.376, 0.318, 0.700>]
    [0.735, 0.823   color rgbf <0.333, 0.376, 0.318, 0.700>
                    color rgbf <0.298, 0.376, 0.318, 0.600>]
    [0.823, 0.876   color rgbf <0.298, 0.376, 0.318, 0.600>
                    color rgbf <0.416, 0.376, 0.318, 0.500>]
    [0.876, 0.929   color rgbf <0.416, 0.376, 0.318, 0.500>
                    color rgbf <0.416, 0.376, 0.318, 0.600>]
    [0.929, 1.001   color rgbf <0.416, 0.376, 0.318, 0.600>
                    color rgbf <0.824, 0.725, 0.584, 0.700>]
   }
 }

	finish {
   	diffuse 0.65    //0.1
   	brilliance 1.0  //0.50
   	ambient 0.25    //0.3
   	phong 0.55
   	phong_size 220
   	reflection 0.35
		}
	scale <40, 40, 40>
}



//  $MRY$: 'Temple_Tex2'
#declare Temple_Tex2 =
	texture{pigment {color Green}}
	texture{Stone6 scale <3, 6, 2> rotate <0, 0, 50>}
	texture{Grnt23a scale <1, 2, 1> rotate <0, 0, -50>
		finish {
   	diffuse 0.45
   	brilliance 1.0  //0.50
   	ambient 0.55
   	phong 0.95
   	phong_size 210
   	//reflection 0.40
		}
	scale <5, 5, 5>
	}


//  $MRY$: 'TempleRoof_Tex'
#declare TempleRoof_Tex = 
	texture{pigment {color Yellow}}
	texture{Stone6 scale <3, 6, 2> rotate <0, 0, 50>}
	texture{Grnt23a scale <1, 2, 1> rotate <0, 0, -50>
		finish {
   	diffuse 0.45
   	brilliance 1.0  //0.50
   	ambient 0.55
   	phong 0.95
   	phong_size 210
   	//reflection 0.40
		}
	scale <7, 3, 7>
	}



//  $MRY$: 'Texture05'
#declare Texture05 = texture {
	Glass
    pigment {color red 0.8 green 0.55 blue 0.95 filter 0.7}
    finish {
	    //reflection 0.45
	    refraction 1.71311
	   }
}


//  $MRY$: 'Building_Tex'
#declare Building_Tex =
	texture {
		pigment { color red  0.808 green  0.800 blue  0.804 }
	finish {
   	diffuse 0.65    //0.1
   	brilliance 1.0  //0.50
   	ambient 0.25    //0.3
   	phong 0.25
   	phong_size 50
   	reflection 0.1
   	metallic
   	crand 0.5
		}
	//scale <40, 40, 40>
}

//  $MRY$: 'Building_Tex2'
#declare Building_Tex2 =
	texture {
		pigment { color red  0.6 green  0.6 blue  0.904 }
	finish {
   	diffuse 0.65    //0.1
   	brilliance 1.0  //0.50
   	ambient 0.25    //0.3
   	phong 0.25
   	phong_size 50
   	reflection 0.1
   	//metallic
   	crand 0.5
		}
	//scale <40, 40, 40>
}




// Torus Texture
#declare TextureTorus=texture {
   Polished_Brass
   	finish {
   	diffuse 0.3
   	brilliance 5.0
   	ambient 0.35
   	phong 0.8
   	phong_size 215
   	reflection 0.8
		}
}



// City Sphere Texture
#declare TextureCitySphere =
   texture {
   	pigment { color red 1.00 green 0.83 blue 0.75  filter 0.8}
   	finish {
   		Shiny
			ambient 0
			diffuse 0
			reflection 0.35
			refraction 1.05
			ior 1.35   /1.15
		}
	}

//Temple Arena Texture
#declare Texture_Arena = 
	texture {
		Brass_Valley
		//pigment { color White }
		finish {
   		diffuse 0.4
   		brilliance 3.0
   		ambient 0.25
   		phong 0.65
   		phong_size 255
   		reflection 0.55
			}
/*		normal {
			waves 1
			frequency 120
			phase 10
			scale <0.1, 0.1, 10000.0>
			rotate <0, 0, 180>
			translate <-0.05, 0, 0>
			}
*/
	scale <5, 5, 5>
	}
	

