// Space scene. By Iain Young 21st August 1995 //

#include"colors.inc"
#include"textures.inc"
#include"extratex.inc"
#include"spship.inc"

#declare laser_red = color red 3.0 green 0.4 blue 0.1
#declare cos=color rgbf<1,1,1,0.6>
#declare ros=5
#declare rcm=ros/360
#declare fos=25
#declare focm=fos/360

light_source { <0, 100, -10> color White }
light_source { <0, 10, -100> color White }
light_source { <-350, 100, 500> color White }

camera {
	location <20, 25, -65>
	look_at  <10, 5, 0>
	    }

#declare buggy_logo =
       union {
	       difference {
			   cylinder { <0,0,-3.1>,<0,0,3.1>,2
			       texture { pigment { color Red }
					 normal { bumps 0.6 scale .1 }
					 finish { Shiny }
				       }
				    }
			   cylinder { <0,0,-3.2>,<0,0,3.2>,1.6
			       texture { pigment { color Red }
					 normal { bumps 0.6 scale .1 }
					 finish { Shiny }
				       }
				    }
			  }
	       box { <-2,-.2,-3.101>,<2,.2,3.101>
		   texture { pigment { color Red }
			     normal { bumps 0.6 scale .1 }
			     finish { Shiny }
			   }
		   }
	       box { <-.2,-2,-3.101>,<.2,2,3.101>
		   texture { pigment { color Red }
			     normal { bumps 0.6 scale .1 }
			     finish { Shiny }
			   }
		   }
	       union {
		  difference {
			       cylinder { <0,0,-3.1>,<0,0,3.1>,3
				   texture { pigment { color Red }
					     normal { bumps 0.6 scale .1 }
					     finish { Shiny }
					   }
					}
			       cylinder { <0,0,-3.2>,<0,0,3.2>,2.6
				   texture { pigment { color Red }
					     normal { bumps 0.6 scale .1 }
					     finish { Shiny }
					   }
					}
			       box { <-4,-4,-4>,<4,0,4>
				   texture { pigment { color Red }
					     normal { bumps 0.6 scale .1 }
					     finish { Shiny }
					   }
				   }
			       box { <0,-4,-4>,<4,4,4>
				   texture { pigment { color Red }
					     normal { bumps 0.6 scale .1 }
					     finish { Shiny }
					   }
				   }
			      }
			box { <-3,-1,-3.1>,<-2.6,0,3.1>
			     texture { pigment { color Red }
				       normal { bumps 0.9 scale .1 }
				       finish { Shiny }
				     }
			    }
			box { <0,2.6,-3.1>,<1,3,3.1>
			     texture { pigment { color Red }
				       normal { bumps 0.9 scale .1 }
				       finish { Shiny }
				     }
			    }
		   rotate <0,0,45>
		     }
	       scale <.5,.5,1>
	       rotate <0,0,45>
	       translate <4.5,1.5,0>
	     }


#declare pod_dometop1 = 
		union {
		  difference {
			      sphere { <0, 0, 0>, 5
				scale <1, .7, 1>
				texture { Rust
					  normal {bumps 0.4 scale 0.2}
					  scale <.1,.1,.1>
					}
				     }
			      box { <-10, -10, -10>, <10, 0, 10>
				texture { Rust }
				  }
			     }      
		  cone { <0,0,0>,.2 <0,8,0>,.01 
		     texture { Chrome_Texture }
		       }
		  sphere { <0,.7,0>,1
		     texture { Chrome_Texture 
			       normal {bumps 0.4 scale 0.1}
			     }
			 }
		}
			       

#declare pod_stem1 =
		cylinder { <0, 0, 0>, <0, -10, 0>, 3
			texture { Rust
				normal {bumps 0.4 scale 0.2}
				scale <.1,.1,.1>
					  }
					}

#declare pod_stem1_light1 =
					torus { 3, .5 texture {Sapphire_Agate}    
						translate <0, -1, 0>                            
						  }

#declare pod_stem1_light2 =
					torus { 3, .5 texture {Sapphire_Agate}
						translate <0, -3, 0>
						   }

#declare pod_stem1_light3 =
					torus { 3, .5 texture {Sapphire_Agate}
						translate <0, -5, 0>                                            
						   }

#declare pod_connect_tube1 = 
		difference {
					cylinder { <-3, -10, 0>, <20, -10, 0>, 4 
							texture { Rust
							  normal {bumps 0.4 scale 0.2}
							  scale <.1,.1,.1>        
								  }
							}
					box { <-10, -15, -5>, <21, -10, 5>
						texture { Rust }
					   }
					  }

#declare pod_connect_tube_light1 =
		sphere { <3, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light2 =
		sphere { <5, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light3 =
		sphere { <7, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light4 =
		sphere { <9, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light5 =
		sphere { <11, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light6 =
		sphere { <13, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light7 =
		sphere { <15, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light8 =
		sphere { <17, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light9 =
		sphere { <3, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light10 =
		sphere { <5, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light11 =
		sphere { <7, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light12 =
		sphere { <9, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light13 =
		sphere { <11, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light14 =
		sphere { <13, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }

#declare pod_connect_tube_light15 =
		sphere { <15, -7, 2.5>, .5
			texture { Bright_Blue_Sky }
		       }
				 
#declare pod_connect_tube_light16 =
		sphere { <17, -7, -2.5>, .5
			texture { Bright_Blue_Sky }
		       }


#declare pod_tube1_left_end =
		difference {
						sphere { <-3, -10, 0>, 4
							texture { Rust
								  normal {bumps 0.4 scale 0.2}
								  scale <.1,.1,.1>      
									}
								 }
						box { <-3, -15, -5>, <1, -9, 5>
							texture { Rust }
							 }
						box { <-8, -15, -5>, <1, -10, 5>
							texture { Rust }
							 }
					  }

#declare main_dome1 =
		union {
			difference {
				    sphere { <0, 0, 0>, 10
					texture { Rust
						  normal {bumps 0.4 scale 0.2}
						  scale <.1,.1,.1>   
						}
					   }
				    box { <-20, -20, -20>, <20, 0, 20>
					texture { Rust }
					}
				   }     
			object { buggy_logo
				 translate <-4.5,-1.5,0>
				 scale <2,2,1>
				 translate <0,0,-7>
				 rotate <30,-45,0>
			       }
			object { buggy_logo
				 translate <-4.5,-1.5,0>
				 scale <2,2,1>
				 translate <0,0,-7>
				 rotate <30,-135,0>
			       }
			object { buggy_logo
				 translate <-4.5,-1.5,0>
				 scale <2,2,1>
				 translate <0,0,-7>
				 rotate <30,-225,0>
			       }
			object { buggy_logo
				 translate <-4.5,-1.5,0>
				 scale <2,2,1>
				 translate <0,0,-7>
				 rotate <30,-315,0>
			       }
		      }


#declare main_dome1_ariel =
		union {
				torus { 3, .5   
					texture { Blood_Sky }
					translate <0, 8, 0>
					   }
				torus { 3, .5
					texture { Blood_Sky }
					translate <0, 9, 0>
					   }
				torus { 3, .5
					texture { Blood_Sky }
					translate <0, 10, 0>
					   }
				torus { 3, .5
					texture { Blood_Sky }
					translate <0, 11, 0>
						}
				torus { 3, .5
					texture { Blood_Sky }
					translate <0, 12, 0>
						}
				torus { 3, .5
					texture { Blood_Sky }
					translate <0, 13, 0>
						}
			   sphere { <0, 13, 0>, 2.5
				texture { Chrome_Texture 
					  normal { bumps 0.4 scale .1}
					}
				  }
				cone { <0, 10, 0>, .5 <0, 20, 0>, .1
					texture { Chrome_Texture }
				     }
			   }                  
		
#declare pod1 =
		union {
			object {pod_dometop1}
			object {pod_stem1}
			object {pod_stem1_light1}
			object {pod_stem1_light2}
			object {pod_stem1_light3}
		   object {pod_connect_tube1}
			object {pod_connect_tube_light1}
			object {pod_connect_tube_light2}
			object {pod_connect_tube_light3}
			object {pod_connect_tube_light4}
			object {pod_connect_tube_light5}
			object {pod_connect_tube_light6}
			object {pod_connect_tube_light7}
			object {pod_connect_tube_light8}
			object {pod_connect_tube_light9}
			object {pod_connect_tube_light10}
			object {pod_connect_tube_light11}
			object {pod_connect_tube_light12}
			object {pod_connect_tube_light13}
			object {pod_connect_tube_light14}
			object {pod_connect_tube_light15}
			object {pod_connect_tube_light16}
			object {pod_tube1_left_end}
				}
				
#declare pod2 =       // connects to lift shaft
		union {
		   object {pod_connect_tube1}
			object {pod_connect_tube_light1}
			object {pod_connect_tube_light2}
			object {pod_connect_tube_light3}
			object {pod_connect_tube_light4}
			object {pod_connect_tube_light5}
			object {pod_connect_tube_light6}
			object {pod_connect_tube_light7}
			object {pod_connect_tube_light8}
			object {pod_connect_tube_light9}
			object {pod_connect_tube_light10}
			object {pod_connect_tube_light11}
			object {pod_connect_tube_light12}
			object {pod_connect_tube_light13}
			object {pod_connect_tube_light14}
			object {pod_connect_tube_light15}
			object {pod_connect_tube_light16}
				}
		
#declare lunar_base =
		union {
					object { pod1
								translate <-25, 10, 0>
							 }
					object { pod1
								translate <-25, 10, 0>
								rotate <0, 90, 0>
							 }
					object { pod2
								translate <-25, 10, 0>
								rotate <0, 180, 0>
							 }
					object { pod1
								translate <-25, 10, 0>
								rotate <0, 270, 0>
							 }
					object { main_dome1 }
					object { main_dome1_ariel }
			   }

#declare landing_pad_top =
		box { <0,0,0>, <1,1,1>
			texture {
				pigment {
				   image_map {
				     gif "landpad1.gif"
					     }
					}
				     }
			scale <20,20,1>
			translate <-10,-10,0>
			rotate <90,0,0>
			translate <0,5,0>
			 }
			 
#declare landing_pad_rim =
		difference {
						box { <-10.5, 3.8, -10.5>, <10.5, 5.2, 10.5>
							texture { Jade }
							 }
						box { <-10, 3, -10>, <10, 7, 10>
							texture { Jade }
							 }
					  } 

#declare landing_pad_foot =
		union {
				cylinder { <0,0,0>, <0,4,0>, 1
							texture { Rust 
								  scale <.1,.1,.1>
								}
						   }
				difference {
							sphere { <0,0,0>, 2
								texture { Rust 
									  scale <.1,.1,.1>
									}
							       }
							box { <-2,-2,-2>, <2,0,2>
								texture { Rust }
							    }
							  } 
				}
				
#declare landing_pad_lift_tube =
		union {
				cylinder { <-1.5,0,-1.5>,<-1.5,9,-1.5>, .5
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
							}
				cylinder { <1.5,0,-1.5>,<1.5,9,-1.5>, .5
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
							}
				cylinder { <-1.5,0,1.5>,<-1.5,9,1.5>, .5
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
							}
				cylinder { <1.5,0,1.5>,<1.5,9,1.5>, .5
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
							}
				box { <-2,0,-1.5>,<2,9,1.5>
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
					 }
				box { <-1.5,0,-2>,<1.5,9,2>
							texture { Rust
								normal {bumps 0.4 scale 0.2}
								scale <.1,.1,.1>
								     }
					 }
				}
				
#declare landing_pad_lift_door =
		box { <-1.5,5,-2.1>, <1.5,8.5,-2>
			  texture { 
			       pigment {
				    image_map {
					   tga"panel.tga"
					      }
				    rotate y*90
				       }
				  }
		    }

#declare landing_pad_lift =
		union {
			object {landing_pad_lift_tube}
			object {landing_pad_lift_door}
			   }
			   
#declare landing_pad_light =
		union {
				cylinder { <0,0,0>,<0,.5,0>, .2         // base
						texture { 
							pigment { color SkyBlue }
								  }
							}
				cylinder { <0,0,0>,<0,3,0>, .1                          // stem
						texture {
							pigment { color SkyBlue }
								  }
							}
				cylinder { <0,3,0>,<0,3.5,0>, .2                        // light 
						texture {
                                                        pigment { color Yellow }
                                                        finish { Luminous }
								  }
							}
				sphere { <0,3.5,0>,.2                                             // light top
                                                texture {
                                                        pigment { color Yellow }
                                                        finish { Luminous }
							     }
						 }
				}

#declare landing_pad =
		union {
			object {landing_pad_top}                         
			object {landing_pad_rim}
			object {landing_pad_foot
					translate <-9,0,-9>
					 }
			object {landing_pad_foot
					translate <-9,0,9>
					 }
			object {landing_pad_foot
					translate <9,0,-9>
					 }
			object {landing_pad_foot
					translate <9,0,9>
					 }
			object {landing_pad_lift
				rotate <0,-90,0>
				translate <-11.5, 0, 0>
					 }
			object {landing_pad_light
				translate <10.2,5.2,-10.2>
					 }
			object {landing_pad_light
				translate <-10.2,5.2,-10.2>
					 }
			object {landing_pad_light
				translate <10.2,5.2,10.2>
					 }
			object {landing_pad_light
				translate <-10.2,5.2,10.2>
					 }
			   }
			   
#declare whole_lunar_base =
		union {
			object {lunar_base}
			object {landing_pad
				translate <38.5,0,0>
					 }
			   }

#declare lunar_floor =
		union {
			height_field {
						pot "lunar.pot"
						translate <-.5, -.5, -.5>
						scale <500,40,500>
						translate <0,-5,0>
						rotate <3,0,0>
						texture {
							pigment {
							image_map {
							gif "altaqua.gif"
								  }
								}
							scale <50,50,50>
							rotate x*90
                                                        }
                                                no_shadow
				     }
			height_field {
						pot"lunar.pot"
						translate<-.5, -.5, -.5>
						scale<1000,200,130>
						translate<0,-50,-20>
						texture {
							pigment {
								image_map {
									gif "alo053.gif"
									  }
								}
							scale <5,5,5>
							 }
                                                translate <0,-10,300>
                                                no_shadow
                                     }
                                  no_shadow
			}                                                                 

#declare sky_sphere = 
		difference {
		       sphere { <0,0,0>,1
				texture {Star_Texture
					 finish {reflection 0.0 
						 diffuse 0.0 
						 ambient 1.0
						}
					}
				scale <1000,1000,1000>
			      }
		       sphere { <0,0,0>,1
				texture {Star_Texture
					 finish {reflection 0.0
						 diffuse 0.0
						 ambient 1.0
						}
					}
				scale <999,999,999>
			      }
			   }
			       

#declare rising_moon =
        sphere { <-420,0,700>,100
		texture {
                         Bright_Blue_Sky
                         scale <50,50,50>
                        }
                no_shadow
	       }



// buggy body extents are <-6,-3,-3>,<6,3,3>
// wheels bottom y-coord is -1 (centre is 0)


#declare buggy_wheel =                           // centre <0,0,0>
       union {
	   difference {
		cylinder { <0,0,0>,<0,0,-1>,1    // main bit of wheel
		       texture {
			   pigment { color Grey }
			   normal {bumps 0.6 scale 0.1}
			       }
			 }
		sphere { <0,0,-1>,.45            // cutaway bit (hub)
		       texture {
			   pigment { color Grey }
			       }
		       }
		      }
	   sphere { <0,0,-.55>,.2                // wheel hub
	       texture {
		   pigment { color Gold }
		       }
		  }
	   torus { .75, .25                    // tyre bulge
	       rotate x*-90
	       scale <1,1,.5>
	       translate <0,0,-1>
	       texture {
		   pigment { color Grey }
		   normal {bumps 0.6 scale 0.1}
		       }
		 }
	   translate <0,0,.5>
	   scale <1.4,1.4,1>
	     }

#declare buggy_main_bit =                     // centre 0,0,0 - facing left
	   difference {
		       box { <-6, -3, -3>, <6, 3, 3>
			   texture { Rust scale <.2, .2, .2> }
			   }
		       box { <-1.5, -1.5, -4>, <1.5, 1.5, 4>
			   rotate <0, 0, 45>
			   translate <-6, 3, 0>
			   texture { Rust }
			   }
		       cylinder { <-3.5,-3,-4>,<-3.5,-3,4>,1.5
			   texture { Rust }
				}
		       cylinder { <3.5,-3,-4>,<3.5,-3,4>,1.5
			   texture { Rust }
				}
		      }

#declare buggy_windscreen =
       difference {
		    box { <-1.3, -1.5, -2.8>, <1.3, 1.5, 2.8>
		       rotate <0, 0, 45>
		       translate <-6, 3, 0>
		       texture { Polished_Chrome
				 rotate x*90
				 finish {Shiny}
			       }
			}
		    box { <-1.6, -1.5, -5>, <1.6, 1.5, 5>
		       rotate <0, 0, 45>
		       translate <-6.01, 3.01, 0>
		       texture { Polished_Chrome
				 finish {Shiny}
			       }
			}
		  }

#declare buggy_left_window =
       difference {
		   box { <0, -1, -.01>, <4, 1, 0>
		       texture { Polished_Chrome
				 finish {Shiny}
			       }
		       }
		   box { <-2, -1, -1>, <3, 1, 1>
		       texture { Polished_Chrome }
		       rotate <0, 0, 45>
		       }
		   translate <-5.8, 1.8, -3>
		  }

#declare buggy_right_window =
       object { buggy_left_window
		translate <0, 0, 6>
	      }

#declare buggy_left_spotlight =
		union {
	      cone { <-6.05,-.5,-2.5>,.25,<-10,-5,-2.5>,5
			texture {
				pigment {
					radial
					color_map{
								[0.00     color Clear]
								[0.5-focm color Clear]
								[0.5-rcm  color cos]
								[0.50     color cos]
								[0.5+rcm  color cos]
								[0.5+focm color Clear]
								[1.00     color Clear]
								}
						  }
				finish {ambient 1 diffuse 0}
				     }
		   }
		   light_source { <-6.05,-.5,-2.5> color cos
		spotlight
			point_at<-10,-5,-2.5>
		tightness 0
			radius ros
		   falloff fos
			     }
	     no_shadow
	     }

#declare buggy_left_headlight =
		union {
	cylinder { <-6.05,-.5,-2.5>,<-5.75,-.5,-2.5>, .25
			 texture {
		     pigment { color Yellow }
		     normal {bumps 0.6 scale 0.01}
		   finish {phong 1}
						}
				 }
			object {buggy_left_spotlight}
			   }
		
#declare buggy_right_headlight =
       object {buggy_left_headlight
	   translate <0, 0, 5>
	      }

#declare buggy_front_grill =
       box { <-6.01, -2.5, -2>, <6, 0, 2>
	   texture { Blue_Agate
		     normal { bumps 0.8 scale .2}
		   }
	   }

#declare buggy_left_door_vent =
       union {
	       difference {
			   box { <-1.55,-2.5,-3.1>,<1.55,2.5.-3>
			       texture { Rust
					 scale <.1, .1, .1>
				       }
			       }
			   box { <-1.45,-2.4,-3.2>,<1.45,2.4,-2.9>
			       texture { Rust }
			       }
			  }
	       box { <-1.54,-2.49,-3.02>,<1.54,2.49.-3.01>
		   texture { pigment { color DarkSlateBlue } }
		   }
	       box { <-1.25,-2.5,-3.1>,<-1.15,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <-0.95,-2.5,-3.1>,<-0.85,2.5.-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <-0.65,-2.5,-3.1>,<-0.55,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <-0.35,-2.5,-3.1>,<-0.25,2.5.-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <-0.05,-2.5,-3.1>,<0.05,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <0.25,-2.5,-3.1>,<0.35,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <0.55,-2.5,-3.1>,<0.65,2.5.-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <0.85,-2.5,-3.1>,<0.95,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	       box { <1.15,-2.5,-3.1>,<1.25,2.5,-3>
		   texture { Rust
			     scale <.2, .2, .2>
			   }
		   }
	     }

#declare buggy_right_door_vent =
       object { buggy_left_door_vent
		rotate <0,180,0>
	      }

#declare buggy_laser_blast =
       cylinder { <4,0,0>,<6,0,0>,.15
		texture {
                  pigment { color laser_red }
                  normal  { bumps 0.7 scale 0.1}
                  finish  { Luminous }
                        }
                no_shadow
                }


#declare buggy_laser_top =
       union {
	       box { <-1,-.3,-.3>,<1,.3,.3>
		   texture {
		       Blue_Sky
		       normal  { bumps 0.7 scale 0.1 }
			   }
		   }
	       sphere { <-1,0,0>,.3
		   texture { Silver_Texture }
		      }
	       sphere { <1,0,0>,.3
		   texture { Silver_Texture }
		      }
	       cylinder { <0,0,0>,<3,0,0>,.1
		   texture { Chrome_Texture }
		      }
	       torus { .2, .1
		   rotate <90,90,0>
		   translate <2.3,0,0>
			texture { pigment { color Yellow } }
		     }
	       torus { .2, .1
		   rotate <90,90,0>
		   translate <2.33,0,0>
			texture { pigment { color Yellow } }
		     }
	       torus { .2, .1
		   rotate <90,90,0>
		   translate <2.39,0,0>
			texture { pigment { color Yellow } }
		     }
	       difference {
			   sphere { <0,0,0>,.3
			       texture { Pine_Wood }
				  }
			   box { <-1,-1,-1>,<1,0,1>
			       texture { pigment { color Yellow } }
				  }
			   scale <.5,1,1>
			   translate <2.8,0,0>
			  }
	       object {buggy_laser_blast}
	       object {buggy_laser_blast translate <4,0,0> }
	       object {buggy_laser_blast translate <8,0,0> }
	     }


#declare buggy_laser =
       union {
	       difference { // Base
			   cylinder { <0,2,0>,<0,4.5,0>,2
				   texture { Silver_Texture
					     normal { bumps 0.4 scale 0.2 }
					   }
				    }
			   torus { 2, 1.75
				   translate <0,4.5,0>
				   texture { Silver_Texture
					     normal { bumps 0.4 scale 0.2 }
					   }
				 }
			  }
	       object {buggy_laser_top
                       rotate <0,-30,45>
		       translate <0,4.5,0>
		      }
	     }

#declare buggy_left_ariel =
       union {
	      sphere { <5.6,3,-2.6>,.4
		   texture { Silver_Texture
			     normal { bumps 0.7 scale 0.1 }
			   }
		     }
	      cylinder { <5.6,3,-2.6>,<5.6,5,-2.6>,.05
		   texture { Silver_Texture
			     normal { bumps 0.7 scale 0.1 }
			   }
		       }
	      sphere { <5.6,5,-2.6>,.1
		   texture { pigment { color Red }
			     normal { bumps 0.7 scale 0.1 }
			   }
		     }
	     }

#declare buggy_right_ariel =
       object { buggy_left_ariel
		translate <0,0,5.2>
	      }


#declare buggy =
       union {
	   object {buggy_main_bit}
	   object {buggy_windscreen}
	   object {buggy_left_window}
	   object {buggy_right_window}
	   object {buggy_left_headlight}
	   object {buggy_right_headlight}
	   object {buggy_front_grill}
	   object {buggy_left_door_vent}
	   object {buggy_right_door_vent}
	   object {buggy_laser}
	   object {buggy_logo}
	   object {buggy_left_ariel
		   translate <-5.6,-3,2.6>
		   rotate <0,0,-20>
		   translate <5.6,3,-2.6>
		  }
	   object {buggy_right_ariel
		   translate <-5.6,-3,2.6>
		   rotate <0,0,-20>
		   translate <5.6,3,-2.6>
		  }
	   object {buggy_wheel        //left front
	       rotate <0,-25,0>
	       translate <-3.5, -3, -3>
		  }
	   object {buggy_wheel        //left back
	       translate <3.5, -3, -3>
		  }
	   object {buggy_wheel        //right front
	       rotate <180,-25,0>
	       translate <-3.5, -3, 3>
		  }
	   object {buggy_wheel        //right back
	       rotate <180,0,0>
	       translate <3.5, -3, 3>
		  }
	     }

#declare enemy_ship =
	object { spship
		 translate <-7.5,0,0>
		 scale <.5,.5,.5>
		 rotate <-135,80,-20>
		 translate <25,26,0>
	       }


object {buggy
        rotate <0,-35,7>
        translate <20,1.5,-25>
    }

object {whole_lunar_base
      rotate <0,20,0>
      translate <-20,0,20>
     }

object {lunar_floor
      translate <0,-.5,0>
       }

object {sky_sphere}

object {rising_moon}

object {enemy_ship}
