#include "chars.inc"

#declare char_TB = 
  union{
    box{ <-0.6,-0.1,-0.1>,<0.6,4.1,1.1> }
    box{ <-2.1,  3.9,-0.1>,<  2.1,5.1,1.1> }
  }

#declare char_IB = 
  box{ <-0.6,-0.1,-0.1>,<0.6,5.1,1.1> }

#declare char_KB = 
  union {
    intersection {
      union {
        box{ <-0.1,-2.1,-0.1>,<1,5.1,1.1> rotate z*45  translate x*0.7272 }
        box{ <-0.1,-5.1,-0.1>,<1,2.1,1.1> rotate -z*45 translate <0.7272,5,0> }
      }
      box { <-1.1,-0.1,-0.2>,<2.1,5.1,1.2> }
      bounded_by{ box { <-2.1,-0.1,-0.1>,<2.1,5.1,1.1> } }
    }
    box { <-2.1,-0.1,-0.1>,<-.9,5.1,1.1> }
  }


#declare Versa_Floor = 
      plane {
        <0, 1, 0>, 0
        texture { Water
		scale 3}
      }

#declare Versa_Sky = 
  plane {
     <0, 1, 1>, 20
        finish {
           ambient 1.0
           diffuse 0.0
        }
	inverse
          pigment { image_map {
            tga "c:\pov\cygnus_1.tga"
	    interpolate 2
            }
 	     translate x*.5
           scale 22	  }
  } 

#declare Bone=
	union {
			difference {
				cylinder{ <-4,0,0>, <4,0,0>, 1 scale z*.5}
				sphere{ <-4,1,0>, 1.414 }
				sphere{ <-4,-1,0>, 1.414 }
				sphere{ <4,1,0>, 1.414 }
				sphere{ <4,-1,0>, 1.414 }
			}
		intersection {
			sphere{ <-4,1,0>, 1.414 }
			box{ <-6,0,-2>, <-2,3,2> }
		}
		intersection {
		sphere{ <-4,-1,0>, 1.414 }
			box{ <-6,0,-2>, <-2,-3,2> }
		}
		intersection {
			sphere{ <4,1,0>, 1.414 }
			box{ <6,0,-2>, <-2,3,2> }
		}
		intersection {
		sphere{ <4,-1,0>, 1.414 }
			box{ <6,0,-2>, <-2,-3,2> }
		}
	}

#declare Versa_Sky2 = 
  plane {
     <0, 1, -.5>, 20
        finish {
           ambient 1.0
           diffuse 0.0
        }
	inverse
          pigment { image_map {
            tga "c:\pov\cygnus_1.tga"
	    interpolate 2
            }
 	     translate x*.5
           scale 22	  }
	  } 


#declare TIKI = 
	union{
	  object{char_T
	    translate <-1.5*5, 0, 0>}
	  object{char_I
	    translate <-.5*5, 0, 0>}
	  object{char_K
	    translate <.5*5, 0, 0>}
	  object{char_I
	    translate <1.5*5, 0, 0>}
          }

//  I modified chars.inc so there were corresponding letters that had the width of T, I, and K increased by .1

#declare TIKI_Shell = 
	union{
	  object{char_TB
		translate <0,-2.5,-.5>
	    translate <-1.5*5, 2.5, .5>}
	  object{char_IB
		translate <0,-2.5,-.5>
	    translate <-.5*5, 2.5, .5>}
	  object{char_KB
		translate <0,-2.5,-.5>
	    translate <.5*5, 2.5, .5>}
	  object{char_IB
		translate <0,-2.5,-.5>
	    translate <1.5*5, 2.5, .5>}
          }


#declare Earth = 
      sphere {
        <.5, .5, 0>, .5
	texture {
          pigment { image_map {
            gif "c:\pov\iearth.gif"
	    interpolate 2
            }
            scale 1	  }
	}
	scale 1
	translate <-.5, -.5, 0>
      }



#declare UnderWater=
	height_field {gif "land2.gif" 
  		smooth
		scale <30,3,30>
		translate <-15, -1, 0>
		}

#declare TikiPlatform=
	object{
		intersection{
			object{ Paraboloid_Y scale -1*y}
			box{ <-6,-36,-6>, <6,-2,6>}
		}
		scale <1.5,1,.5>
		translate y*2
		translate <-.7,.7,6.5>
	}

#declare Tiki=
	object{
		height_field {gif "d:\home\tiki\happy2.gif" water_level .036}
		rotate x*-90
		scale z*.00001
		texture {
      	    pigment { image_map {
      	    gif "d:\home\tiki\happy2.gif"
            	}
			}
		}
		no_shadow
		translate<-.5,0,0>
		scale x*(742/439)
		scale 3
		translate <-.35,-.23,5.5>
	
	}
