#declare Fin = object {
    union {
        triangle { <1, 0, 0.05>,  <0, 2, 0>,     <2, 2, 0 > }
        triangle { <1, 0, 0.05>,  <4, 0, 0.05>,  <2, 2, 0 > }
        triangle { <1, 0, -0.05>, <0, 2, 0>,     <2, 2, 0 > }
        triangle { <1, 0, -0.05>, <4, 0, -0.05>, <2, 2, 0 > }
        triangle { <1, 0, 0.05>,  <1, 0, -0.05>, <4, 0, -0.05> }
        triangle { <1, 0, 0.05>,  <4, 0, 0.05>,  <4, 0, -0.05> }
        triangle { <1, 0, 0.05>,  <1, 0, -0.05>, <0, 2, 0> }
        triangle { <4, 0, 0.05>,  <4, 0, -0.1>,  <2, 2, 0> }
    }
    pigment { 
        image_map { gif "uj75.gif" }
        scale <4,2,1>
    }
}

#declare Flight = object {
    union {
        object { Fin scale <1, 0.7, 1> }
        object { Fin scale <1, 0.7, 1> rotate  90*x }
        object { Fin scale <1, 0.7, 1> rotate 180*x }
        object { Fin scale <1, 0.7, 1> rotate 270*x }
    }
}

#declare FlightHolder = object {
    union {
        cone { <0, 0, 0>, 0,   <1, 0, 0>, 0.25 }
        cone { <1, 0, 0>, 0.25, <5, 0, 0>, 0.5 }
    }
    texture { New_Brass }
}

#declare Barrel = object {
    union {
        cylinder { <5, 0, 0>, <9, 0, 0>, 0.5 }
        cone     { <9, 0, 0>, 0.5, <10, 0, 0>, 0.3 }
    }
    texture { Polished_Brass }
}

#declare Tail = object { 
    union {
        object { Flight }
        object { FlightHolder }
    }
}

#declare Point = object {
    union {
        cylinder { <10, 0, 0>, <14, 0, 0>, 0.25 }
        cone     { <14, 0, 0>, 0.25, <15, 0, 0>, 0 }
    }
    texture { Polished_Chrome }
}

#declare Dart = object {
    union {
        object { Tail }
        object { Barrel }
        object { Point }
    }                       // Tail <0,0,0>    tip <15,0,0>
    rotate y*-90            // Tail <0,0,0>    tip <0,0,15>
    translate <0,0,-15>     // Tail <0,0,15>   tip <0,0,0>
    scale <1/3,1/3,1/3>     // Tail <0,0,5>    tip <0,0,0>
}

