#include "colors.inc"
#include "textures.inc"

#declare DELTA = 0.01
#include "board.inc"
#include "dart.inc"

camera {
        location  <2, 6.3, -9>
        look_at   <-1, 6.3, 0>
}

light_source { <-5,   15, -5> color Red }
light_source { <0,    15, -5> color Green }
light_source { <5,    15, -5> color Blue }
light_source { <15,  -15, -5> color White }
light_source { <-15, -15, -5> color White }

light_source { <0, -10, -10> color White }
light_source { <0,   0, -20> color Gray50 }  // Bit of fill in

/*
    cylinder { <-100, 0, 0>, <100, 0, 0>, 0.1 pigment { Green } }
    cylinder { <0, -100, 0>, <0, 100, 0>, 0.1 pigment { Green } }
    cylinder { <0, 0, -100>, <0, 0, 100>, 0.1 pigment { Green } }

    // Wall
    plane { -z, 0 
             pigment { color Gray90 }
             finish  { ambient 0.2 }
          }
*/    

// Backing board
object {
    difference {
        box { <-24,-18, 0>, <24,18,-2> }
        box { <-23,-17, -0.5>, <23,17,-2-DELTA> }
    }
    texture { Yellow_Pine scale 0.1 }
}

object { Board }

object { Dart rotate 10*x              rotate -4*y  translate <0,    6.1, -1.8> }
object { Dart rotate 20*x rotate 40*z  rotate -17*y translate <0.7,  6.3, -1.8> }
object { Dart rotate 15*x rotate -40*z rotate 15*y  translate <-0.6, 6.2, -1.8> }
