/*
This file contains the dragon and his head.
It is composed with multiple and recursive unions so that simple rotation values
applied at lower body parts will control the positions of those above.
Hierarchal control points, I guess.
*/

#include "LowerJaw.Include"
#include "LowerJaw.PoV"
#include "DrgnSkul.Include"
#include "DrgnSkul.PoV"
#include "TopHorns.Include"
#include "TopHorns.PoV"
#include "BackBone.Include"
#include "BackBone.PoV"
#include "InLwrJaw.Include"
#include "InLwrJaw.PoV"
#include "InTopJaw.Include"
#include "InTopJaw.PoV"

#declare BoneSegmentHeight = 3
#declare DragonSeparation = 4

#declare RotationFirstHead_1 = <-30, 0, -30>
#declare RotationFirstHead_2 = <-30, 0, 0>
#declare RotationFirstHead_3 = <50, 0, 0>
#declare RotationFirstHead_4 = <50, 0, 0>
#declare RotationFirstHead_5 = <50, 0, 0>
#declare RotationFirstHead_6 = <30, 0, 0>
#declare RotationFirstHead_7 = <20, 0, 0>
#declare FirstHeadRotation = <-115, 0, 0>
#declare FirstJawRotation = <30, 0, 0>
#declare FirstTongueRotation = <5, 0, 0>

#declare RotationSecondHead_1 = <30, 0, -30> 
#declare RotationSecondHead_2 = <-20, 0, 0>
#declare RotationSecondHead_3 = <-30, 0, 0>
#declare RotationSecondHead_4 = <-20, 0, 0>
#declare RotationSecondHead_5 = <20, 0, 0>
#declare RotationSecondHead_6 = <45, 0, 0>
#declare RotationSecondHead_7 = <40, 0, 0>
#declare SecondHeadRotation = <-50, -20, 0> //<-70, 0, 0>
#declare SecondJawRotation = <20, 0, 0>
#declare SecondTongueRotation = <10, 0, 0>

#declare RotationThirdHead_1 = <20, 0, 0>
#declare RotationThirdHead_2 = <-25, 0, 0>
#declare RotationThirdHead_3 = <-20, 0, 0>
#declare RotationThirdHead_4 = <5, 0, 0>
#declare RotationThirdHead_5 = <30, 0, 0>
#declare RotationThirdHead_6 = <50, 0, 0>
#declare RotationThirdHead_7 = <80, 0, 0>
#declare ThirdHeadRotation = <-80, 0, 0>
#declare ThirdJawRotation = <10, 0, 0>
#declare ThirdTongueRotation = <5, 0, 0> 

union { // Hydra dragon, therefore consists of three heads
	union {
		union {
			union {
				union {
					union {
						union {
							union {
								union {
									union {
										object { DragonTopHead }
										object { InTopJawFull scale <0.99, 0.99, 0.05> }
										bounded_by { HeadTopBound }
										}
									object { DragonHorns }
									object { LowerJaw rotate FirstJawRotation }
									object { Tongue scale <1, 1.25, 1> rotate FirstTongueRotation }
									object { InLowerJaw rotate FirstJawRotation }
									scale 0.5
									rotate FirstHeadRotation
									translate <0, 0, BoneSegmentHeight>
									}
								object { BackBoneSegment }
								rotate RotationFirstHead_7
								translate <0, 0, BoneSegmentHeight>
								}
							object { BackBoneSegment }
							rotate RotationFirstHead_6
							translate <0, 0, BoneSegmentHeight>
							}
						object { BackBoneSegment scale 1.1 }
						rotate RotationFirstHead_5
						translate <0, 0, BoneSegmentHeight> 
						}       
					object { BackBoneSegment scale 1.2 }
					rotate RotationFirstHead_4
					translate <0, 0, BoneSegmentHeight>
					}
				object { BackBoneSegment scale 1.3 }
				rotate RotationFirstHead_3
				translate <0, 0, BoneSegmentHeight>
				}
			object { BackBoneSegment scale 1.4 }
			rotate RotationFirstHead_2
			translate <0, 0, BoneSegmentHeight>
			}       
		object { BackBoneSegment scale 1.5 }
		object { BackBoneSegment scale 1.6 translate <0, 0, -BoneSegmentHeight> }
		object { BackBoneSegment scale 1.7 translate <0, 0, -2*BoneSegmentHeight> }
		object { BackBoneSegment scale 1.8 translate <0, 0, -3*BoneSegmentHeight> }
		rotate RotationFirstHead_1
		translate <-DragonSeparation, 0, 2.5>
		}
	union { // Second head on the dragon
		union {
			union {
				union {
					union {
						union {
							union {
								union {
									union {
										object { DragonTopHead }
										object { InTopJawFull scale <0.99, 0.99, 0.05> }
										bounded_by { HeadTopBound }
										}
									object { DragonHorns }
									object { LowerJaw rotate SecondJawRotation }
									object { Tongue rotate SecondTongueRotation }
									object { InLowerJaw rotate SecondJawRotation }
									scale 0.5
									rotate SecondHeadRotation
									translate <0, 0, BoneSegmentHeight>
									}
								object { BackBoneSegment }
								rotate RotationSecondHead_7
								translate <0, 0, BoneSegmentHeight>
								}
							object { BackBoneSegment }
							rotate RotationSecondHead_6
							translate <0, 0, BoneSegmentHeight>
							}
						object { BackBoneSegment scale 1.1 }
						rotate RotationSecondHead_5
						translate <0, 0, BoneSegmentHeight> 
						}       
					object { BackBoneSegment scale 1.2 }
					rotate RotationSecondHead_4
					translate <0, 0, BoneSegmentHeight>
					}
				object { BackBoneSegment scale 1.3 }
				rotate RotationSecondHead_3
				translate <0, 0, BoneSegmentHeight>
				}
			object { BackBoneSegment scale 1.4 }
			rotate RotationSecondHead_2
			translate <0, 0, BoneSegmentHeight>
			}       
		object { BackBoneSegment scale 1.5 }
		object { BackBoneSegment scale 1.6 translate <0, 0, -BoneSegmentHeight> }
		object { BackBoneSegment scale 1.7 translate <0, 0, -2*BoneSegmentHeight> }
		object { BackBoneSegment scale 1.8 translate <0, 0, -3*BoneSegmentHeight> }
		rotate RotationSecondHead_1
		translate <0, 0, BoneSegmentHeight>
		}
	union { // Third head of the dragon
		union {
			union {
				union {
					union {
						union {
							union {
								union {
									union {
										object { DragonTopHead }
										object { InTopJawFull scale <0.99, 0.99, 0.05> }
										bounded_by { HeadTopBound }
										}
									object { DragonHorns }
									object { LowerJaw rotate ThirdJawRotation }
									object { Tongue rotate ThirdTongueRotation }
									object { InLowerJaw rotate ThirdJawRotation }
									scale 0.5
									rotate ThirdHeadRotation
									translate <0, 0, BoneSegmentHeight>
									}
								object { BackBoneSegment }
								rotate RotationThirdHead_7
								translate <0, 0, BoneSegmentHeight>
								}
							object { BackBoneSegment }
							rotate RotationThirdHead_6
							translate <0, 0, BoneSegmentHeight>
							}
						object { BackBoneSegment scale 1.1 }
						rotate RotationThirdHead_5
						translate <0, 0, BoneSegmentHeight> 
						}       
					object { BackBoneSegment scale 1.2 }
					rotate RotationThirdHead_4
					translate <0, 0, BoneSegmentHeight>
					}
				object { BackBoneSegment scale 1.3 }
				rotate RotationThirdHead_3
				translate <0, 0, BoneSegmentHeight>
				}
			object { BackBoneSegment scale 1.4 }
			rotate RotationThirdHead_2
			translate <0, 0, BoneSegmentHeight>
			}       
		object { BackBoneSegment scale 1.5 }
		object { BackBoneSegment scale 1.6 translate <0, 0, -BoneSegmentHeight> }
		object { BackBoneSegment scale 1.7 translate <0, 0, -2*BoneSegmentHeight> }
		object { BackBoneSegment scale 1.8 translate <0, 0, -3*BoneSegmentHeight> }
		rotate RotationThirdHead_1
		translate <DragonSeparation, 0, 2.5>
		}
	scale 1.125
	translate <20, -30, 0>
	}
