//
// DART.POV - Official 18 inch English bristle
//            dart board with steel spider and
//            brass darts. Simply beautiful!
//
// By Neil Clark
//
// SysOp - The Tackle Box BBS
// (405) 359-3301
// Internet: clark@qns1.qns.com
//
// For the December 'Games' Internet ray tracing contest.
//
// Inspired from the many hours of trying to hit that darn bulls-eye!

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

// Darts include file
#include "dart.inc"

// Numerals
#include "0.inc"
#include "1.inc"
#include "2.inc"
#include "3.inc"
#include "4.inc"
#include "5.inc"
#include "6.inc"
#include "7.inc"
#include "8.inc"
#include "9.inc"

camera{
  location < 5, 4, -11.5 >  // perspective
  look_at < 0, 1.7, 0  >
}

light_source { <  15, 20 , -40> color White }
light_source {
    <10, 5, -40> color White
    area_light <7, 0, 0>, <0, 8, 0>, 3, 3
    adaptive 0
    jitter
    spotlight
    point_at <0, 0, 0>
    tightness 0
    radius 0
    falloff 15
}

object { plane { z, 0 texture { EMBWood1 scale <1,12,1> }}}

#declare Bulls_Eye_Red = object
 {
  Disk_Z scale <0.25, 0.25, 0.25> texture { pigment { color Red }}
 }

#declare ring1 = object
  {
    torus { 1.0, 0.1 rotate <  90, 0, 0 > scale <  0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare Bulls_Eye_Green = difference
  {
   object
    {
     Disk_Z scale <0.5, 0.5, 0.25> texture { pigment { color ForestGreen }}
    }
   object
    {
     Disk_Z
     scale <0.25, 0.25, 0.26>
     texture { pigment { color ForestGreen }}
    }
  }

#declare ring2 = object
  {
    torus { 2.0, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare ring3 = object
  {
    torus { 10.0, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare ring4 = object
  {
    torus { 11.0, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare ring5 = object
  {
    torus { 16.0, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare ring6 = object
  {
    torus { 17.0, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare ring7 = object
  {
    torus { 22.7, 0.1
    rotate < 90, 0, 0 >
    scale < 0.25, 0.25, 0.25 >
   }
  texture { Glossy Silver_Texture }
}

#declare Inner_White_Pie_Piece = intersection
  {
   object
    {
     Disk_Z
     scale <2.5, 2.5, 0.25>
     texture { pigment { color Wheat }}
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Inner_Black_Pie_Piece = intersection
  {
   object
    {
     Disk_Z
     scale <2.5, 2.5, 0.25>
     texture { pigment { color Black }}
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Middle_Green_Piece = difference
  {
   object
    {
     Disk_Z
     scale <2.75, 2.75, 0.25>
     texture { pigment { color ForestGreen }}
    }
   object
    {
     Disk_Z
     scale <2.5, 2.5, 0.26>
     texture { pigment { color ForestGreen }}
    }
  }

#declare Middle_Green_Pie = intersection
  {
   object { Middle_Green_Piece }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Middle_Red_Piece = difference
  {
   object
    {
     Disk_Z
     scale <2.75, 2.75, 0.25>
     texture { pigment { color Red }}
    }
   object
    {
     Disk_Z
     scale <2.5, 2.5, 0.26>
     texture { pigment { color Red }}
    }
  }

#declare Middle_Red_Pie = intersection
  {
   object
    {
     Middle_Red_Piece
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Outer_White_Piece = difference
  {
   object
    {
     Disk_Z
     scale <4, 4, 0.25>
     texture { pigment { color Wheat }}
    }
   object
    {
     Disk_Z
     scale <2.75, 2.75, 0.26>
     texture { pigment { color Wheat }}
    }
  }

#declare Outer_White_Pie = intersection
  {
   object
    {
     Outer_White_Piece
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Outer_Black_Piece = difference
  {
   object
    {
     Disk_Z
     scale <4, 4, 0.25>
     texture { pigment { color Black }}
    }
   object
    {
     Disk_Z
     scale <2.75, 2.75, 0.26>
     texture { pigment { color Black }}
    }
  }

#declare Outer_Black_Pie = intersection
  {
   object
    {
     Outer_Black_Piece
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Outer_Green_Piece = difference
  {
   object
    {
     Disk_Z
     scale <4.25, 4.25, 0.25>
     texture { pigment { color ForestGreen }}
    }
   object
    {
     Disk_Z
     scale <4, 4, 0.26>
     texture { pigment { color ForestGreen }}
    }
  }

#declare Outer_Green_Pie = intersection
  {
   object
    {
     Outer_Green_Piece
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Outer_Red_Piece = difference
  {
   object
    {
     Disk_Z
     scale <4.25, 4.25, 0.25>
     texture { pigment { color Red }}
    }
   object
    {
     Disk_Z
     scale <4, 4, 0.26>
     texture { pigment { color Red }}
    }
  }

#declare Outer_Red_Pie = intersection
  {
   object
    {
     Outer_Red_Piece
    }
   object
    {
     plane { y, 0 }
     rotate <0,0,9>
     pigment { rgbf <1,1,1,1> }
    }
   object
    {
     plane { -y, 0 }
     rotate <0,0,-9>
     pigment { rgbf <1,1,1,1> }
    }
  }

#declare Radial_Tube = object
  {
    cylinder { <0, 0, -0.25>, <4, 0, -0.25>, 0.025 }
    texture { Glossy Silver_Texture }
  }

#declare Outer_Black_Piece = difference
  {
   object
    {
     Disk_Z
     scale <5.75, 5.75, 0.25>
     texture { pigment { color Black }}
    }
   object
    {
     Disk_Z
     scale <4.25, 4.25, 0.26>
     texture { pigment { color Black }}
    }
  }

#declare Hanger_Part1 = object
  {
    cylinder { <-0.35, 0, -0.25>, <0.35, 0, -0.25>, 0.05 }
    texture { Glossy Silver_Texture }
  }

#declare Hanger_Part2 = object // Nail
  {
    cylinder { <0, 0, -0.5>, <0, 0, 0.25>, 0.06 }
    rotate <10, 0, 0>
    translate <0,-0.1,0>
    texture { pigment { color Grey }}
  }

#declare Hanger = union
  {
    object { Hanger_Part1 rotate <0,0,45> translate <-0.225,0,0> }
    object { Hanger_Part1 rotate <0,0,-45> translate <0.225,0,0> }
    object { Hanger_Part2 rotate <20,0,0> translate <0,0,0> }
  }

#declare Dart_Board = union
  {
    // From the center out

    object { Bulls_Eye_Red translate <0, 1, 0> }
    object { ring1 translate <0, 1, -0.25> }
    object { Bulls_Eye_Green translate <0, 1, 0> }
    object { ring2 translate <0, 1, -0.25> }

    // Inner White and Black 'Wheel'

    object { Inner_White_Pie_Piece translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,18> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,36> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,54> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,72> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,90> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,108> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,126> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,144> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,162> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,180> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,198> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,216> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,234> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,252> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,270> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,288> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,306> translate <0, 1, 0.01> }
    object { Inner_White_Pie_Piece rotate <0,0,324> translate <0, 1, 0.01> }
    object { Inner_Black_Pie_Piece rotate <0,0,342> translate <0, 1, 0.01> }

    // Spider Ring

    object { ring3 translate <0, 1, -0.25> }

    // Small Green and Red middle Section

    object { Middle_Green_Pie translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,18> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,36> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,54> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,72> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,90> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,108> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,126> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,144> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,162> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,180> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,198> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,216> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,234> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,252> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,270> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,288> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,306> translate <0, 1, 0.01> }
    object { Middle_Green_Pie rotate <0,0,324> translate <0, 1, 0.01> }
    object { Middle_Red_Pie rotate <0,0,342> translate <0, 1, 0.01> }

    // Spider Ring

    object { ring4 translate <0, 1, -0.25> }

    // Outer 'Wheel' Section

    object { Outer_White_Pie translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,18> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,36> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,54> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,72> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,90> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,108> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,126> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,144> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,162> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,180> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,198> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,216> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,234> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,252> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,270> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,288> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,306> translate <0, 1, 0.01> }
    object { Outer_White_Pie rotate <0,0,324> translate <0, 1, 0.01> }
    object { Outer_Black_Pie rotate <0,0,342> translate <0, 1, 0.01> }

    // Spider Ring
    object { ring5 translate <0, 1, -0.25> }

    // Outer Green and Red Sections

    object { Outer_Green_Pie translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,18> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,36> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,54> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,72> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,90> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,108> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,126> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,144> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,162> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,180> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,198> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,216> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,234> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,252> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,270> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,288> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,306> translate <0, 1, 0.01> }
    object { Outer_Green_Pie rotate <0,0,324> translate <0, 1, 0.01> }
    object { Outer_Red_Pie rotate <0,0,342> translate <0, 1, 0.01> }

    // Spider Ring

    object { ring6 translate <0, 1, -0.25> }

    // Spider Radial Tubes

    object { Radial_Tube translate <0.5,0,0> rotate <0,0,9> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,27> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,45> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,63> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,81> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,99> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,117> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,135> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,153> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,171> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,189> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,207> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,225> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,243> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,261> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,279> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,297> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,315> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,333> translate <0,1,0> }
    object { Radial_Tube translate <0.5,0,0> rotate <0,0,351> translate <0,1,0> }

    // Black Outer Border

    object { Outer_Black_Piece translate <0, 1, 0.01> }

    // Border Spider Ring

    object { ring7 translate <0, 1, -0.25> }

    // Hanger on the wall

    object { Hanger rotate <15, 0, 0> translate <0, 6.9, 0.2> }
  }

// Place the Dart Board

object { Dart_Board translate <0, 0, 0> }

// 'Throw' in a round of darts here and there....

object { Blue_Dart scale <0.4,0.4,0.4> rotate <-30,-120,10> translate <-0.1, 0.25, -0.65> }
object { Blue_Dart scale <0.4,0.4,0.4> rotate <30,-75,40> translate <-1.8, 2.3, -0.65> }
object { Blue_Dart scale <0.4,0.4,0.4> rotate <-10,-90,-10> translate <-1.1, -1.8, -0.65> }
object { Yellow_Dart scale <0.4,0.4,0.4> rotate <-20,-80,25> translate <-1.2, -0.6, -0.65> }
object { Yellow_Dart scale <0.4,0.4,0.4> rotate <35,-113,-8> translate <3, 2, -0.65> }
object { Yellow_Dart scale <0.4,0.4,0.4> rotate <-25,-90,15> translate <1, 3.65, -0.65> }

// Numerals - Start at the top and go clockwise

// 20
object { Char_Two  scale <0.75, 0.75, 0.75> translate <0, 6.15, -0.25> rotate <0, 0, 4> }
object { Char_Zero scale <0.75, 0.75, 0.75> translate <0, 6.15, -0.25> rotate <0, 0, 0> }

// 1
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, -18> translate <1.5, 5.9, -0.25> }

// 18
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, -36> translate <2.7, 5.4, -0.25> }
object { Char_Eight scale <0.75, 0.75, 0.75> rotate <0, 0, -36> translate <3.05, 5.1, -0.25> }

// 4
object { Char_Four scale <0.75, 0.75, 0.75> rotate <0, 0, -54> translate <4.0, 4.20, -0.25> }

// 13
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, -68> translate <4.7, 3, -0.25> }
object { Char_Three scale <0.75, 0.75, 0.75> rotate <0, 0, -68> translate <4.83, 2.6, -0.25> }

// 6
object { Char_Six scale <0.75, 0.75, 0.75> rotate <0, 0, -90> translate <5.11, 1.2, -0.25> }

// 10
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 69> translate <5.27, -1.1, -0.25> }
object { Char_Zero scale <0.75, 0.75, 0.75> rotate <0, 0, 70> translate <5.37, -0.75, -0.25> }

// 15
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 50> translate <4.35, -2.65, -0.25> }
object { Char_Five scale <0.75, 0.75, 0.75> rotate <0, 0, 52> translate <4.58, -2.32, -0.25> }

// 2
object { Char_Two scale <0.75, 0.75, 0.75> rotate <0, 0, 36> translate <3.2, -3.7, -0.25> }

// 17
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 17> translate <1.4, -4.5, -0.25> }
object { Char_Seven scale <0.75, 0.75, 0.75> rotate <0, 0, 18> translate <1.75, -4.38, -0.25> }

// 3
object { Char_Three scale <0.75, 0.75, 0.75> rotate <0, 0, 0> translate <-0.2, -4.65, -0.25> }

// 19
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, -18> translate <-2.2, -4.26, -0.25> }
object { Char_Nine scale <0.75, 0.75, 0.75> rotate <0, 0, -18> translate <-1.8, -4.38, -0.25> }

// 7
object { Char_Seven scale <0.75, 0.75, 0.75> rotate <0, 0, -36> translate <-3.45, -3.48, -0.25> }

// 16
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, -55> translate <-4.9, -1.89, -0.25> }
object { Char_Six scale <0.75, 0.75, 0.75> rotate <0, 0, -55> translate <-4.7, -2.19, -0.25> }

// 8
object { Char_Eight scale <0.75, 0.75, 0.75> rotate <0, 0, -72> translate <-5.46, -0.52, -0.25> }

// 11
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 90> translate <-5.14, 0.9, -0.25> }
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 90> translate <-5.14, 0.5, -0.25> }

// 14
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 72> translate <-5.02, 2.11, -0.25> }
object { Char_Four scale <0.75, 0.75, 0.75> rotate <0, 0, 71> translate <-4.88, 2.5, -0.25> }

// 9
object { Char_Nine scale <0.75, 0.75, 0.75> rotate <0, 0, 54> translate <-4.29, 3.83, -0.25> }

// 12
object { Char_One scale <0.75, 0.75, 0.75> rotate <0, 0, 36> translate <-3.4, 4.86, -0.25> }
object { Char_Two scale <0.75, 0.75, 0.75> rotate <0, 0, 36> translate <-3.04, 5.12, -0.25> }

// 5
object { Char_Five scale <0.75, 0.75, 0.75> rotate <0, 0, 18> translate <-1.9, 5.78, -0.25> }



