#declare handTx = texture { Grnt28 scale <8,8,8> }
#declare hWireTx = texture { pigment { VLightGrey } finish { Shiny } }
#declare springTx = texture { pigment { DarkSlateGrey } finish { Shiny } }

#declare mitt =
object {
  merge {
    // Fingers
    cylinder { <25,15,0>, <45,15,0>, 4 }  sphere { <45,15,0>, 4 }
    cylinder { <35, 9,0>, <60, 9,0>, 4 }  sphere { <60, 9,0>, 4 }
    cylinder { <35, 3,0>, <50, 3,0>, 4 }  sphere { <50, 3,0>, 4 }
    cylinder { <35,-3,0>, <45,-3,0>, 4 }  sphere { <45,-3,0>, 4 }
    cylinder { <25,-9,0>, <40,-9,0>, 4 }  sphere { <40,-9,0>, 4 }

    // Palm
    box { <25, -9, -3.99>, <35,15, 3.99> }
    sphere { <25, -9, 0>, 4 }
    sphere { <25, 15, 0>, 4 }
    cylinder { <25,-9,0>, <25,15,0>, 4 }
  }
  texture { handTx }
}

#declare mittWire =
object {
  union {
    union {
      cylinder { <25, 0, 0>, <-35, 0, 0>, 2 }
      torus { 6, 2  clipped_by { plane { -x,2 } } translate <-42,0,0> }
      cylinder { <-32, 0, 0>, <-35, 0, 0>, 6 }
      cylinder { <-43, 0, 4>, <-43, 0, -4>, 0.75 }
      texture { hWireTx }
    }
    difference {
      cylinder { <-43, 0, -3>, <-43, 0, 3>, 4 }
      union {
        cylinder { <-43, 0, -3.1>, <-43, 0, -1>, 2 }
        cylinder { <-43, 0,  3.1>, <-43, 0,  1>, 2 }
      }
      texture { pigment { DarkSlateGrey } finish { Shiny } }
    }
  }
  rotate 90*x
}

#include "stretch.inc"
#include "compress.inc"

#declare sHand =
object {
  union {
    union {
      object { mitt }
      object { mittWire }
      scale < 0.6, 0.6, 0.6 >
    }
    object { stretchSpring rotate 90*z scale <3,3,3> translate <-9.3,0,0> }
  }
  translate <-50, 31, 0>
}

#declare cHand =
object {
  union {
    union {
      object { mitt }
      object { mittWire }
      scale < 0.6, 0.6, 0.6 >
    }
    object { compressSpring rotate 90*z scale <3,3,3> translate <-12.3,0,0> }
  }
  translate <-50, 31, 0>
}

object { cHand translate < 3, -17, 0 > }
object { sHand translate < 0,   3, 0 > }
object { sHand translate < 0,  23, 0 > }
object { cHand translate < 3,  43, 0 > }


