// Competition picture 2 textures for POV-Ray 2.2
// Made and collected by Jari Juslin
// All textures are made by hand or collected from textures.inc
// First edit ??.??.??, last 25.02.95

#declare Polished_Brass = texture {
    pigment { color red 0.578 green 0.422 blue 0.195 }
    finish {
        metallic
        ambient 0.0
        diffuse 1.0
        brilliance 6.0
        reflection 0.4
        phong 0.8
        phong_size 120
   }
}

#declare SilverFinish = finish {
    metallic
    ambient 0.0
    diffuse 1.0
    reflection 0.45
    brilliance 6
    phong 1
    phong_size 100
}

#declare Silver3_Colour = color  red 0.94 green 0.93 blue 0.90

#declare Silver3 = texture {
    pigment { Silver3_Colour }
    finish { SilverFinish }
}

// First edit 10.02.95, last 10.02.95
#declare JJPine1 = texture { // Finnish pine wood
  pigment {
    wood
    color_map {
      [0.0 color rgb < 1.0, 0.657, 0.288 > ]
      [0.25 color rgb < 0.95, 0.603, 0.264 > ]
      [0.8 color rgb < 0.66528, 0.387, 0.16 > ]
      [1.0 color rgb < 0.60, 0.2376, 0.1056 > ]
    }
    turbulence 0.01
  }
  scale < 0.5, 0.5, 0.5 >
}

// First edit 11.02.95, last 18.02.95
#declare JJBlackPlastic1 = texture { // Rough black plastic for MIDI keyboard
  pigment {
      color rgb < 0.1, 0.1, 0.1 >
    }
  finish {
    specular 0.1
    roughness 0.2
  }
  scale < 0.0001, 0.0001, 0.0001 >
}

//First edit 18.02.95, last 18.02.95
#declare JJMoonClouds0 = texture { // Clouds for moony sky
  pigment {
    onion
    color_map {
      [0.0 color Clear ]
      [0.3 color Clear]
      [0.7 color Gray10]
      [1.0 color Clear]
    }
    turbulence 1.0
  }
  finish {
    diffuse 0.0
    ambient 1.0
  }
}

// First edit 18.02.95, last 19.02.95
#declare JJLand0 = texture { // Grassy ground
  pigment {
    bozo
    color_map {
      [0.0 color DarkOliveGreen ]
      [1.0 color MediumForestGreen ]
    }
    turbulence 0.5
  }
  normal {
    bumps 0.4
    scale < 0.1, 0.1, 0.1 >
  }
}

// First edit 22.02.95, last 23.02.95
#declare JJPine2 = texture { // Finnish pine wood
  pigment {
    wood
    color_map {
      [0.0 color rgb < 1.0, 0.657, 0.288 > ]
      [0.05 color rgb < 0.95, 0.603, 0.264 > ]
      [0.16 color rgb < 0.66528, 0.387, 0.16 > ]
      [0.2 color rgb < 0.60, 0.2376, 0.1056 > ]
      [0.23 color rgb < 1.0, 0.657, 0.288 > ]
      [0.27 color rgb < 0.95, 0.603, 0.264 > ]
      [0.38 color rgb < 0.66528, 0.387, 0.16 > ]
      [0.43 color rgb < 0.60, 0.2376, 0.1056 > ]
      [0.45 color rgb < 1.0, 0.657, 0.288 > ]
      [0.55 color rgb < 0.95, 0.603, 0.264 > ]
      [0.56 color rgb < 0.66528, 0.387, 0.16 > ]
      [0.70 color rgb < 0.60, 0.2376, 0.1056 > ]
      [0.80 color rgb < 1.0, 0.657, 0.288 > ]
      [0.83 color rgb < 0.95, 0.603, 0.264 > ]
      [0.84 color rgb < 0.66528, 0.387, 0.16 > ]
      [0.85 color rgb < 0.60, 0.2376, 0.1056 > ]
      [0.90 color rgb < 1.0, 0.657, 0.288 > ]
      [0.98 color rgb < 0.95, 0.603, 0.264 > ]
      [0.99 color rgb < 0.66528, 0.387, 0.16 > ]
      [1.0 color rgb < 0.60, 0.2376, 0.1056 > ]
    }
    turbulence 0.01
  }
  normal {
    bumps 0.1
    scale < 0.005, 0.005, 0.005>
  }
  finish {
    reflection 0.1
    specular 1.0
    roughness 0.001
    diffuse 1.0
    ambient 0.0
  }
  scale < 30, 30, 30 >
}

// First edit 23.02.95, last 23.02.95
#declare JJWhiteWall0 = texture {
  pigment { color rgb < 0.9, 0.88, 0.8 > }
  normal {
    bumps 0.05
    scale < 0.0001, 0.0001, 0.0001 >
  }
  finish {
    ambient 0.0
    diffuse 1.0
  }
}

// First edit 23.02.95, last 23.02.95
#declare JJDarkWood0 = texture {
  pigment {
    wood
    turbulence 0.05
    octaves 6
    scale <0.075, .075, 1>
    color_map {
      [0.00, 0.10 color red 0.3 green 0.1 blue 0.05
                  color red 0.3 green 0.1 blue 0.05]
      [0.10, 0.90 color red 0.3 green 0.1 blue 0.05
                  color red 0.25 green 0.07 blue 0.038]
      [0.90, 1.0  color red 0.25 green 0.07 blue 0.038
                  color red 0.25 green 0.07 blue 0.038]
    }
  }
  finish {
    ambient 0.0
    diffuse 1.0
  }
  scale < 10, 10, 10 >
}

// First edit 23.02.95, last 23.02.95
#declare JJWindowGlass0 = texture {
  pigment { color Clear }
  finish {
    ambient 0
    diffuse 0
    reflection 0.6
    phong 0.3
    phong_size 60
  }
}

// First edit 23.02.95, last 23.02.95
#declare JJParquetFloor0 = texture {
  tiles {
    texture {
      JJPine2
      rotate < 90, 0, 0 >
      scale < 0.1, 0.1, 0.1 >
      rotate < 3, 5, 7 >
    }
    texture {
      pigment {
        gradient x
        color_map {
          [0.0 color Black]
          [0.05 color Clear]
          [0.95 color Clear]
          [1.0 color Black]
        }
        scale < 0.125, 0.125, 0.125 >
      }
    }
    tile2
    texture {
      JJPine2
      rotate < 0, 90, 0 >
      scale < 0.1, 0.1, 0.1 >
      rotate < 9, 6, 3 >
    }
    texture {
      pigment {
        gradient y
        color_map {
          [0.0 color Black]
          [0.05 color Clear]
          [0.95 color Clear]
          [1.0 color Black]
        }
        scale < 0.125, 0.125, 0.125 >
      }
    }
  }
}

// First edit 24.02.95, last 24.02.95
#declare JJSea0 = texture {
  pigment { color rgb < 0.2, 0.2, 0.3 > filter 0.9 }
  normal {
    ripples 0.75
    frequency 10
    scale < 0.1, 0.1, 0.1 >
  }
  finish {
    reflection 0.3
    refraction 0.5
    ior 1.33
    ambient 0.0
    diffuse 1.0
  }
}

//First edit 24.02.95, last 24.02.95
#declare JJMoon0 = texture {
  pigment {
    bozo
    color_map {
      [ 0.0 color rgb < 0.7, 0.7, 0.8 > ]
      [ 0.4 color rgb < 0.75, 0.75, 0.8 > ]
      [ 0.4 color rgb < 0.8, 0.8, 0.8 > ]
      [ 1.0 color rgb < 1.0, 1.0, 0.9 > ]
    }
    scale < 0.5, 0.5, 0.5 >
  }
  finish {
    ambient   1.0
    diffuse   0.0
  }
}

// First edit 24.02.95, last 24.02.95
#declare JJDisplay1 = texture {
  pigment { color rgb < 0.686,  0.682,  0.539> }
  finish {
    ambient   0.0
    diffuse   1.0
    brilliance   1.00
    specular  0.1
    roughness  0.5
  }
}

// First edit 24.02.95, last 24.02.95
#declare JJDisplay0 = texture {
  material_map {
    gif "mw_disp0.gif"
    map_type 0
    interpolate 4
    once
    texture {
      JJDisplay1
      normal {
        bump_map {
          gif "mw_disp1.gif"
          map_type 0
          bump_size 5
          interpolate 4
          once
        }
      }
    }
    texture { pigment { color rgb < 0.8, 0.8, 0.2 > } }
    texture { pigment { Black } }
    texture {
      pigment { color Feldspar }
      normal {
        bump_map {
          gif "mw_disp1.gif"
          map_type 0
          bump_size 5
          interpolate 2
          once
        }
      }
      finish {
        ambient   0.0
        diffuse   1.0
        brilliance   1.00
        specular  0.1000
        roughness  0.500
      }
    }
    texture {
      pigment { color rgb < 0.2, 0.9, 0.2 > }
      finish { ambient 1.0 diffuse 0.0 }
    }
  }
  rotate < 90, 0, 0 >
  scale < 38, 38, 38/6.4 >
  translate < -19, 0, 1 >
}

// First edit 24.02.95, last 24.02.95
#declare JJCrtGlass0 = texture {
  pigment { color rgbf < 1.000,  1.000,  1.000,  1.000> }
  finish {
    ambient   0.0
    diffuse   1.0
    brilliance   1.00
    specular  0.1000
    roughness  0.1000
    reflection  0.100
  }
}

// First edit 24.02.95, last 24.02.95
#declare JJScreen0 = texture {
  pigment {
    image_map {
      gif "mw_scren.gif"
      interpolate 2
    }
  }
  finish {
    ambient 1.0
    diffuse 0.0
  }
  rotate < 90, 0, 0 >
  scale 2.0
  translate < -1, 0, 1 >
  scale < 18/19, 1.0, 18/19 >
}

// First edit 24.02.95, last 24.02.95
#declare JJWoodenCeiling0 = texture {
  JJPine2
  scale < 10, 10, 10 >
}
