// PIANO.INC
//
// Piano Object - For PIANO.POV
//
// Neil Clark - 2/95
//
// For the 2/95 'Sound/Music' Ray Tracing Contest
//

#declare Piano_Left_Side = intersection
  {
   object
    {
     box
      {
       <0, 0, 0>, <12, 39, 0.75>
      }
     texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
    }
   object
    {
     plane
      {
       x, 12
       rotate <0, 0, 18>
       translate <9, 0, 0>
       texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
      }
    }
  }

#declare Piano_Right_Side = intersection
  {
   object
    {
     box
      {
       <0, 0, 0>, <12, 39, 0.75>
      }
     texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
    }
   object
    {
     plane
      {
       x, 12
       rotate <0, 0, 18>
       translate <9, 0, 0>
       texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
      }
    }
  }

#declare Piano_Top = intersection
  {
    box { <0, 39, 0>,<9.25, 39.75, 59.75> }
    plane { x, 0 rotate <0, 0, 18> translate <21.7, 0, 0> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Front = object
  {
    box { <0, 0, 0.5>,<0.75, 26, 59.75> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Arm =  union
{
   object
   {
    cylinder
    { <0.0, 0.0, -1.0>,<0.0, 0.0, 1.0>, 1
    scale < 0.42, 0.42, 0.6>
    translate < 3.9, 1.4, 0.00000>
    }
   }
   object
   {
    cylinder
		{ <0.0, 0.0, -1.0>,<0.0, 0.0, 1.0>,1 
    scale < 0.38000, 0.38000, 0.6>
    translate < 3.95, -1.5, 0.00000>
    }
   }
   object
   {
    box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
    scale < 3.8, 3.8, 0.6>
    translate < 0.02, 0.02, 0.00000>
    }
   }
   object
   {
    box
		{<-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0> 
    scale < 3.50000, 1.4, 0.60000>
    translate < 0.82, 0, 0.00000>
    }
   }
 texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
}

#declare Piano_Arm = intersection
  {
   object { Arm }
   object { plane { <1.00000, 0.0, 0.0>, 0.0 }
		rotate < 0, 0, 74>
    translate < 1.10000, 2.58, 0>
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
   }
   object { plane { <1.00000, 0.0, 0.0>, 0.0 }
		rotate < 0, 0, 286>
    translate < 0.10000, -2.93000, 0.00000>
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
   }
 }

#declare Piano_Key_Face_Plate = object
  {
    box { <19.5, 24.5, 1>, <20, 26.5, 58.7> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Key_Rest = object
  {
    box { <10, 24.5, 1>, <19.5, 26, 58.7> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Front_Rise = object
  {
    box { <12.1, 22, 0.75>, <13.1, 37, 59.1> }
    texture { Shiny DMFLightOak scale <0.67, 10, 0.7> rotate <-90,0,0> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Back_Plate = object
  {
    box { <12.5, 24.5, 1>, <13.6, 27.5, 58.7> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Back_Hinge_Rise = object
  {
    box { <10.5, 24.5, 1>, <13, 29.2, 58.7> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Left_Cheek_Plate = object
  {
    box { <0.5, 0, 0>, <6.5, 1, 4> }
    rotate <0,0,0>
    translate <13, 26, 1>
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Right_Cheek_Plate = object
  {
    box { <0.5, 0, 0>, <6.5, 1, 1.5> }
    rotate <0,0,0>
    translate <13, 26, 57.1>
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Front_Base_Trim = object
  {
    box { <0, 0, 0.5>,<0.25, 3, 59.75> }
    texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
  }

#declare Piano_Lid = union
  {
    object {
      box { <0, 0, 1.5>, <0.5, 7, 58.1> }
      texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
    }
    object {
      box { <0.5, 6.4, 1.5>, <1.25, 6.8, 58.1> }
      texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
    }
  }

#declare Music_Tray = object {
      box { <0.5, 1.4, 15>, <1.75, 1.8, 45> }
      texture { DMFWood5 scale <13, 1.4, 1.5> finish { Shiny }}
    }

#declare Pedal =  union
{
 object
  {
   sphere
    {
     <0.0, 0.0, 0.0> , 1.0
     scale < 0.86, 0.26, 1.02>
     translate < 0, 0, 0 >
    }
   }
 object
  {
   cone
    {
     <0.0, 0.0, -0.5>,1,<0.0, 0.0, 0.5>,0
     scale < 0.72000, 0.22000, 2.48000>
     translate < -0.00000, 0.00000, 1.52000>
    }
  }
 texture { pigment { color Brass }}
}

#declare Piano = union
  {
   object { Piano_Left_Side }
   object { Piano_Right_Side translate <0, 0, 59> }
   object { Piano_Front translate <11, 0, 0> }
   object { Piano_Top }
   object { All_Keys rotate <0,-90,0> translate <19.5, 27, 7.2> }
   object { Piano_Key_Face_Plate }
   object { Piano_Key_Rest }
   object { Piano_Back_Plate }
   object { Piano_Back_Hinge_Rise }
   object { Piano_Front_Rise translate <8,0,0>}
   object { Piano_Arm scale <1.2,1,1> translate <15, 26, 0.75> } // left
   object { Piano_Arm scale <1.2,1,1> translate <15, 26, 59> } // right
   object { Left_Cheek_Plate }
   object { Right_Cheek_Plate }
   object { Piano_Front_Base_Trim translate <11.75, 0, 0> }
   object { Piano_Hinge translate <13.3, 29.6, 2> }
   object { Piano_Lid rotate <0, 0, 30> translate <13.3, 29.6, 0> }
   object { Music_Tray rotate <0, 0, 30> translate <13.3, 29.6, 0> }
   object { Pedal scale <1.5, 2, 2> rotate <0, -90, 0> translate <14, 2, 27> }
   object { Pedal scale <1.5, 2, 2> rotate <0, -90, 0> translate <14.5, 2, 30> }
   object { Pedal scale <1.5, 2, 2> rotate <0, -90, 0> translate <15, 2, 33> }
  }

