// PIANO.POV - Ray Tracing Contest Entry.
//
// Neil Clark - 2/95
//
// For the 2/95 'Sound/Music' Ray Tracing Contest
//
// All rights reserved.

// Standard Includes

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

// Scene Includes

#include "key.inc"
#include "phinge.inc"
#include "pstool.inc"
#include "drapes.inc"
#include "beethovn.inc"
#include "music.inc"
#include "piano.inc"
#include "mic.inc"
#include "micstnd.inc"

camera {
  location < 68, 52, -54 >
  look_at < 38, 21, 0 >
}

light_source { <  100, 1000, -1001 > color Grey }
light_source { <  1000, 10, -1 > color Grey }

light_source { <  100, 1001, -1000 > color Red }
light_source { <  101, 1002, -1000 > color Green }
light_source { <  102, 1003, -1000 > color Blue }

light_source {
    <110, 180, -50> color White
    area_light <37, 0, 0>, <0, 28, 0>, 60, 60
    adaptive 0
    jitter
    spotlight
    point_at <20, 30, -1>
    tightness 0
    radius 0
    falloff 15
}

// Stage Floor

object { plane { y, -2 }
  texture { Shiny DMFLightOak scale <2,2,30> rotate <0,0,90> }}

// Place the objects in the scene

object { My_Drapes
    rotate <0, 0, 0>
    scale <45, 35, 5>
    translate <-10, 2, 42>
   }
object { Piano
    rotate <0, 25, 0>
    translate <20, 0, -20>
   }
object { Piano_Stool
    rotate <0, 25, 0>
    translate <37, 0, -11>
   }
object { Sheet_Music
    scale <0.8, 0.8, 0.01>
    rotate <27, -65, 0>
    translate <44.5, 32, -4>
   }
object { Bee
    rotate <0, -260, 0>
    translate <31, 45.3, -8>
   }
object { Microphone
    rotate <0, 90, 0>
    translate <-18, 0, 2>
   }

