///////////////////////////////////////////////////////////////////////////
// Gibson guitar by Patrick Collins.
// Modelled with Moray 1.5 
///////////////////////////////////////////////////////////////////////////

// Standard include files from povray.
#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "fov.inc"

// Scene specifics
#include "cameras.inc"

// Gibson guitar parts
#include "gibson.inc"
#include "body.inc"
#include "hardware.inc"
#include "strings.inc"
#include "head.inc"
#include "hardware.inc"
#include "knobs.inc"
#include "neck.inc"
#include "amp.inc"
#include "cord.inc"

// *******  CAMERAS *******
// MAY CHANGE FOR A DIFFERENT VIEW!!
camera { best }
//camera { num3 }

// Use this line if we want to put the guitar declaration in another file.
#declare Guitar = union {

   // These are defined in BODY.INC
      object { Body }   

   // These are defined in KNOBS.INC
      object{ Knobs }
   
   // These are defined in STRINGS.INC
      object{ TheFretBoard } object{ StringsBelow }
      object{ StringsAbove } object{ Strings }
   
   // These are defined in HEAD.INC
      object{ HeadOfGib }

   // These are defined in HARDWARE.INC
      object{ Pickup1 } object{ Pickup2 } object{ Bridge }
      object{ Support } object{ RhythmSwitch }
    
      object{cord}
   }

///////////////////////////////////////////////////
// These are defined in GIBSON.INC
object{ Ground scale 1000000 translate <0.,0.,-1000350> }
object{ Sky }

// This is defined in AMP.INC
object{ Wall }

// This is defined here in GIBSON.INC
object{ Guitar  
        rotate< -25.6008, 5., 15.51>
        translate < 100.6008, 0., 110.0>
      }
