//"dgtoybot.pov" - dave greenwell - dgree@crl.com

#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"

#declare DGold=
  texture {
    pigment {Gold}
    finish {diffuse 0.7 specular .4 roughness .1 reflection .8}
  }

#declare Eye=
object { Sphere  scale <.5,.5,.5>
  pigment { image_map { gif "fract11a.gif" once }  
    translate <-.5,-.5,0> 
    scale <1.4,1,1> }
  finish { Shiny }
}

#declare Socket=
difference {
  object { Sphere scale <.53,.53,.53> }
  object { Sphere scale <.5,.5,.5> }
  object { UnitBox translate <0,1,-1> rotate <-45,0,0> }
  texture {DGold}
}

#declare Torus= 
  object {quartic { < 1,0,0,0,2,0,0,2,0,-0.1,0,0,0,0,0,0,0,0,
  0,0,1,0,0,2,0,0.06,0,0,0,0,1,0,-0.1,0,0.0009 > }
}

#declare Torus2=
  object { quartic { < 1,0,0,0,2,0,0,2,0,-1.13,0,0,0,0,0,0,0,0,0,0,1,0,0,2,
    0,1.12,0,0,0,0,1,0,-1.13,0,0.3136 > }
}

#declare Mount=
union {
  object { Torus }
  object { Torus translate <0,.1,0> }
  object { Torus translate <0,-.1,0> }
  texture {DGold}
}

#declare Stop=
difference {
  object { Sphere
    scale <.5,.5,.5>
    translate <0,-.4,0>
  }
  object { UnitBox
    translate <0,-1,0>
  }
  texture {DGold}
}

#declare Foot=
object { UnitBox scale <.18,.05,.18> }

#declare Strut=
union {
  object { Disk_Y scale <.15,1.54,.15> }
  object { Foot translate <0,1.54,0> }
  object { Foot translate <0,-1.54,0> }
}

#declare Mnt=
object { height_field {gif "dw.gif" 
           water_level .001
       }
  texture { pigment { gradient y
              color_map {
                [0 color NewTan ]
                [0.15 color Coral ]
                [0.175 color Orange ]
                [.2 color Coral ]
                [1.0 color NewTan ]
              }
            }
          }
}

#declare Race=
difference {
  object { Disk_Y
    scale <.16,.16,.16>
  }
  object { Disk_Y
    scale <.155,.165,.155>
  }
  texture {DGold}
}


//scene

object { light_source { <100,100,-100> color White } }

camera {
  location <5,1,-4>
  direction <0,0,1.33>
  look_at <0,0,1>
}

object { Eye rotate <0,-31,0> translate <-.55,0,0> }

object { Eye rotate <0,-25,0> translate <.55,0,0> }

object { Socket translate <-.55,0,0> }

object { Socket translate <.55,0,0> }

object { Mount translate <-.55,-.6,0> }

object { Mount translate <.55,-.6,0> }

object { Disk_Y 
  scale <.15,.4,.15>
  translate <-.55,-.9,0>
  texture {DGold}
}

object { Disk_Y 
  scale <.15,.4,.15>
  translate <.55,-.9,0>
  texture {DGold}
}

object { Disk_X 
  scale <1.1,.15,.15>
  translate <0,-1.3,0>
  texture {DGold}
}

object { Sphere
  scale <.1,.75,.75>
  translate <-.95,-1.3,0>
  texture {DGold}
}

object { Sphere
  scale <.1,.75,.75>
  translate <.95,-1.3,0>
  texture {DGold}
}

object { Torus2
  rotate <0,0,90>
  translate <-.95,-1.3,0>
  texture {DGold}
}

object { Torus2
  rotate <0,0,90>
  translate <.95,-1.3,0>
  texture {DGold}
}

object { Stop
  rotate <0,0,990>
  translate <1.055,-1.3,0>
}

object { Stop
  rotate <0,0,90>
  translate <.845,-1.3,0>
}

object { Stop
  rotate <0,0,-90>
  translate <-.845,-1.3,0>
}

object { Stop
  rotate <0,0,90>
  translate <-1.055,-1.3,0>
}

object { Disk_Z
  scale <.15,.15,.25>
  translate <0,-1.3,.25>
  texture {DGold}
}

object { Race translate <0,-1.3,.6> }

union {
  object { Disk_Y scale <.15,.5,.15> }
  object { Disk_X scale <.37,.15,.15> translate <0,.5,0> }
  object { Sphere
    scale <.15,.15,.15>
    translate <-.37,.5,0>
  }
  object { Sphere
    scale <.15,.15,.15>
    translate <.37,.5,0>
  }
  object { Stop scale <.75,.75,.75> rotate <0,0,180> translate <0,-.5,0> }
  object { Stop scale <.75,.75,.75> translate <0,-.08,0> }
  object { Disk_Z scale <.15,.15,.85> translate <-.37,.5,.85> }
  object { Race rotate <0,0,90> translate <-.37,.5,1.8> }
  object { Disk_Z scale <.15,.15,.85> translate <.37,.5,.85> }
  object { Race rotate <0,0,90> translate <.37,.5,1.8> }
  object { Disk_X scale <.16,.25,.16> translate <0,.5,1.8> }
  object { Strut translate <0,.5,1.8> }
  object { Strut rotate <45,0,0> translate <0,.5,1.8> }
  object { Strut rotate <90,0,0> translate <0,.5,1.8> }
  object { Strut rotate <135,0,0> translate <0,.5,1.8> }
  object { Disk_X scale <.58,.15,.15> translate <0,.5,1.8> }
  object { Stop scale <.75,.75,.75> rotate <0,0,-90> translate <.58,.5,1.8> }
  object { Stop scale <.75,.75,.75> rotate <0,0,90> translate <-.58,.5,1.8> }
  texture {DGold}
  translate <0,-1.01,.6>
}

difference {
  object { plane {y,-2.05} }
  object { Disk_Z scale <.05,.05,100> translate <-.95,-2.05,100> }
  object { Disk_Z scale <.05,.05,100> translate <.95,-2.05,100> }
  object { Foot translate <0,-2.05,3.65> }
  object { Foot translate <0,-2.05,4.9> }
  object { Foot translate <0,-2.05,6.15> }
  object { Foot translate <0,-2.05,7.4> }
  object { Foot translate <0,-2.05,8.65> }
  object { Foot translate <0,-2.05,9.90> }
  object { Foot translate <0,-2.05,11.15> }
  object { Foot translate <0,-2.05,12.40> }
  object { Foot translate <0,-2.05,13.65> }
  object { Foot translate <0,-2.05,14.9> }
  texture { pigment {NewTan} } 
}

object { Mnt 
  scale <40,20,40>
  rotate <0,-125,0>
  translate <0,-2.45,0>
}

object { Mnt
  scale <2,2,2>
  translate <1.05,-2.07,1.5>
}

object { Sphere
  pigment { image_map {gif "gc.gif" map_type 1}
    translate <-.5,-.5,0>
  }
  finish { ambient 1 }
  scale <100,100,100>
  translate <0,150,300>
  rotate <0,-55,0>
}

object { Sphere
  pigment { image_map {gif "fract010.gif" }
    translate <-.5,-.5,0>
  }
  finish { Luminous }
  scale <5000,5000,5000>
}
