// INDY.INC - This is the object include file for the Red car body
//
// By Neil Clark

// Car Body

#declare Master = object  {
  Ellipsoid
    texture
      {
        pigment { color Red }
        finish {
          Shiny
          diffuse 0.4
          reflection 0.35
        }
     }
  }

#declare car_body = union
{
   object { Master  scale <5, .6, 1.8> translate <0, -0.5, 0> }
   object { Master  scale <4, .4, 1.5> translate <0, -0.2, 0> }
   object { Master  scale <3, .5, 1>
      translate <0, -0.1, 0>
      clipped_by { box { <-5, -2, -2>, <0, 1, 2> }}}
   object { Ellipsoid scale <2, .2, .8> translate <0, 0.1, 0>
     texture { Silver_Texture finish { Shiny } }
    }
  object // tail fin (right)
    { box { <-4.0, -0.5, -1>, <-3.5, .5, -.9> }
      texture { pigment { color Red }
        finish {
          Shiny
          diffuse 0.5
          reflection 0.35
         }
       }
    }
  object // tail fin (left)
    { box { <-4.0, -0.5, .9>, <-3.5, .5, 1> }
     texture { pigment { color Red }
        finish {
          Shiny
          diffuse 0.5
          reflection 0.35
         }
       }
    }
  object // tail fin (top)
    { box { <-4.0, 0.5, -2.5>, <-3.5, 0.6, 2.5> }
     texture { pigment { color Red }
        finish {
          Shiny
          diffuse 0.5
          reflection 0.35
        }
      }
    }
  }
