// LEGOS.INC - Lego (TM) Shapes file for POV-Ray v2.0
// By Neil Clark
//
// Single Lego Dots - Round

#declare Single_White = union {
  cylinder { <0, 0, 0>, <0, 1.0,   0>, 0.5 }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Single_Yellow = union {
  cylinder { <0, 0, 0>, <0, 1,   0>, 0.5 }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Single_Red = union {
  cylinder { <0, 0, 0>, <0, 1,   0>, 0.5 }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Single_Blue = union {
  cylinder { <0, 0, 0>, <0, 1,   0>, 0.5 }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }


// Single Lego Dots - Square

#declare Square_White = union {
  box { <-0.5, 0, -0.5>, <0.5, 1, 0.5> }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Square_Yellow = union {
  box { <-0.5, 0, -0.5>, <0.5, 1, 0.5> }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Square_Red = union {
  box { <-0.5, 0, -0.5>, <0.5, 1, 0.5> }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

#declare Square_Blue = union {
  box { <-0.5, 0, -0.5>, <0.5, 1, 0.5> }
  cylinder { <0, 1, 0>, <0, 1.2, 0>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <-0.5, 0, -0.5>, <0.5, 1.2, 0.5> }}
  }

// Two Lego Dots

#declare Two_Red = union {
  box { <0, 0, 0>, <2, 1, 1> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 1> }}
  }

#declare Two_Yellow = union {
  box { <0, 0, 0>, <2, 1, 1> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 1> }}
  }

#declare Two_White = union {
  box { <0, 0, 0>, <2, 1, 1> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 1> }}
  }

#declare Two_Blue = union {
  box { <0, 0, 0>, <2, 1, 1> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 1> }}
  }

// Four Lego Dots

#declare Four_Blue = union {
  box { <0, 0, 0>, <2, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 2> }}
  }

#declare Four_White = union {
  box { <0, 0, 0>, <2, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 2> }}
  }

#declare Four_Red = union {
  box { <0, 0, 0>, <2, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 2> }}
  }

#declare Four_Yellow = union {
  box { <0, 0, 0>, <2, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <2, 1.2, 2> }}
  }

// Six Lego Dots

#declare Six_Yellow = union {
  box { <0, 0, 0>, <3, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <3, 1.2, 2> }}
  }

#declare Six_Red = union {
  box { <0, 0, 0>, <3, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <3, 1.2, 2> }}
  }

#declare Six_Blue = union {
  box { <0, 0, 0>, <3, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <3, 1.2, 2> }}
  }

#declare Six_White = union {
  box { <0, 0, 0>, <3, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <3, 1.2, 2> }}
  }

// Eight Lego Dots

#declare Eight_Yellow = union {
  box { <0, 0, 0>, <4, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <4, 1.2, 2> }}
  }

#declare Eight_Red = union {
  box { <0, 0, 0>, <4, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <4, 1.2, 2> }}
  }

#declare Eight_Blue = union {
  box { <0, 0, 0>, <4, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <4, 1.2, 2> }}
  }

#declare Eight_White = union {
  box { <0, 0, 0>, <4, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <4, 1.2, 2> }}
  }

// Twelve Lego Dots

#declare Twelve_Red = union {
  box { <0, 0, 0>, <6, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <4.5, 1, 0.5>, <4.5, 1.2, 0.5>, 0.3 }
  cylinder { <5.5, 1, 0.5>, <5.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  cylinder { <4.5, 1, 1.5>, <4.5, 1.2, 1.5>, 0.3 }
  cylinder { <5.5, 1, 1.5>, <5.5, 1.2, 1.5>, 0.3 }
  pigment { color Red }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <6, 1.2, 2> }}
  }

#declare Twelve_Yellow = union {
  box { <0, 0, 0>, <6, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <4.5, 1, 0.5>, <4.5, 1.2, 0.5>, 0.3 }
  cylinder { <5.5, 1, 0.5>, <5.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  cylinder { <4.5, 1, 1.5>, <4.5, 1.2, 1.5>, 0.3 }
  cylinder { <5.5, 1, 1.5>, <5.5, 1.2, 1.5>, 0.3 }
  pigment { color Yellow }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <6, 1.2, 2> }}
  }

#declare Twelve_Blue = union {
  box { <0, 0, 0>, <6, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <4.5, 1, 0.5>, <4.5, 1.2, 0.5>, 0.3 }
  cylinder { <5.5, 1, 0.5>, <5.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  cylinder { <4.5, 1, 1.5>, <4.5, 1.2, 1.5>, 0.3 }
  cylinder { <5.5, 1, 1.5>, <5.5, 1.2, 1.5>, 0.3 }
  pigment { color Blue }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <6, 1.2, 2> }}
  }

#declare Twelve_White = union {
  box { <0, 0, 0>, <6, 1, 2> }
  cylinder { <0.5, 1, 0.5>, <0.5, 1.2, 0.5>, 0.3 }
  cylinder { <1.5, 1, 0.5>, <1.5, 1.2, 0.5>, 0.3 }
  cylinder { <2.5, 1, 0.5>, <2.5, 1.2, 0.5>, 0.3 }
  cylinder { <3.5, 1, 0.5>, <3.5, 1.2, 0.5>, 0.3 }
  cylinder { <4.5, 1, 0.5>, <4.5, 1.2, 0.5>, 0.3 }
  cylinder { <5.5, 1, 0.5>, <5.5, 1.2, 0.5>, 0.3 }
  cylinder { <0.5, 1, 1.5>, <0.5, 1.2, 1.5>, 0.3 }
  cylinder { <1.5, 1, 1.5>, <1.5, 1.2, 1.5>, 0.3 }
  cylinder { <2.5, 1, 1.5>, <2.5, 1.2, 1.5>, 0.3 }
  cylinder { <3.5, 1, 1.5>, <3.5, 1.2, 1.5>, 0.3 }
  cylinder { <4.5, 1, 1.5>, <4.5, 1.2, 1.5>, 0.3 }
  cylinder { <5.5, 1, 1.5>, <5.5, 1.2, 1.5>, 0.3 }
  pigment { color White }
  finish { reflection 0.2 ambient 0.2 }
  bounded_by { box { <0, 0, 0>, <6, 1.2, 2> }}
  }


