// TOYBOX.INC - The Toybox in TOYS.POV
//
// By Neil Clark

// Letters on front
#include "t_char.inc"
#include "o_char.inc"
#include "y_char.inc"
#include "b_char.inc"
#include "x_char.inc"

#declare rough_box = union
 {
  // Letter T
  object { T_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <-17, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // Letter o
  object { O_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <-12, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // Letter y
  object { Y_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <-7, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // Letter B
  object { B_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <1, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // Letter o
  object { O_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <8, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // Letter x
  object { X_Char
    scale <9, 9, 1>
    rotate <0, 0, 0>
    translate <13, -3.5, -1.1>
    texture { Brass_Texture }
  }
  // back
  box { <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 10.0, 1.0>
    translate <0.0, 0.0, 18.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
  // front
  box { <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 10.0, 1.0>
    translate <0.0, 0.0, 0.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
  // Right end
  box { <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 8.0>
    translate <29.0, 0.0, 9.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
  // left end
  box { <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 10.0, 8.0>
    translate <-29.0, 0.0, 9.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
  // Bottom
  box { <-1, -1, -1>, <1, 1, 1>
    scale <28.0, 1.0, 8.0>
    translate <0.0, -9.0, 9.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
  // Lid
  box { <-1, 0, -1>, <1, 1, 1>
    scale <30.0, 1.0, 10.0>
    rotate <31, 0.0, 0.0>
    translate <0.0, 15, 11.0>
    texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
  }
}

#declare rail1 = object {
   box { < -1, -2, -1 >, < 1, 1, 1 > }
   scale <30.0, 1, 1>
   texture {EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
   }

#declare front_rail = difference {
  object { rail1 }
  object { Disk_Z scale <1.5,1.2,3> translate <-26,-2,0> }
  object { Disk_Z scale <1.5,1.2,3> translate <26,-2,0> }
  object { box { < -1, -3, -1.1 >, < 1, 1, 1.1 > }
     scale <26, 1, 1>
     translate <0,-1.7,0>
  }
  texture { EMBWood1 scale <0.33,23,0.23> rotate <0,0,90> }
}

#declare toy_box = union {
  object { rough_box }
  object { front_rail translate <0,-11,0> }
  object { front_rail translate <0,-11,18> }
  object { front_rail scale <0.3,1,1> rotate <0,90,0> translate <-29,-11,9> }
  object { front_rail scale <0.3,1,1> rotate <0,90,0> translate <29,-11,9> }
  }

