
// Mountain.tga creator script. SjG 1995.
// This creates fairly jagged peaks with nice valleys.
//
// For good results, render into something like a 500x200 rectangle.
//
#include "colors.inc"

camera {
  location  <0, 0, -50>
  direction <0, 0, 1>
  up        <0, 1, 0>
  right     <1, 0, 0>
  look_at   <0, 0, 0>
}

light_source {<-10,0,-30>
              color Gray50
              spotlight
              point_at <-10,0,0>
              radius 10
              falloff 15
              tightness 1 }

light_source {<0,0,-30>
              color Gray50
              spotlight
              point_at <0,0,0>
              radius 10
              falloff 12
              tightness 1 }

light_source {<10,0,-30>
              color Gray50
              spotlight
              point_at <10,0,0>
              radius 10
              falloff 15
              tightness 1 }

light_source {<20,0,-30>
              color Gray50
              spotlight
              point_at <10,0,0>
              radius 10
              falloff 15
              tightness 1 }

plane { z, 0
  pigment {
    marble
	turbulence 0.4 // 0.3
	color_map {
	   [0,    0.2 color Black color Gray30]
	   [0.2,  0.85 color Gray30 color Gray70]
	   [0.85, 1.001 color Gray70 color White]
	}
	scale <16,5,1>
	rotate <0,0,-36>
  }
}
