// Persistence Of Vision Raytracer version 2.0
/*
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
Image:		sjgtoys5

Background:	Entry for the January Internet Raytrace Competition

Render time: 	800x600 with 0.3 anti-aliasing:
		17 hours 27 minutes using POV 2.2 under Solaris 2.x
		on a 2-headed Sun SPARC 10 with 128 Meg of memory.

Legal:		Created by Samuel J. Goldstein.
		This file is Copyright (C) 1995. All rights reserved. You may
		use this source file to create the scene or use the components
		in your own scenes, with or without modifications, freely
		for NON-COMMERCIAL purposes. Please send me a copy of any
		scene (other than the original) that incorporates any
		significant part of this file.

		Commercial users please contact me for terms of use or
		information about my art services.

		I can be reached at:
		4227 Sunnyside Ave, Los Angeles, CA 90066-5609
		310-822-5426
		goldstein@aerospace.aero.org

=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
*/

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// The following definitions are snarfed from STONES.INC
#declare Grnt6 =
texture {
pigment
 {granite
  turbulence 0.5
  color_map
   {[0.000, 0.153   color rgbf <0.545, 0.380, 0.345, 0.000>
                    color rgbf <0.588, 0.475, 0.333, 0.000>]
    [0.153, 0.398   color rgbf <0.588, 0.475, 0.333, 0.000>
                    color rgbf <0.675, 0.478, 0.404, 0.000>]
    [0.398, 0.559   color rgbf <0.675, 0.478, 0.404, 0.000>
                    color rgbf <0.757, 0.635, 0.522, 0.000>]
    [0.559, 0.729   color rgbf <0.757, 0.635, 0.522, 0.000>
                    color rgbf <0.659, 0.549, 0.443, 0.000>]
    [0.729, 1.001   color rgbf <0.659, 0.549, 0.443, 0.000>
                    color rgbf <0.545, 0.380, 0.345, 0.000>]
   }
 }
 }

#declare Grnt12 =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.154   color rgbf <0.996, 0.969, 0.800, 0.000>
                    color rgbf <0.996, 0.682, 0.604, 0.000>]
    [0.154, 0.308   color rgbf <0.996, 0.682, 0.604, 0.000>
                    color rgbf <0.906, 0.820, 0.714, 0.000>]
    [0.308, 0.444   color rgbf <0.906, 0.820, 0.714, 0.000>
                    color rgbf <0.816, 0.631, 0.537, 0.000>]
    [0.444, 0.615   color rgbf <0.816, 0.631, 0.537, 0.000>
                    color rgbf <0.890, 0.792, 0.675, 0.000>]
    [0.615, 0.812   color rgbf <0.890, 0.792, 0.675, 0.000>
                    color rgbf <0.973, 0.627, 0.627, 0.000>]
    [0.812, 1.001   color rgbf <0.973, 0.627, 0.627, 0.000>
                    color rgbf <0.996, 0.969, 0.800, 0.000>]
   }
 }
 }

#declare Grnt10a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.179   color rgbf <0.843, 0.655, 0.655, 0.455>
                    color rgbf <0.886, 0.769, 0.627, 0.608>]
    [0.179, 0.368   color rgbf <0.886, 0.769, 0.627, 0.608>
                    color rgbf <0.906, 0.820, 0.714, 0.392>]
    [0.368, 0.538   color rgbf <0.906, 0.820, 0.714, 0.392>
                    color rgbf <0.851, 0.671, 0.671, 0.659>]
    [0.538, 0.744   color rgbf <0.851, 0.671, 0.671, 0.659>
                    color rgbf <0.890, 0.792, 0.675, 0.392>]
    [0.744, 0.983   color rgbf <0.890, 0.792, 0.675, 0.392>
                    color rgbf <0.827, 0.612, 0.612, 0.706>]
    [0.983, 1.001   color rgbf <0.827, 0.612, 0.612, 0.706>
                    color rgbf <0.843, 0.655, 0.655, 0.455>]
   }
 }
 }

#declare Grnt17a =
texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.034   color rgbf <0.027, 0.012, 0.012, 0.000>
                    color rgbf <0.851, 0.812, 0.741, 0.235>]
    [0.034, 0.342   color rgbf <0.851, 0.812, 0.741, 0.235>
                    color rgbf <0.792, 0.694, 0.690, 0.839>]
    [0.342, 0.462   color rgbf <0.792, 0.694, 0.690, 0.839>
                    color rgbf <0.631, 0.506, 0.471, 0.608>]
    [0.462, 0.632   color rgbf <0.631, 0.506, 0.471, 0.608>
                    color rgbf <0.851, 0.812, 0.741, 0.922>]
    [0.632, 0.983   color rgbf <0.851, 0.812, 0.741, 0.922>
                    color rgbf <0.647, 0.655, 0.655, 0.282>]
    [0.983, 1.001   color rgbf <0.647, 0.655, 0.655, 0.282>
                    color rgbf <0.027, 0.012, 0.012, 0.000>]
   }
 }
 }

#declare Crack1 =
texture {
pigment
 {marble
  turbulence 0.85
  color_map
   {[0.0, 0.04 color Black filter 0.6 color Black filter 1.0]
    [0.04, 0.97 color Scarlet filter 0.80 color DimGray filter 0.90]
    [0.97, 1.001 color Black filter 0.9 color Black filter 1.0]
   }
 }
 }

#declare Stone4 =
texture{Grnt6   scale <1.5, 3, 2> rotate <0, 0, 40>
        finish{diffuse 0.5}
}
texture{Grnt10a scale <1, 3, 2> rotate <0, 0, -30>
        finish{phong 1.0 phong_size 90}
}

//------------- White Cream Marble with Pink veining
#declare Stone5 =
texture{Grnt12  scale <2, 3, 2> rotate <0, 0, 40>}
texture{Grnt17a scale <2, 3, 2> rotate <0, 0, -30>}
texture{Crack1  scale <1, 2, 1.4> rotate <10, 0, -20>
        finish{phong 1.0 phong_size 90 ambient 0.2}}

// end of STONES definitions.

#declare straight_in_view2 =
camera {
   location  <-15, 100, -275>
   direction <0, 0,  1>
   look_at   <0, 95,   0>
}


#declare SkyCam =
camera {
   location  <1, 300, 1>
   direction <0, -1,  0>
   look_at   <0, 100,   0>
}

#declare TreeCam =
camera {
   location  <0, 10, -60>
   direction <0, 0,  1>
   look_at   <10, 12,   0>
}


camera { TreeCam }

// light
light_source { <84, 323, -200> color White}

// Texture for the dotted line on the road
#declare Stripes = texture {
		pigment {checker color Yellow color Clear}
		scale <5000,10,5>
		translate <2500,0,0>
		}

// A curving stretch o' highway
#declare road= merge {
	cylinder{<0,0,0>,<0,0,200>,1 scale <1.1,0.1,1>
		translate <0,1,0> texture {Stripes}}
	cylinder{<0,0,0>,<0,0,200>,20 scale <1,0.05,1>}
	intersection {
		torus {80,20 sturm}
		plane {-z,0}
		plane {z,0 rotate <0,-45,0>}
		scale <1,0.05,1>
		translate <-80,0,200>
	}
	intersection {
		torus {80,1 sturm}
		plane {-z,0}
		plane {z,0 rotate <0,-45,0>}
		scale <1,0.2,1>
		translate <-80,1,200>
		texture {pigment {Yellow}}
	}
	cylinder{<0,0,0>,<0,0,400>,20 scale <1,0.05,1>
		rotate <0,-45,0> translate <-23.43,0,256.57>}
	cylinder{<0,1,0>,<0,1,400>,1 scale <1,0.8,1>
		rotate <0,-45,0> translate <-23.43,0,256.57> texture {Stripes}}
	texture {
		finish {crand 0.2}
		normal {dents 0.3}
		pigment {Gray10}
		}
	}

// Sky Sphere
sphere {<0,0,0>,2000 inverse
	texture {
		finish {ambient 1
			diffuse 0
			}
		pigment {
		  gradient y
		  color_map {
		     [0.0 1.0 color White color SkyBlue]
		  }
		scale <1,2000,1>
		}
	}
}

// Clouds
plane {y,500
	rotate <8,0,0>
        texture {
	   finish {
		ambient 0.55
	   }
           pigment{
               bozo
		//agate_turb 0.5
		turbulence 0.9
               color_map {
                    [ 0, .6  color Clear
				color Clear]
		    [.6, 0.8 color Clear
			     color red 0.8 green 0.8 blue 0.8 filter 0.8]
                    [.8,  1.001  color red 0.8 green 0.8 blue 0.8 filter 0.8
			      color red 0.95 green 0.95 blue 0.95 filter 0.25]
                    }
               }
	     scale <300,20,200>
	     rotate <0,-30,0>
           }
}


// Put some mountains in the distance (but not actually as far as they look)

height_field {tga "mountrng1.tga"
   translate <-0.5,0,0>
   scale <1000,100,100>
   translate <0,-30,200>
   texture {Stone4 scale <10,10,10>}
}

height_field {tga "mountrng2.tga"
   translate <-0.5,0,0>
   scale <2000,200,100>
   translate <0,-30,750>
   texture {Stone5 scale <10,10,10>}
}


// Toss in the ground
plane {y,-10 texture {Stone4 normal{ripples 0.3 scale <10,3,10>}
			 scale <10,10,10>}}

// Sprinkle with patches of melting snow
plane {y,-8.5
	no_shadow
        texture {
	   finish {
		ambient 0.55
	   }
	   normal {
		ripples 0.4
	   }
           pigment{
               bozo
               color_map {
                    [ 0, .75  color Clear color Clear]
		    [.75, 0.8 color Clear color White]
                    [.8,  1.001 color White color White]
                    }
               }
	     scale <10,20,10>
	     rotate <0,-30,0>
           }
	rotate <0,-12,0>
	translate <16,0,0>
}

// Pave that pup!
object {road rotate <0,-10,0> translate <50,-9.9,-100> }

// Plant some leafless trees

merge {
#include "treedat13.pov"
translate <-63,-13,100>
texture {Tan_Wood}
}

merge {
#include "treedat14.pov"
translate <-40,-13,73>
texture {Tan_Wood}
}

merge {
#include "treedat15.pov"
translate <-20,-13,112>
texture {Tan_Wood}
}

merge {
#include "treedat16.pov"
translate <83,-13,78>
texture {Tan_Wood}
}

merge {
#include "treedat17.pov"
translate <105,-13,90>
texture {Tan_Wood}
}

merge {
#include "treedat18.pov"
translate <115,-13,75>
texture {Tan_Wood}
}

// FINALLY, we put in the Toy!

#include "trike.pov"
object {turntrike rotate <0,-98,0> scale <0.20, 0.20, 0.20>
	translate <20,-1,0>}

// And we're done!

