#include "colors.inc"
#include "textures.inc"
#include "gtextur.inc"
#include "printer.inc"
#include "cutter.inc"
#include "others.inc"

camera {
	location <-1.8, 0.7, -1.8>
	up       <0, 1, 0>
	right    <4/3, 0, 0 >
	look_at  <-0.5, 0.65, 0>
}

light_source {
	< -2 , 3 , -2 >
	color rgb <1, 1, 1>
	spotlight
	point_at <1.5, 0, 3>
	tightness 1
	radius 30
	falloff 40
}

light_source {
	< -2 , 3 , -2 >
	color rgb <0.4, 0.4, 0.4>
	spotlight
	point_at <1.5, 0, 3>
	tightness 1
	radius 30
	falloff 40
}

object {Table}

object {
	Wall
	rotate y*90
	translate x*5
}
object {
	Wall
	translate z*8
}

object {
	plane {z, -4}
	pigment {color rgb <1, 1, 1>}
	finish  {ambient 0.8 phong 0}
}

object {
	plane {x, -4}
	pigment {color rgb <1, 1, 1>}
	finish  {ambient 0.8 phong 0}
}

object {			//ceiling
	plane {-y, -6.4}
	pigment {color rgb <1, 1, 1>}
	finish  {ambient 0.8 phong 0}
}

object {Printer}
object {Cutter}
object {Vessel translate <0.7, 0, 6>}
object {Back rotate y*70 translate <-0.7, 0, 0>}
object {Face rotate y*200 translate <-0.2, 0, -0.1>}
object {Face rotate y*40 translate <-2.2, 0, 1>}
object {Back rotate y*10 translate <0.3, 0, -0.7>}
object {Bar rotate y*45 translate <-0.1, 0, -0.6>}
object {Bar rotate y*92 translate <-0.6, 0, 0.4>}
object {Bar rotate -y*20 translate <-0.2, 0, -0.65>}
object {Bar scale <0.6, 1, 1> rotate -y*10 translate <-1.7, 0, 0.1>}
object {Bar scale <1. 1, 0.8> rotate y*70 translate <-1.8, 0.001, 1.1>}
object {Tube}
object {M_glass}




