/*
	Grenade.pov

	The (infamous) Holy Hand Grenade

	This is probably stretching the category.

	The faceted gems were created with Andy Wardley's
	Geodome v1.1.

	Three shall be the number of the counting

	Russ Jones
	rjones@southwind.net

*/

#include "colors.inc"
#include "textures.inc"
#declare FT = 12.5

#include "gem1.inc"
#include "gem3.inc"
#declare Stone_Finish =
finish
{
  ambient 0.1
  diffuse 0.1
  specular 0.8
  reflection 0.1
  refraction 0.9
  ior 1.45
  roughness 0.0003
  phong 1
  phong_size 400
}

#declare My_Stone =
texture
{
  finish
  {
    Stone_Finish
  }
  pigment
  {
    Jade
  }
}

#declare My_Gold =
texture
{
  pigment { BrightGold }
  finish
  {
    ambient 0.1
    diffuse 0.7
    brilliance 6.0
    reflection 0.6
    phong 8
    phong_size 120
  }
}

sphere
{
  <0, 0, 0> 5.0
  texture
  {
    My_Stone
  }
}

#declare Quarter =
union
{
  difference
  {
    torus
    {
    5, 0.15
    }
    box
    {
      <-6, -1, -1>
      <6, 1, 6>
    }
    box
    {
      <-6, -1, -6>
      <1, 1, 6>
    }
  }
  sphere
  {
    <0, 0, -5>
    0.15
    rotate <0, -11.3099, 0>
  }
  sphere
  {
    <5, 0, 0>
    0.15
    rotate <0, 11.3099, 0>
  }
  bounded_by
  {
    box
    {
      <0, -0.2, -6>
      <6,  0.2, 0>
    }
  }
  texture { My_Gold }
}

object
{
  Quarter
  translate <0, 1, 0>
  rotate <0, 0, 0>
}
object
{
  Quarter
  translate <0, 1, 0>
  rotate <0, 90, 0>
}
object
{
  Quarter
  translate <0, 1, 0>
  rotate <0, 180, 0>
}
object
{
  Quarter
  translate <0, 1, 0>
  rotate <0, 270, 0>
}
object
{
  Quarter
  rotate <0, 0, 90>
  translate <1, 0, 0>
}
object
{
  Quarter
  rotate <0, 0, 90>
  translate <-1, 0, 0>
}
object
{
  Quarter
  rotate <0, 180, -90>
  translate <-1, 0, 0>
}
object
{
  Quarter
  rotate <0, 180, -90>
  translate <1, 0, 0>
}
object
{
  Quarter
  rotate <90, 0, 0>
  translate <0, 0, -1>
}
object
{
  Quarter
  rotate <90, 0, 0>
  translate <0, 0, 1>
}
object
{
  Quarter
  rotate <90, 180, 0>
  translate <0, 0, -1>
}
object
{
  Quarter
  rotate <90, 180, 0>
  translate <0, 0, 1>
}

torus
{
  5, 0.15
  translate <0, -1, 0>
  bounded_by
  {
    box
    {
      <-6, -1, -6>
      <6, 1, 6>
    }
  }
  texture { My_Gold }
}

sphere
{
  <0, 0, 0>
  5.15
  clipped_by
  {
    cylinder
    {
      <0, -1, 0>
      <0, 1, 0>
      5.5
    }
  }
  texture { My_Gold }
}

sphere
{
  <0, 0, 0>
  5.15
  clipped_by
  {
    difference
    {
      cylinder
      {
	< -1, 0, 0>
	<  1, 0, 0>
	5.5
      }
      box
      {
	<-5.5, -5.5, -5.5>
	<5.5, 1, 5.5>
      }
    }
  }
  texture { My_Gold }
}
sphere
{
  <0, 0, 0>
  5.15
  clipped_by
  {
    difference
    {
      cylinder
      {
	< -1, 0, 0>
	<  1, 0, 0>
	5.5
      }
      box
      {
	<-5.5, -5.5, -5.5>
	<5.5, 1, 5.5>
      }
    }
  }
  rotate <0, 90, 0>
  texture { My_Gold }
}


#declare Big_Gem =
union
{
  object
  {
    gem1
    scale <1, 1, 0.75>
  }
  torus
  {
    0.9, 0.1
    scale < 1, 2.5, 1>
    rotate <90, 0, 0>
    texture {My_Gold}
  }
  torus
  {
    1.0, 0.07
    scale <1, 1.5, 1>
    rotate <90, 0, 0>
    texture {My_Gold}
  }
  texture
  {
    pigment
    {
      color Black 
    }
    finish 
    {
      ambient 0.4
      diffuse 0.1
      specular 0.8
      reflection 0.8
      refraction 0.7
      ior 2.47
      roughness 0.0003
      phong 1 phong_size 400
    }
  }
  scale <1.2, 1.2, 1.2>
  translate <0, 0, -5>
}

object {Big_Gem pigment { color Green    filter 0.5 } rotate <0,   0, 0>}
object {Big_Gem pigment { color Yellow   filter 0.2 } rotate <0,  90, 0>}
object {Big_Gem pigment { color Orange   filter 0.5 } rotate <0, -90, 0>}

#declare Ray =
cylinder
{
  <0, -2, 0>
  <0,  2, 0>
  0.02
}

#declare Corona =
union
{
  object {Ray scale <1, 1.077, 1> rotate <0, 0, 000.0>}
  object {Ray scale <1, 1.042, 1> rotate <0, 0, 003.6>}
  object {Ray scale <1, 1.034, 1> rotate <0, 0, 007.2>}
  object {Ray scale <1, 1.007, 1> rotate <0, 0, 010.8>}
  object {Ray scale <1, 1.022, 1> rotate <0, 0, 014.4>}
  object {Ray scale <1, 1.069, 1> rotate <0, 0, 018.0>}
  object {Ray scale <1, 1.017, 1> rotate <0, 0, 021.6>}
  object {Ray scale <1, 1.054, 1> rotate <0, 0, 025.2>}
  object {Ray scale <1, 1.071, 1> rotate <0, 0, 028.8>}
  object {Ray scale <1, 1.025, 1> rotate <0, 0, 032.4>}
  object {Ray scale <1, 1.079, 1> rotate <0, 0, 036.0>}
  object {Ray scale <1, 1.050, 1> rotate <0, 0, 039.6>}
  object {Ray scale <1, 1.057, 1> rotate <0, 0, 043.2>}
  object {Ray scale <1, 1.079, 1> rotate <0, 0, 046.8>}
  object {Ray scale <1, 1.050, 1> rotate <0, 0, 050.4>}
  object {Ray scale <1, 1.059, 1> rotate <0, 0, 054.0>}
  object {Ray scale <1, 1.086, 1> rotate <0, 0, 057.6>}
  object {Ray scale <1, 1.071, 1> rotate <0, 0, 061.2>}
  object {Ray scale <1, 1.025, 1> rotate <0, 0, 064.8>}
  object {Ray scale <1, 1.080, 1> rotate <0, 0, 068.4>}
  object {Ray scale <1, 1.054, 1> rotate <0, 0, 072.0>}
  object {Ray scale <1, 1.070, 1> rotate <0, 0, 075.6>}
  object {Ray scale <1, 1.021, 1> rotate <0, 0, 079.2>}
  object {Ray scale <1, 1.067, 1> rotate <0, 0, 082.8>}
  object {Ray scale <1, 1.009, 1> rotate <0, 0, 086.4>}
  object {Ray scale <1, 1.030, 1> rotate <0, 0, 090.0>}
  object {Ray scale <1, 1.094, 1> rotate <0, 0, 093.6>}
  object {Ray scale <1, 1.094, 1> rotate <0, 0, 097.2>}
  object {Ray scale <1, 1.096, 1> rotate <0, 0, 100.8>}
  object {Ray scale <1, 1.004, 1> rotate <0, 0, 104.4>}
  object {Ray scale <1, 1.012, 1> rotate <0, 0, 108.0>}
  object {Ray scale <1, 1.039, 1> rotate <0, 0, 111.6>}
  object {Ray scale <1, 1.025, 1> rotate <0, 0, 115.2>}
  object {Ray scale <1, 1.079, 1> rotate <0, 0, 118.8>}
  object {Ray scale <1, 1.049, 1> rotate <0, 0, 122.4>}
  object {Ray scale <1, 1.016, 1> rotate <0, 0, 126.0>}
  object {Ray scale <1, 1.049, 1> rotate <0, 0, 129.6>}
  object {Ray scale <1, 1.056, 1> rotate <0, 0, 133.2>}
  object {Ray scale <1, 1.077, 1> rotate <0, 0, 136.8>}
  object {Ray scale <1, 1.043, 1> rotate <0, 0, 140.4>}
  object {Ray scale <1, 1.036, 1> rotate <0, 0, 144.0>}
  object {Ray scale <1, 1.013, 1> rotate <0, 0, 147.6>}
  object {Ray scale <1, 1.042, 1> rotate <0, 0, 151.2>}
  object {Ray scale <1, 1.034, 1> rotate <0, 0, 154.8>}
  object {Ray scale <1, 1.008, 1> rotate <0, 0, 158.4>}
  object {Ray scale <1, 1.025, 1> rotate <0, 0, 162.0>}
  object {Ray scale <1, 1.081, 1> rotate <0, 0, 165.6>}
  object {Ray scale <1, 1.053, 1> rotate <0, 0, 169.2>}
  object {Ray scale <1, 1.067, 1> rotate <0, 0, 172.8>}
  object {Ray scale <1, 1.012, 1> rotate <0, 0, 176.4>}
}

#declare Cross =
union
{
  object
  {
    gem3
    texture
    {
      Glass3
    }
  }
  torus
  {
    0.4, 0.1
    translate <0, 0.9, 0>
  }
  torus
  {
    0.4, 0.1
    translate <0, -0.9, 0>
  }
  cylinder
  {
    <0, 1, 0>
    <0, 1.05, 0>
    0.4
  }
  cylinder
  {
    <0, -1, 0>
    <0, -1.05, 0>
    0.4
  }
  cylinder
  {
    <0, 1.05, 0>
    <0, 1.1, 0>
    0.35
  }
  cylinder
  {
    <0, -1.05, 0>
    <0, -1.1, 0>
    0.35
  }
  cylinder
  {
    <0, 1.1, 0>
    <0, 1.15, 0>
    0.3
  }
  cylinder
  {
    <0, -1.1, 0>
    <0, -1.15, 0>
    0.3
  }
  cone
  {
    < 0, -1.15, 0> 0.3
    < 0, -1.4, 0> 0.5
  }
  torus
  {
    0.5, 0.15
    translate <0, -1.55, 0>
  }
  cylinder
  {
    <0, 1.15, 0>
    <0, 1.4, 0>
    0.3
    texture { My_Stone }
  }
  cylinder
  {
    <0, 1.4, 0>
    <0, 1.5, 0>
    0.3
  }
  sphere
  {
    <0, 1.5, 0> 0.3
  }
  cylinder
  {
    <0, 1.5, 0>
    <0, 4.0, 0>
    0.2
    scale <1, 1, 0.2>
  }
  cylinder
  {
    <-0.9, 3.1, 0>
    < 0.9, 3.1, 0>
    0.2
    scale <1, 1, 0.2>
  }
  object
  {
    Corona
    translate <0, 3.1, 0>
  }
  texture {My_Gold}
  translate <0, 6.8, 0>
}

object { Cross }

#declare Small_Gem =
union
{
  sphere
  {
    <0, 0, 0>
    1
  }
  torus
  {
    0.95, 0.1
    scale <1, 2.5, 1>
    rotate <90, 0, 0>
    texture { My_Gold }
  }
  bounded_by { sphere { <0, 0, 0> 1.2}}
  scale <0.8, 0.8, 0.6>
  translate <0, 0, -5.15>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      Blue_Agate
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <0, -30, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      marble
      turbulence 1.8
      color_map
      {
	[0.0, 0.8	color red 0.9 green 0.1 blue 0.1
			color red 0.5 green 0.0]
	[0.8, 1.001	color red 0.9 green 0.1 blue 0.1
			color red 0.4 green 0.0]
      }
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <0, -60, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      granite
      color_map
      {
	[0.0, 0.3 color Feldspar color Feldspar]
	[0.3, 0.6 color Mica color Quartz]
	[0.6, 1.001 color Feldspar color Quartz]
      }
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <0, 30, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      Bright_Blue_Sky
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <0, 60, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      marble
      turbulence 0.5
      color_map
      {
	[0.0, 0.1	color red 0.9 green 0.2 blue 0.1
		  	color red 0.7 green 0.0 blue 0.15]
        [0.1, 0.95	color red 0.9 green 0.0 blue 0.1
			color red 0.85 green 0.0 blue 0.1]
	[0.95, 1.001	color Green
			color Yellow]
      }
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <30, 0, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      marble
      turbulence 0.45
      color_map
      {
	[0.0, 0.95	color Black
			color Gray25]
	[0.95, 1.001	color White color White ]
      }
    }
    finish
    {
      Stone_Finish
    }
    translate <0.3, 0.22, 0.19>
  }
  rotate <60, 0, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      agate
      turbulence 0.65
      color_map
      {
	[0.0, 0.95	color Green
		  	color Yellow ]
	[0.95, 1.001	color Red
			color Red]
      }
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <30, 90, 0>
}

object
{
  Small_Gem
  texture
  {
    Sandalwood
    finish
    {
      Stone_Finish
    }
    scale <2.5, 2.5, 2.5>
  }
  rotate <60, 90, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      Brown_Agate
    }
    finish
    {
      Stone_Finish
    }
  }
  rotate <30, -90, 0>
}

object
{
  Small_Gem
  texture
  {
    pigment
    {
      Blood_Sky
    }
    finish
    {
      Stone_Finish
    }
    rotate <22, 15, -44>
  }
  rotate <60, -90, 0>
}

#declare My_Wood =
texture
{
  Rosewood
  finish
  {
    Phong_Glossy
  }
  translate <0, 10, 0>
}

union
{
  box
  {
    <-6.5, -6, -6.5>
    < 6.5,  -2, -6>
    texture { My_Wood rotate <0, 90.19, 0> }
  }
  box
  {
    <-6.5, -6, 6>
    < 6.5,  -2, 6.5>
    texture { My_Wood rotate <0, 90.23, 0> }
  }
  box
  {
    <-6.5, -6, -6>
    <-6, -2, 6>
    texture { My_Wood rotate <0, 0.12, 0> }
  }
  box
  {
    <6,    -6, -6>
    <6.5, -2,  6>
    texture { My_Wood rotate <0, -0.09, 0> }
  }
}

#declare Frame =
union
{
  light_source
  {
    <-6, FT - 1.5, -6> 
    color White
    spotlight
    radius 90
    falloff 90
    tightness 10
    point_at <-5, FT - 2.5, -5>
  }
  union
  {
    box
    {
      <-6.5, -2, -6.5>
      <-6.2, FT, -6.2>
    }
    box
    {
      <-6.5, FT, -6.5>
      < 6.5, FT + 0.3, -6.2>
    }
    texture {Polished_Chrome}
  }
  box
  {
    <-6.4, -2, -6.3>
    < 6.4, FT, -6.2>
    texture { Glass3 }
  }
}

object { Frame }
object { Frame rotate <0,  90, 0>}
object { Frame rotate <0, 180, 0>}
object { Frame rotate <0, 270, 0>}

box
{
  <-6.4, FT - 0.1, -6.4>
  < 6.4, FT,  6.4>
  texture { Glass3 }
}

torus
{
  5 5
  texture
  {
    pigment { color Red }
    finish
    {
      ambient 0.2
      diffuse 0.2
      crand 0.075
      roughness 0.15
    }
  }
  clipped_by
  {
    box
    {
      <-6, -5.5, -6>
      < 6,  5,  6>
    }
  }
  bounded_by { clipped_by}
  translate <0, -8, 0>
}

union
{
  box
  {
    <0, 0, -0.03>
    <1, 1, -0.03>
    texture
    {
      pigment
      {
	image_map
	{
	  tga "arthus.tga"
	}
      }
      finish
      {
	ambient 0.2
	diffuse 0.2
      }
    }
    scale <1.7, 1, 1>
  }
  box
  {
    <-0.2, -0.2, -0.02>
    <1.9, 1.2 0.02>
    texture
    {
      pigment
      {
	color White
      }
      finish
      {
	ambient 0.1
	diffuse 0.1
      }
    }
  }
  box
  {
    <-0.25, -0.25, 0>
    <1.95, 1.25, 0.01>
    texture
    {
      Polished_Chrome
      pigment { color Gray10 }
    }
  }
  scale <25, 25, 1>
  translate <-30, 0, 79>
}

box
{
  <-65, -10, -80>
  < 80,  150,  80>
  texture
  {
    pigment
    {
      color red 0.34 green 0.40 blue 0.65
    }
    finish
    {
      ambient 0.2
      diffuse 0.1
    }
  }
}

light_source { < 64, 100, -70> color White}
light_source { < 64, 100, -70> color White}
light_source { < 0, 100, -20> color White}
light_source { < 0, 100, -20> color White}


camera
{
  location <9, 9, -31>
  direction <0, 0, 1.5>
  look_at <0, 3.5, 0>
}


