//
// This is POV data file to scene oddjunk.pov by Timo Ettanen.
//
// This file contains following parts: Screw, Cup, Footpart, Foot
//
      #include "colors.inc"
      #include "shapes.inc"
      #include "textures.inc"

#declare Screw =
      difference{
          sphere{<0,0,0>,0.5
                 scale<1,1,0.7>
                 texture{Rust
                   scale 0.2
                 }
          }
          box{<-0.1,-0.5,-0.5><0.1,0.5,0>
                 texture{Rust
                   scale 0.2
                 }
          }
       bounded_by{sphere{<0,0,0>,0.5001}}
       }

#declare Cup =
  union{

      sphere{<0,0,0>,5
         clipped_by{box{<-5.001,-5.001,-5.001><5,0,0>}}
      }
      torus{5,0.25
         clipped_by{plane{z,0}}
      }
      difference{
          cone{<0, 0,-0.5>, 7 <0, 0, 0>, 7.3
          }
          cylinder{<0,0,-0.501><0,0,0.001>,5
          }
          plane{y,0.25
               inverse
          }
      }
      object{Screw
           translate<6,-1,-0.51>
      }
      object{Screw
           translate<6,-1,-0.51>
           rotate<0,0,-53>
      }
      object{Screw
           translate<6,-1,-0.51>
           rotate<0,0,-106>
      }
      object{Screw
           translate<6,-1,-0.51>
           rotate<0,0,-159>
      }
   texture{Brass_Metal}
   bounded_by{box{<-7.301,-7.301,-5.251><7.301,0.251,0.001>}}
  }


#declare Foot =
  difference{
    union{
       sphere{<0,0,0>,2.5
              scale<0.5,0.8,1>
       }
       sphere{<0,0,0>,2.5
              scale<0.5,0.8,1>
              rotate<0,90,0>
       }
       sphere{<0,0,0>,2.5
              scale<0.5,0.8,1.15>
              rotate<0,45,0>
       }
       sphere{<0,0,-2.2>,0.5              //nail
              scale<0.85,1.5,1>
       }
       sphere{<0,0,-2.2>,0.5              //nail
              scale<0.85,1.5,1>
              rotate<0,90,0>
       }
       sphere{<0,0,-2.48>,0.5             //nail
              scale<0.85,1.5,1>
              rotate<0,45,0>
       }
    }
    box{<-3.001,0,-3.001><1,2.5001,1> inverse }
    texture{Brass_Metal}
    bounded_by{box{<-3.01,-0.01,-3.01><1.01,2.501,1.001>}}
 }

#declare Footpart =
  union{
    difference{
       cylinder{<0,0,0><0,5,0>,0.25}
       box{<-0.2501,-0.0001,-0.2501><0,5.001,0> inverse }
    }
    difference{
       union{
          cylinder{<0,3,0><0,3,-0.25>,2}
          box{<0,0,-0.25><2,3,0>}
          box{<0,0,-0.25><6,2,0>}
          cylinder{<6,0,0><6,0,-0.25>,2}
       }
       box{<-0.001,-0.001,-0.2501><8.001,5.001,0.001> inverse }
    }
    difference{
       union{
          cylinder{<0,3,0><-0.25,3,0>,2}
          box{<-0.25,0,0><0,3,2>}
          box{<-0.25,0,0><0,2,6>}
          cylinder{<0,0,6><-0.25,0,6>,2}
       }
       box{<-0.2501,-0.001,-0.001><0.001,5.001,8.001> inverse }
    }
   object{Screw
       translate<6,1,-0.25>
   }
   object{Screw
       rotate<0,0,30>
       translate<3,1,-0.25>
   }
   object{Screw
       rotate<0,0,-30>
       translate<1,3.5,-0.25>
   }
   object{Screw
       rotate<0,90,0>
       translate<-0.25,1,6>
   }
   object{Screw
       rotate<0,90,0>
       rotate<-30,0,0>
       translate<-0.25,1,3>
   }
   object{Screw
       rotate<0,90,0>
       rotate<40,0,0>
       translate<-0.25,3.5,1>
   }

  texture{Brass_Metal}
 }
