// Scene File: RAYGUN.POV, for POV-Ray v2.x

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"
#include "genrator.inc"

camera {
  right     <1.33, 0, 0>
  up        <0, 1, 0>
  direction <0, 0, 1>
  location  <0, -1, -2.5>
  look_at   <0, -.4, 0>
}

// LIGHT_SOURCE
light_source {<2, 5.0, -2.0> color White }

light_source {<-18, .3, -150> color Gray35}

fog {
  color Gray10
  distance 30
}

background {color Gray10}

plane {y,0
   pigment {color Gray20}
  texture {
  pigment {
   image_map {
    gif "board.gif"
     once
   }
   scale <15, 15, 15>
   translate <-7.5, 0, 1.5>
   rotate x*90
  }
   finish {
    ambient .9
    diffuse 0 
    }
 }
   translate <0, -1.5, 0>
   scale <1.5, 1.5, 1.5>
}

union {
 object {
  genrator
 }

// jrc lazeray
 cylinder {<0, -2.5, 0>, <0, 2.5, 0>, 0.002
   rotate <0.0, 0.0, 90.0>
   translate <3.0, 0.0, 0.0>
   texture { pigment {color Cyan}
    finish {
     ambient 1}
   }
  }

 cylinder {<0, -0.4, 0>, <0, 0.4, 0>, 0.1 open
   rotate <0.0, 0.0, 90.0>
   translate <0.4, 0.0, 0.0>
 }

cylinder {<0, -0.01, 0>, <0, 0.01, 0>, 0.5
  rotate <0.0, 0.0, 90.0>
 }
cylinder {<0, -0.01, 0>, <0, 0.01, 0>, 0.5
  rotate <0.0, 0.0, 90.0>
  translate <0.066667, 0.0, 0.0>
 }
cylinder {<0, -0.01, 0>, <0, 0.01, 0>, 0.5
  rotate <0.0, 0.0, 90.0>
  translate <0.133333, 0.0, 0.0>
 }
cylinder {<0, -0.01, 0>, <0, 0.01, 0>, 0.5
  rotate <0.0, 0.0, 90.0>
  translate <0.2, 0.0, 0.0>
 }
cylinder {<0, -0.01, 0>, <0, 0.01, 0>, 0.5
  rotate <0.0, 0.0, 90.0>
  translate <0.266667, 0.0, 0.0>
 }

cylinder {<0, -0.6, 0>, <0, 0.6, 0>, 0.02
  translate <-1.266667, 0.0, 0.0>
 }
cylinder {<0, -0.6, 0>, <0, 0.6, 0>, 0.02
  rotate <120.0, 0.0, 0.0>
  translate <-1.266667, 0.0, 0.0>
 }
cylinder {<0, -0.6, 0>, <0, 0.6, 0>, 0.02
  rotate <60.0, 0.0, 0.0>
  translate <-1.266667, 0.0, 0.0>
 }


cone { <0, -0.3, 0>, 0.3, <0, 0, 0>, 0 open
  scale <1.0, 1.0, 1.0>
  rotate <0.0, 0.0, 90.0>
  translate <0.6, 0.0, 0.0>
 }


torus {0.6, 0.03
  rotate <0.0, 0.0, 90.0>
  translate <-1.266667, 0.0, 0.0>
 }
cylinder {<0, -0.4, 0>, <0, 0.4, 0>, 0.1
  rotate <0.0, 0.0, 90.0>
  translate <-0.4, 0.0, 0.0>
 }
cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, 0.297556, 0.000593>
 }
cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, 0.14963, 0.256593>
 }
cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, -0.150741, 0.26>
 }
cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, -0.303259, 0.000593>
 }

cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, -0.148519, -0.261111>
 }
cylinder {<0, -0.8, 0>, <0, 0.8, 0>, 0.01
  rotate <0.0, 0.0, 90.0>
  translate <-0.525, 0.14963, -0.258889>
 }
 rotate <-4, -35, -2> //--,4,-,0
  texture { pigment {color White}
 }
  scale <.85, .85, .85>
  translate <0.1, -.2, 0>
}

