// Planet Revive-O-Matic Spaceship
// 7/28/95 John Kolesar jkolesar@ix.netcom.com

#declare Generic =
  finish { ambient .3 diffuse .6 }

#declare PlanetRevive=
union{

union { // Funnel Entrance
  // Rim
  torus {1,.15
    pigment { Gray }
    finish { Metal }
    rotate <0, 0, 90>
    translate <-3,3,0>
       }
  // 1st tube (funnel)
  cone {<-3,3,0>,.9<-1,3,0>,.3
    texture { pigment { Gray } finish { Metal } }
    texture { pigment { image_map { gif "arrow_r.gif" map_type 2 once filter 0,1.0} rotate<0,-90,0> scale 2 translate <-2,2,0> } }
       }
  // joint
  sphere { <0, 0, 0>, .3
    pigment { Gray }
    finish { Metal }
    translate <-1,3,0>
  }
  // 2nd tube
  cone {<-1,3,0>,.3<0,2,0>,.15
    pigment { Gray }
    finish { Metal }
       }
  // joint
  sphere { <0, 0, 0>, .15
    pigment { Gray }
    finish { Metal }
    translate <0,2,0>
  }
  // 3rd tube
  cone {<0,2,0>,.15<0,1,0>,.15
    pigment { Gray }
    finish { Metal }
       }

  rotate <0,-20,0>          // rotate c-clockwise
  translate <-1.5,1.25,0>   // move to the left & up

} // end of Funnel Entrance union

union { // Funnel Exit
  // Rim
  torus {1,.15
    pigment { Gray }
    finish { Metal }
    rotate <0, 0, 90>
    translate <-3,3,0>
       }
  // 1st tube (funnel)
  cone {<-3,3,0>,.9<-1,3,0>,.3
    texture { pigment { Gray } finish { Metal } }
    texture { pigment { image_map { gif "arrow_r.gif" map_type 2 once filter 0,1.0} rotate<0,120,0> scale 2 translate <-2,2,0> } }
       }
  // joint
  sphere { <0, 0, 0>, .3
    pigment { Gray }
    finish { Metal }
    translate <-1,3,0>
  }
  // 2nd tube
  cone {<-1,3,0>,.3<0,2,0>,.15
    pigment { Gray }
    finish { Metal }
       }
  // joint
  sphere { <0, 0, 0>, .15
    pigment { Gray }
    finish { Metal }
    translate <0,2,0>
  }
  // 3rd tube
  cone {<0,2,0>,.15<0,1,0>,.15
    pigment { Gray }
    finish { Metal }
       }

  rotate <0,180,0>          // face backwards
  rotate <0,20,0>           // rotate clockwise
  translate <1.5,1.25,0>    // move to the right & up

} // end of Funnel Exit union

// Main body with Cockpit
difference {

intersection {

  // Main body
  sphere { <0, 0, 0>, .5
    texture { pigment { Gray } finish { Metal } 
              normal { bump_map { gif "mech.gif" bump_size 50 } scale .05 }
            }
    scale <10,2,2>
         }
  // angled plane
  plane { -x, 0
    pigment { Gray }
    finish { Metal }
    rotate <0,-20,-30>
    translate <-4,0,0>
  }
  scale <1.5,2.5,2.5>   // this scales the main body only

              } // end of Cockpit intersection

  // HF for cutout
  height_field { gif "cutout.gif" pigment {Grey}
                 translate <-.5,-.5,-.5> // center
                 rotate <0,180,0>        // get a better rotation
                 rotate <90,0,0>         // make mtn go into screen
                 scale <10,5,10>
                 translate <1,.5,0>    // move up/right a little
               }

// this is used to make the main body hollow ---------------
intersection {

  // Main body
  sphere { <0, 0, 0>, .5
    pigment { Gray }
    //finish { ambient .1 diffuse .9}
    scale <10,2,2>
         }
  // angled plane
  plane { -x, 0
    pigment { Gray }
    rotate <0,-20,-30>
    translate <-4,0,0>
  }
  scale <1.4,2.4,2.4>   // this scales the main body only 

              } // end of 2nd Cockpit intersection ---------

         } // end of HF Difference

// Windshield
  sphere { <0, 0, 0>, .5
    texture { Glass }
    scale <4,3,3>
    translate <-6,.25,0>
         }

// Eye (Pilot)
  sphere { <0,0,0> .1
         pigment { image_map { gif "eye.gif" map_type 1 } rotate <0,-20,0> }
         finish { ambient .3 diffuse .4 }
         scale 9
         translate <-6,.1,0>
         }

// Blue tubes union
union {
  // U-shaped tube (top left)
  cone {<-1.5,2.25,0>,.2<-1.5,1.25,0>,.2
    pigment { NavyBlue }
    finish { Metal }
       }
  // joint
  sphere { <0, 0, 0>, .2
    pigment { NavyBlue }
    finish { Metal }
    translate <-1.5,1.25,0>
  }
  // U-shaped tube (middle)
  cone {<-1.5,1.25,0>,.2<1.5,1.25,0>,.2
    pigment { NavyBlue }
    finish { Generic }
       }
  // joint
  sphere { <0, 0, 0>, .2
    pigment { NavyBlue }
    finish { Generic }
    translate <1.5,1.25,0>
  }
  // U-shaped tube (top right)
  cone {<1.5,2.25,0>,.2<1.5,1.25,0>,.2
    pigment { NavyBlue }
    finish { Generic }
       }
  // Extractor (politicians)
  cone {<0,0,0>,.4<0,1,0>,.3
    texture { pigment { Red } finish { Generic } }
    texture { pigment { image_map { gif "polit.gif" map_type 2 once filter 0,1.0} rotate<0,-90,0> scale<1,1,1> } }
    scale <1,1.75,1>
    translate <-.75,-.5,0>
       }
  // politicians
  cone {<-.75,-.05,0>,.2<-.75,-1.5,0>,.2
    pigment {spotted color_map {[ 0.05 color Black ]
                                [ 0.2  color Clear ]
                                [ 1.0  color Clear ]}
            scale .05
            }
    finish { Generic }
       }
  // Extractor (lawers)
  cone {<0,0,0>,.4<0,1,0>,.3
    texture { pigment { Red } finish { Generic } }
    texture { pigment { image_map { gif "lawer.gif" map_type 2 once filter 0,1.0} rotate<0,-90,0> scale<1,1,1> } }
    scale <1,1.75,1>
    translate <.75,-.5,0>
       }
  // lawers
  cone {<.75,-.05,0>,.2<.75,-1.5,0>,.2
    pigment {spotted color_map {[ 0.05 color Black ]
                                [ 0.2  color Clear ]
                                [ 1.0  color Clear ]}
            scale .05
            }
    finish { Generic }
       }
  no_shadow
} // EOU

  // Slime
  plane { y, 0
    texture { Water }
    pigment { ForestGreen }
    normal {waves 1 scale .5 translate <2,0,1> }
    translate <0,-1.5,0>
    clipped_by {  sphere { <0, 0, 0>, .5  // Main body
                  scale <10,2,2> scale <1.5,2.5,2.5>
                         }
               }
        }
// interior lights
light_source {<0, 1, -1> color White}
light_source {<0, 2, .5> color White}
  
// Monster
union {
  // HF for Head
  height_field { gif "cutout.gif"
                 pigment {spotted color_map {[ 0.3 color ForestGreen ]
                                             [ 0.5 color DarkBrown   ]
                                             [ 1.0 color DarkBrown   ]}
                         scale .05
                         }
                 finish {ambient .2 diffuse .3 }
                 translate <-.5,-.5,-.5> // center
                 rotate <0,90,0>
               }
  // Left Eye
  sphere { <0,0,0> .1
         pigment { image_map { gif "eye.gif" map_type 1 } rotate <0,-90,0> }
         finish { ambient .2 diffuse .4 }
         translate <.15,-.2,-.3>
         }
  // Right Eye
  sphere { <0,0,0> .1
         pigment { image_map { gif "eye.gif" map_type 1 } rotate <0,-90,0> }
         finish { ambient .2 diffuse .4 }
         translate <-.15,-.2,-.3>
         }
  rotate <0,45,0>            // make it face Left/Out of screen
  scale <2,1.5,2>
  translate <2,-1,1>     // move right/down a little

      } // EOU (monster)

// Engines
  cone {<0,0,0>,.5<3,0,0>,.5
    pigment { Gray }
    finish { Metal }
    translate <4.5,1,1>
       }
  cone {<0,0,0>,.5<3,0,0>,.5
    pigment { Gray }
    finish { Metal }
    translate <4.5,1,-1>
       }
  cone {<0,0,0>,.5<3,0,0>,.5
    pigment { Gray }
    finish { Metal }
    translate <4.5,-1,1>
       }
  cone {<0,0,0>,.5<3,0,0>,.5
    pigment { Gray }
    finish { Metal }
    translate <4.5,-1,-1>
       }

   } // EOU (All)


