// Persistence of Vision Raytracer

#include "shapes.inc"
#include "constant.inc"

#declare BeveledCube = intersection {
    object { Cube }
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0,  0, 45>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0, 45,  0>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate <45,  0,  0>}
}

#declare BeveledCube_X = intersection {
    object { Cube }
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0,  0, 45>}
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0, 45,  0>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate <45,  0,  0>}
}

#declare BeveledCube_XY = intersection {
    object { Cube }
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0,  0, 45>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0, 45,  0>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate <45,  0,  0>}
}

#declare BeveledCube_Y = intersection {
    object { Cube }
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0,  0, 45>}
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0, 45,  0>}
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate <45,  0,  0>}
}

#declare BeveledCube_Z = intersection {
    object { Cube }
    object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0,  0, 45>}
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate < 0, 45,  0>}
    //object { Cube scale <1.3435, 1.3435, 1.3435 > rotate <45,  0,  0>}
}

#declare CounterSink_Z = intersection {
   object { QCone_Z scale< 1.0, 1.0, 1.0 > translate<0.0, 0.0, -1.025>   }
   object { QCone_Z scale< 1.0, 1.0, 1.0 > translate<0.0, 0.0, -0.975> inverse  }
   object { QCone_Z scale< 1.0, 1.0, 1.0 > translate<0.0, 0.0,  0.975> inverse  }
   object { QCone_Z scale< 1.0, 1.0, 1.0 > translate<0.0, 0.0,  1.025>   }
}
#declare CounterSink_Y = intersection {
   object { QCone_Y scale< 1.0, 1.0, 1.0 > translate<0.0, -1.025, 0.0 >   }
   object { QCone_Y scale< 1.0, 1.0, 1.0 > translate<0.0, -0.975, 0.0 > inverse  }
   object { QCone_Y scale< 1.0, 1.0, 1.0 > translate<0.0,  0.975, 0.0 > inverse  }
   object { QCone_Y scale< 1.0, 1.0, 1.0 > translate<0.0,  1.025, 0.0 >   }
}
#declare CounterSink_X = intersection {
   object { QCone_X scale< 1.0, 1.0, 1.0 > translate<-1.025, 0.0, 0.0>   }
   object { QCone_X scale< 1.0, 1.0, 1.0 > translate<-0.975, 0.0, 0.0> inverse  }
   object { QCone_X scale< 1.0, 1.0, 1.0 > translate< 0.975, 0.0, 0.0> inverse  }
   object { QCone_X scale< 1.0, 1.0, 1.0 > translate< 1.025, 0.0, 0.0>   }
}


#declare Prism_Z = intersection {
    object{ plane{y,Sqrt3/3} rotate  180*z}
    object{ plane{y,Sqrt3/3} rotate  -60*z}
    object{ plane{y,Sqrt3/3} rotate   60*z}
}


#declare Qube = quartic {
  // a00 x^4     + a01 x^3 y   + a02 x^3 z   + a03 x^3     + a04 x^2 y^2 + 
  // a05 x^2 y z + a06 x^2 y   + a07 x^2 z^2 + a08 x^2 z   + a09 x^2     +
  // a10 x y^3   + a11 x y^2 z + a12 x y^2   + a13 x y z^2 + a14 x y z   + 
  // a15 x y     + a16 x z^3   + a17 x z^2   + a18 x z     + a19 x       +
  // a20 y^4     + a21 y^3 z   + a22 y^3     + a23 y^2 z^2 + a24 y^2 z   + 
  // a25 y^2     + a26 y z^3   + a27 y z^2   + a28 y z     + a29 y       + 
  // a30 z^4     + a31 z^3     + a32 z^2     + a33 z       + a34
  <  1.0,            0,            0,            0,            0,   
       0,            0,            0,            0,            0,
       0,            0,            0,            0,            0,   
       0,            0,            0,            0,            0,
     1.0,            0,            0,            0,            0,   
       0,            0,            0,            0,            0,
     1.0,            0,            0,            0,         -1.0>
}

#declare Qegg_Y = quartic {
  // a00 x^4     + a01 x^3 y   + a02 x^3 z   + a03 x^3     + a04 x^2 y^2 + 
  // a05 x^2 y z + a06 x^2 y   + a07 x^2 z^2 + a08 x^2 z   + a09 x^2     +
  // a10 x y^3   + a11 x y^2 z + a12 x y^2   + a13 x y z^2 + a14 x y z   + 
  // a15 x y     + a16 x z^3   + a17 x z^2   + a18 x z     + a19 x       +
  // a20 y^4     + a21 y^3 z   + a22 y^3     + a23 y^2 z^2 + a24 y^2 z   + 
  // a25 y^2     + a26 y z^3   + a27 y z^2   + a28 y z     + a29 y       + 
  // a30 z^4     + a31 z^3     + a32 z^2     + a33 z       + a34
  <    0,            0,            0,            0,            0,   
       0,            0,            0,            0,          1.0,
       0,            0,            0,            0,            0,   
       0,            0,            0,            0,            0,
     1.0,            0,            0,            0,            0,   
       0,            0,            0,            0,            0,
       0,            0,          1.0,            0,         -1.0>
}
#declare Qegg_Z = quartic {
  <
     0.0 /* x^4     + */ ,   0.0 /* x^3 y   + */ ,   0.0 /* x^3 z   + */ , 
     0.0 /* x^3     + */ ,   0.0 /* x^2 y^2 + */ ,   0.0 /* x^2 y z + */ , 
     0.0 /* x^2 y   + */ ,   0.0 /* x^2 z^2 + */ ,   0.0 /* x^2 z   + */ , 
     1.0 /* x^2     + */ ,   0.0 /* x y^3   + */ ,   0.0 /* x y^2 z + */ , 
     0.0 /* x y^2   + */ ,   0.0 /* x y z^2 + */ ,   0.0 /* x y z   + */ ,
     0.0 /* x y     + */ ,   0.0 /* x z^3   + */ ,   0.0 /* x z^2   + */ , 
     0.0 /* x z     + */ ,   0.0 /* x       + */ ,   0.0 /* y^4     + */ , 
     0.0 /* y^3 z   + */ ,   0.0 /* y^3     + */ ,   0.0 /* y^2 z^2 + */ , 
     0.0 /* y^2 z   + */ ,   1.0 /* y^2     + */ ,   0.0 /* y z^3   + */ , 
     0.0 /* y z^2   + */ ,   0.0 /* y z     + */ ,   0.0 /* y       + */ ,
     1.0 /* z^4     + */ ,   0.0 /* z^3     + */ ,   0.0 /* z^2     + */ , 
     0.0 /* z       + */ ,  -1.0 /*           */                         
  >
}
