// Persistence of Vision Raytracer
//
// untextured window intended for solid color texturing
// as though painted.
//
// requires shapes.inc and myshapes.inc to be loaded already
//............................................................

#declare WindowWall1 = intersection {
  object {box {<-100.0,-100.0,-4.0><100.0,100.0,4.0>}}
  object {box {<-14.1,-28.0,-4.1><14.1,26.0,4.1>} inverse}
}

#declare WindowSash = object {
  intersection {
    object {box {<-14.0,-14.0,-1.0><14.0,14.0,1.0>}}
    object {BeveledCube_XY scale<12.5,12.5,12.5> translate 12*z inverse}
    object {BeveledCube_XY scale<12.5,12.5,12.5> translate -12*z inverse}
    object {box {<-12.0,-12.0,-1.0><12.0,12.0,1.0>} inverse}
  }
}

#declare LowerSash = object{
  union {
    object {WindowSash}
    object {cylinder { <0,-13,0>, <0,13,0>, 1} scale <0.5,1.0,0.95>}
    object {cylinder { <-13,0,0>, <13,0,0>, 1} scale <1.0,0.5,0.95>}
  }
  bounded_by {box {<-14.1,-14.1,-1.1><14.1,14.1,1.1>}}
}

#declare UpperSash = object {
  union {
    object {WindowSash}
    object {cylinder { <0,-13,0>, <0,13,0>, 1} scale <0.5,1.0,0.95>}
    object {cylinder { <-13,0,0>, <13,0,0>, 1} scale <1.0,0.5,0.95>}
  }
  bounded_by {box {<-14.1,-14.1,-1.1><14.1,14.1,1.1>}}
}

#declare Sill = union {
  object {box {<-14.1,-28.0,-4.0><-14.0,26.0,4.0>}  }
  object {box {<14.0,-28.0,-4.0><14.1,26.0,4.0>}  }
  object {box {<-19.0,-28.0,-6.0><19.0,-27.5,-1.0>}  }
  object {box {<-17.0,-32.0,-4.5><17.0,-28.0,-4.0>}  }
  object {box {<-18.5,26.0,-5.0><18.5,30.0,-4.0>}  }
  object {box {<-18.0,-28.0,-4.5><-14.0,26.0,-4.0>}  }
  object {box {< 14.0,-28.0,-4.5>< 18.0,26.0,-4.0>}  }
}

#declare Window = union {
  //object {WindowWall1}
  object {Sill}
  object {LowerSash translate<0.0,-14.0,-1.0>}
  object {UpperSash translate<0.0, 12.0, 1.0>}
  rotate <0, 0, 0>
  scale <1.0,  1.0,  1.0 >
  translate <0.0, 0.0, 0.0>
}
