#declare POLISHED_METAL = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.93
        phong_size 28.0
        metallic
        reflection .15
    }
    pigment { rgb <0.369, 0.451, 0.529> }
}

#declare POLISHED_METAL2 = texture {
    finish {
        ambient 0.10
        diffuse 0.90
        phong 0.93
        phong_size 28.0
        metallic
        reflection .15
    }
    pigment { rgb <0.569, 0.601, 0.629> }
}

#declare Desk =
union {
  box { <-8.5,-5,-2>,<8.5,-4.54,10>
    texture { POLISHED_METAL } 
  }
  difference {
    box { <-8.1,-7.4,-1.65>,<8.1,-5,10> }
    box { <-6.3,-7.25,-10>,<6.3,-5,5> }
    texture { POLISHED_METAL2 }
  }
  box { <-6.3,-7.25,-6>,<6.3,-7,5> 
    texture { POLISHED_METAL }
  }
  box { <-6.2,-7,-5.8>,<-6.05,-5.05,5> 
    texture { POLISHED_METAL2 }
  }
  box { <6.05,-7,-5.8>,<6.2,-5.05,5> 
    texture { POLISHED_METAL2 }
  }
  cylinder { <-5.8,-7.25,-.5>,<-5.8,-18,-.5>,.5 
    texture { POLISHED_METAL2 }
  }
  cylinder { <5.8,-7.25,-.5>,<5.8,-18,-.5>,.5 
    texture { POLISHED_METAL2 }
  }
}

#declare Floor =
plane { <0,1,0>,0 translate -10*y
  pigment { color rgb<.8,.4,.2> }
  normal { bumps .2 }
}

#declare Walls =
union {
  difference {
    box { <-200,-200,0>,<200,200,2> rotate 45*y translate 60*z }
    box { <-10,-10,-10>,<10,10,10> 
      rotate 45*y 
      translate <32,6.5,28>
    }
  }
  box { <-200,-200,0>,<200,200,2> rotate -45*y translate 60*z }
  pigment { rgb<1,.95,.85> }
  no_shadow
}

#declare WindowSill = 
difference {
  box { <-10,-10,-1>,<10,10,1> }
  box { <-8.75,-8.25,-2>,<8.75,8.75,2> }
  no_shadow
}

#declare Windows =
difference {
  box { <-8.75,-4.25,-.3>,<8.75,4.25,.3> }
  box { <-8,.375,-1>,<-.375,3.5,1> }
  box { <-8,-3.5,-1>,<-.375,-.375,1> }
  box { <.375,.375,-1>,<8,3.5,1> }
  box { <.375,-3.5,-1>,<8,-.375,1> }
  no_shadow
}

#declare OutSide =
box { <-20,-20,2>,<20,20,3> 
  pigment {
    image_map {
      tga "outdoor.tga"
      interpolate 2
    }
    translate <-.5,-.5,0>
    scale <18.6875,20,1>
  }
  finish { ambient 1 }
}

#declare WINDOW =
union { 
  object { WindowSill }
  object { Windows translate <0,-4,-.25> }
  object { Windows translate <0,4.5,.25> }
  object { OutSide }
  pigment { rgb<.95,.97,1> }
  rotate 45*y
  translate <32,6.5,28>
}

#declare Wallboards =
union {
  box { <-.4,-10,-150>,<.4,-7.8,1> rotate 45*y translate 60*z }
  box { <-.4,-10,-150>,<.4,-7.8,1> rotate -45*y translate 60*z }
  pigment {
    wood color_map {
      [0 color rgb<.67,.312,.2> ]
      [.8 color rgb<.4,.133,.066> ]
      [1 color rgb<.2,.065,.033> ]
    }
    turbulence .1
  }
}
      
#declare WALLS =                         
union {
  object { Walls }
  object { Wallboards }
  object { WINDOW }
  rotate -25*y 
}

#declare ROOM =
union {
  object { WALLS }
  object { Floor }
}
