//  Persistance of Vision Raytracer V2.0
//  World definition file.
//
//  Contains 2 lights, 8 textures and 12 primitives.
//
//  This file was generated for POV-Ray V2.0 by
//  MORAY.EXE (c) 1991-1994 SoftTronics by Lutz Kretzschmar + Markus Lutz
//

//  Date : 06/02/1995    (02.06.1995)
//

//
//  This is the standard include file for POV.
//

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"

// If you don't like or want the green floor plane and the blue sky, then
// delete the following line. (To permanently delete it, remove it from
// MRYDEFLT.INC in your Moray directory.

camera {  //  Camera Camera01
  location  <1.000, -13.576, 5.496>
  direction <0.0,     0.0,  2.4880>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <1.487, -1.115, 3.974>
}

// *******  L I G H T S *******
light_source {   // Light001
  <10.000, -10.000, 20.000>
  color rgb <1.000, 1.000, 1.000>
}

light_source {   // Light2
  <-5.124, -10.000, 8.600>
  color rgb <1.000, 1.000, 1.000>
}


//
// ********  T E X T U R E S  *******
//

#include "FIRE.INC"

// ********  O B J E C T S *******
#declare Cube001 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 2.000000, 1.000000>
}

#declare Cube2 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 2.200000, 1.000000>
  rotate <-0.000000, -0.000000, -90.000000>
  translate <2.000000, 2.000000, 0.000000>
}

#declare Cube3 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 2.000000, 1.000000>
  translate <4.000000, 0.000000, 0.000000>
}

#declare Cube4 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.200000, 2.200000, 1.000000>
  rotate <-0.000000, -0.000000, -90.000000>
  translate <2.000000, -2.000000, 0.000000>
}

#declare Cube5 = box {
  <-1, -1, -1>, <1, 1, 1>
  scale <0.000010, 2.000000, 2.000000>
  rotate <-0.000000, -90.000000, -0.000000>
  translate <2.000000, 0.000000, -1.000000>
}

#declare Cube002 = box {
  <-1, -1, -1>, <1, 1, 1>
  texture {
    CoolFire
    scale <2.000000, 2.000000, 1.000000>
    translate <-1.000000, -1.000000, 1.000000>
  }
  scale <2.000000, 2.000000, 0.750000>
  translate <2.000000, 0.000000, 0.000000>
}

union {
  object { Cube001 }
  object { Cube2 }
  object { Cube3 }
  object { Cube4 }
  object { Cube5 }
  object { Cube002 }
  texture {
    GrayStones
  }
  translate <0.000000, 0.000000, 1.300000>
}

plane {   // Plane001
  z,0
  texture {
    Stone1
  }
  translate <0.000000, 0.000000, 2.000000>
}

object {   // EMMc2
  height_field {
    gif "emc.gif" 
    water_level 0.039216
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    Cork
  }
  scale <1.000000, 0.500000, 0.250000>
  rotate <-289.910156, -0.000000, 26.898964>
  translate <-1.982652, 9.541512, 3.593556>
}

object {   // TraSwp001
  union {
    smooth_triangle {
      <-1.50000, -2.00000, 1.00000> <-0.00000, 1.00000, 0.00000>
      <1.50000, -2.00000, 1.00000> <-0.00000, 1.00000, 0.00000>
      <1.50000, -2.00000, 0.00000> <-0.00000, 1.00000, 0.00000>
    }
    smooth_triangle {
      <-1.50000, -2.00000, 1.00000> <-0.00000, 1.00000, 0.00000>
      <-1.50000, -2.00000, 0.00000> <-0.00000, 1.00000, 0.00000>
      <1.50000, -2.00000, 0.00000> <-0.00000, 1.00000, 0.00000>
    }
    smooth_triangle {
      <1.50000, -2.00000, 1.00000> <-0.89443, -0.44721, 0.00000>
      <0.00000, 1.00000, 1.00000> <-0.89443, -0.44721, 0.00000>
      <0.00000, 1.00000, 0.00000> <-0.89443, -0.44721, 0.00000>
    }
    smooth_triangle {
      <1.50000, -2.00000, 1.00000> <-0.89443, -0.44721, 0.00000>
      <1.50000, -2.00000, 0.00000> <-0.89443, -0.44721, 0.00000>
      <0.00000, 1.00000, 0.00000> <-0.89443, -0.44721, 0.00000>
    }
    smooth_triangle {
      <0.00000, 1.00000, 1.00000> <0.89443, -0.44721, 0.00000>
      <-1.50000, -2.00000, 1.00000> <0.89443, -0.44721, 0.00000>
      <-1.50000, -2.00000, 0.00000> <0.89443, -0.44721, 0.00000>
    }
    smooth_triangle {
      <0.00000, 1.00000, 1.00000> <0.89443, -0.44721, 0.00000>
      <0.00000, 1.00000, 0.00000> <0.89443, -0.44721, 0.00000>
      <-1.50000, -2.00000, 0.00000> <0.89443, -0.44721, 0.00000>
    }
      // 1 Top and base plane triangles

    triangle { <  -1.50000,   -2.00000,    1.00000> <   1.50000,   -2.00000,    1.00000> <   0.00000,    1.00000,    1.00000> }
    triangle { <  -1.50000,   -2.00000,    0.00000> <   1.50000,   -2.00000,    0.00000> <   0.00000,    1.00000,    0.00000> }
  }
  texture {
    Yellow_Pine
  }
  scale <0.500000, 0.500000, 0.500000>
  rotate <-186.949097, -411.076538, 421.276398>
  translate <4.213135, 5.204461, 3.504337>
}

#declare Sphere001 = object { 
  sphere {<0,0,0>,1}
  texture {
    mirrorz
  }
}

#declare Torus001 = torus { 
  1.500, 0.500  // Major, minor radius
  rotate -x*90
  texture {
    mirrorz
  }
}

union {
  object { Sphere001 }
  object { Torus001 }
  scale <0.400000, 0.400000, 0.400000>
  rotate <124.669075, -0.000000, -0.000000>
  translate <1.256506, 0.371747, 5.615242>
}

plane {   // Plane002
  z,0
  texture {
    Blue_Sky
  }
  translate <0.371747, 0.000000, 40.000000>
}

