// Scene File: JCMSCOPE.POV, for POV-Ray v2.x

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "greytop.inc" //replace stones.inc
#include "pov2tex.inc"
#include "arm.inc"
#include "armbotm.inc"
#include "basepilr.inc"
#include "plat.inc"
#include "incline.inc"
#include "slidclip.inc"
#include "lens2.inc"  //lenses, iris, mirror, etc.
#include "flame.inc"
#include "bunsun.inc"
#include "standtp3.inc" //beaker, legs etc.
#include "hose.inc"

//  photograpy with a 135mm lens:
 camera {
   up <0,1,0>
   right <4/3, 0, 0>
   direction <0, 0, 3.156876> //Lens_135mm>
   location <5, 15.75, -33>
   look_at <2, .8, .30>
}

light_source { <100.0, 400.0, -600.0> color White }

//   a back-light to create a highlight on the work space
light_source { <-4, 15.75, 65> color Gray10}

light_source {
  <4,-3,-12>
   color White
}

light_source {
  <3,-4,-9>
   color White
}

// grayslate for chemlab
box { <-1, -1, -1>, <1, 1, 1>
  scale <24.0, 0.01, 18>
  translate <0.04, -0.05, -0.275>
  texture {greytop
      finish { phong 0.5
         reflection 0.2
      }
   rotate <0, 90, 2>
   scale <2, 2, 2>
  }
   translate <0, -3.8, 0>
}

union {
   object {
    hotflame
}
object {
  flame
 }

object {
  bunsun
   texture {Polished_Brass 
      finish { phong 0.2
         reflection 0.05
         }
   }
}

cylinder {<0, -0.5, 0>, <0, 0.5, 0>, 0.0465
  translate <0.0, 0.64, 0.0>
  texture {pigment {red .20 green .14 blue .05} 
      finish { phong 0.2
         reflection 0.05
      }
  }
}

cylinder {<0, -0.1, 0>, <0, 0.1, 0>, 0.02
  rotate <90.0, 90.0, 0.0>
  translate <-0.133333, 0.145,0>
   texture {New_Brass}
}

object {
    hose
   pigment {color Gray05}
    translate <-16.5,2,0>
    scale .075 //.2
   }
    scale <3.5, 3.5, 3.5>
    rotate y*125
    translate <5, -3.8, 4>
 }

union {
 object {
  standtop
  texture {pigment {red .20 green .14 blue .05} 
      finish {
         ambient .3
         reflection 0.02
         }
    }
  }
 object {
    standlegs
  texture {pigment {red .20 green .14 blue .05} 
      finish { phong 0.2
         reflection 0.05
         }
    }
  }
object {
  flask
  texture {Glass2}
//  translate <0, 5.075, 0>
}
     scale <3.5, 3.5, 3.5>
    rotate <0, 10, 0>
    translate <5, -3.75, 4>
 }  //  ----end stand union

union {   // start eyepiece-top
 cylinder {<0, -0.455, 0>, <0, 0.455, 0>, 0.36
  translate <0.0, 5.15, 0.0>
  texture {New_Brass}
 }
 cone { <0, -0.15, 0>, 0.4, <0, 0, 0>, 0
  translate <0.0, 4.83, 0.0>
  texture {New_Brass}
 }
 torus {0.37, 0.035
  scale <1.0, 1.0, 0.8>
  translate <0.0, 5.6, 0.0>
  texture {New_Brass}
 }
}

object {
  lens
  texture {New_Brass}
}

cylinder {<0, -1.5, 0>, <0, 1.5, 0>, 0.35
  scale <1.5, 1.0, 1.5>
  translate <0.0, 2.8, 0.0>
  texture {Polished_Brass}
}

torus {0.36, 0.05
  scale <1.4, 1.0, 1.0>
  translate <0.0, 1.28, 0.0>
  texture {Polished_Brass}
}

torus {0.36, 0.05
  scale <1.4, 1.0, 1.0>
  translate <0.0, 4.3, 0.0>
  texture {Polished_Brass}
}

torus {0.4, 0.1
  translate <0.0, 4.58, 0.0>
  texture {Polished_Brass}
}

torus {0.36, 0.05
  scale <1.4, 1.0, 1.0>
  translate <0.0, 1.112167, 0.0>
  texture {Polished_Brass}
}


torus {0.4, 0.045
  translate <0.008, 0.651166, 0.0>
  texture {New_Brass}
}

// top of main lens?
cylinder {<0, -2.0, 0>, <0, 2.0, 0>, 0.365
  scale <1.1, 1.0, 1.0>
  translate <0.0, 2.5, 0.0>
  texture {New_Brass}
}

torus {0.4, 0.045
  translate <0.0, 0.55, 0.0>
  texture {New_Brass}
}

cylinder {<0, -0.2, 0>, <0, 0.2, 0>, 0.32
  texture {New_Brass}
  translate <0.0, 0.359, 0.0>
}

torus {0.325, 0.035
  translate <0.0, 0.164, 0.0>
  texture {New_Brass}
}

torus {0.325, 0.035
  translate <0.0, 0.086, 0.0>
  texture {New_Brass}
}

cylinder {<0, -0.25, 0>, <0, 0.25, 0>, 0.225
  translate <0.0, -0.1, 0.0>
  texture {New_Brass}
}

torus {0.23, 0.025
  translate <0.0, -0.336, 0.0>
  texture {New_Brass}
}  //end lens tube?

object {
  knob  //focuscrew
   rotate <90,0,0>
  translate <-.709, 3.45, .62>
  texture {New_Brass}
}
 
object {
  knob //focuscrew
   rotate <-90,0,0>
  translate <-.709, 3.45, -.62>
  texture {New_Brass}
}

union {
 object {
  arm
   scale <6,6,4>
   translate <-1.05,3.15,-.2>
    pigment {color Gray10}
  }
 box { <-1, -1, -1>, <1, 1, 1>
  scale <0.3, 1.25, 0.25>
  translate <-0.6, 2.55, 0.0>
  texture {Polished_Brass}
 }
 object {
  armbottom
  translate <-2.095, -.563, 0.0>
    texture {pigment {color Gray15}
      finish {
       diffuse .4
      }
  } 
}

 object {   //slide platform
  platform
   scale <6, 6, 2>
   rotate <90, 90, 0>
   translate <.8, -.6, -.2> 
    texture {pigment {color Gray10}
      finish { phong 0.5
         reflection 0.25
      }
   }
 }

 object {
   clipknob
   translate <0, 0, -.85>
   texture {New_Brass}
 }
 object {
   slideclips
   translate <0, 0, -.04>
}

 object {
   clipknob
   translate <0, 0, .85>
   texture {New_Brass}
 }
 object {
   slideclips
   translate <0, 0, 1.67>
}

 object {
   knob
   scale <.5, .5, .5>
   rotate <-90,0,0>
   translate <-1.7, -1.2, -.45>
   texture {Polished_Brass}
}

 object {
   pillar
    texture {pigment {color Gray10}
      finish {
       diffuse .3
      }
    }
}

 object {
  base
   scale <6.5, 6.5, 4>
   rotate <90, 90, 0>
   translate <.17, -3.5, -.2>
    pigment {color Gray05}
  }

 object {
   incline
   scale <6, 6, 10>
   translate <-2.29, -.8, -.25>
    pigment {color Gray25}
}
 object {
   iris
}
 object {
   mirror2
    translate <1, -.3, 0>
}
box { <-1, -1, -1>, <1, 1, 1> //mirror bar
  scale <1.0, 0.09, 0.09>
  translate <-0.6, -3.5, 0.0>
  texture { pigment {color Gray10}}
}

 object {
   lensplate
}

 object {
   lens2
   scale .9
  rotate <0, 140, 40>
  translate <1.45, .575, -.2>
   texture {New_Brass}
}
// shortlens
cylinder {<0, -0.35, 0>, <0, 0.35, 0>, 0.365
  rotate <-20.0, 0.0, 20.0>
  translate <0.8, 0.97, 0.66>
  texture {New_Brass}
 }
}

union {  //shelf
box { <-1, -1, -1>, <1, 1, 1>
  scale <24.0, 0.25, 3>
  translate <0.0, 3.75, 14.0>
  texture {DMFWood5
    finish {diffuse .3}
   scale <.25, .25, 1>
   rotate <3, 90, 0>
   }
}

box { <-1, -1, -1>, <1, 1, 1>
  scale <5, 0.25, 3>
  rotate <0.0, 0.0, 90.0>
  translate <-8.0, -1.03, 14.0>
  texture {DMFWood5
    finish {diffuse .3}
   scale <.25, .25, 1>
   rotate <90, 3, 0>
   }
}

box { <-1, -1, -1>, <1, 1, 1>
  scale <5, 0.25, 3>
  rotate <0.0, 0.0, 90.0>
  translate <10.0, -1.03, 14.0>
  texture {DMFWood5
    finish {diffuse .3}
   scale <.25, .25, 1>
   rotate <90, 3, 0> 
   }
 }
}

cylinder {<0, -12.5, 0>, <0, 12.5, 0>, 0.125
  rotate <0.0, 0.0, 90.0>
  translate <0.0, 2.9, 10.4>
  texture {pigment {red .20 green .14 blue .05} 
      finish { phong 0.2
         reflection 0.04
         }
     }
}

