merge
    {
    cylinder // bottom
	{ <0, 0, 0>, <0, beaker_thick, 0>, beaker_radius - beaker_flare_radius}

    difference // sides
	{
	cylinder { <0, beaker_flare_radius, 0>,              
		   <0, beaker_height-beaker_flare_radius, 0>,
		       beaker_radius }
	cylinder { <0, beaker_flare_radius-beaker_thick, 0>, 
		   <0, beaker_height-beaker_flare_radius+beaker_thick, 0>,
		       beaker_radius - beaker_thick }
	}

    intersection // bottom flare
	{
	difference
	    {
	    difference
		{
		torus // outside surface of the flare
		    {
		    beaker_radius - beaker_flare_radius, beaker_flare_radius
		    translate <0, beaker_flare_radius, 0>
		    }
		torus // inside surface of the flare
		    {
		    beaker_radius - beaker_flare_radius, beaker_flare_radius - beaker_thick
		    translate <0, beaker_flare_radius, 0>
		    }
		}

	    cylinder { <0, 0, 0>, <0, 2*beaker_flare_radius+2*beaker_thick, 0>,
			   beaker_radius - beaker_flare_radius}
	    }

	box { <-beaker_radius-beaker_thick, -beaker_thick, -beaker_radius-beaker_thick>,
		  <beaker_radius+beaker_thick, beaker_flare_radius, beaker_radius+beaker_thick> }
	}

    intersection // top flare
	{
	difference
	    {
	    torus // inside surface of the flare
		{
		beaker_radius + beaker_flare_radius - beaker_thick, beaker_flare_radius
		translate <0, beaker_height - beaker_flare_radius, 0>
		}
	    torus // outside surface of the flare
		{
		beaker_radius + beaker_flare_radius - beaker_thick, beaker_flare_radius - beaker_thick
		translate <0, beaker_height - beaker_flare_radius, 0>
		}
	    }

	cylinder { <0, 0, 0>,
		   <0, beaker_height + beaker_thick, 0>,
		       beaker_radius + beaker_flare_radius - 3*beaker_thick}

	box { <-beaker_radius-beaker_flare_radius-beaker_thick,
		  beaker_height - beaker_flare_radius-beaker_thick,
		      -beaker_radius-beaker_flare_radius-beaker_thick>,
	      <beaker_radius+beaker_flare_radius+beaker_thick,
		  beaker_height + beaker_flare_radius+beaker_thick,
		      beaker_radius+beaker_flare_radius+beaker_thick> }
	}

    bounded_by
	{
	cylinder
	    {
	    <0, -beaker_thick, 0>,
	    <0, beaker_height+beaker_flare_radius+beaker_thick, 0>,
	    beaker_radius+beaker_thick+2*beaker_flare_radius
	    }
	}

    texture
	{
	pigment { color White filter 0.8 }
	finish { reflection 0.3 diffuse 0.3 specular 0.2 refraction 1 ior 3.0}
	}
    }
