declare page_text = texture 
    {
    pigment { image_map { gif "note_paper.gif" }  } 
    finish { diffuse 0.8 }
    rotate 90*z
    }

declare cow_text = texture
    {
    pigment { image_map { gif "cowhead.gif" once } scale .4 }
    finish { diffuse 0.8 }
    translate <-.6, .3, 0>
    rotate 270*z
    }

declare book_pages = 6
declare book_page_thick = .02
declare book_ratio = 200/160
declare book_cowratio = 972/856

declare book_half = union
    {
    union // cover
	{
	box { <0-1*book_page_thick, 0-3*book_page_thick,                  0>,
	      <1+1*book_page_thick, 1+3*book_page_thick, book_page_thick*.9>
		translate <0, (book_pages+1)*book_page_thick, 0>
	      } // main part of the cover

	box { < 0-1*book_page_thick, -(book_pages-3)*book_page_thick,  0>,
	       <1+1*book_page_thick,    0, book_page_thick*.9>
	      } // spine of the cover
	texture { pigment { color Brown } } scale <book_ratio, 1, 1>
	}

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.25>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.25>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.25>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.25>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-5)*book_page_thick, -5*book_page_thick>
      }

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.2>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.2>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.2>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.2>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-4)*book_page_thick, -4*book_page_thick>
      }

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.15>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.15>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.15>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.15>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-3)*book_page_thick, -3*book_page_thick>
      }

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.1>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.1>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.1>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.1>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-2)*book_page_thick, -2*book_page_thick>
      }

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.05>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.05>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.05>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.05>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-1)*book_page_thick, -1*book_page_thick>
      }

    bicubic_patch {
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.0>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.0>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.0>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.0>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text } scale <book_ratio, 1, 1>
      translate <0, (book_pages-0)*book_page_thick, -0*book_page_thick>
      }

    }

declare book = union
    {
    bicubic_patch { // top page
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.3>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.3>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.3>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.3>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text }
      texture { cow_text  }
      scale <book_ratio, 1, 1> translate <0, (book_pages-6)*book_page_thick, -6*book_page_thick>
      rotate 90*x
      }

    bicubic_patch { // top page
      type 1 flatness 0 u_steps 3 v_steps 3
      <.000, 0, 0>, <.000, .2, -.3>, <.000, .5, 0>, <.000, 1, 0>,
      <.333, 0, 0>, <.333, .2, -.3>, <.333, .5, 0>, <.333, 1, 0>,
      <.667, 0, 0>, <.667, .2, -.3>, <.667, .5, 0>, <.667, 1, 0>,
      <1.00, 0, 0>, <1.00, .2, -.3>, <1.00, .5, 0>, <1.00, 1, 0>
      texture { page_text }
      scale <book_ratio, 1, 1> translate <0, (book_pages-6)*book_page_thick, -6*book_page_thick>
      rotate 90*x
      rotate 180*y
      translate <book_ratio, 0, 0>
      }

    object
	{
	book_half
	rotate 90*x
	}

    object
	{
	book_half
	rotate 90*x
	rotate 180*y
	translate <book_ratio, 0, 0>
	}

    scale 8.5 translate <0, .2, 0>
    }

// book is defined x in {0, 11} z in {-9, 9}
