
declare cupboardDepth = 6
declare cupboardHeight = 18
declare cupboardWidth = 15
declare cupboardThick = .3

declare cupboard_door = union
    {
    box // vertical
	{
	<0, 0, 0>, <2*cupboardThick, cupboardHeight, cupboardThick>
	pigment { DMFWood1 turbulence 0.2 rotate 90*x translate <2, 2, 2> scale 10 }
	translate <0, 0, 0>
	}
    box // vertical
	{
	<0, 0, 0>, <2*cupboardThick, cupboardHeight, cupboardThick>
	pigment { DMFWood1 turbulence 0.2 rotate 90*x translate <2, 2, 2> scale 10 }
	translate <cupboardWidth/2, 0, 0>
	}
    box // horizontal top
	{
	<0, 0, 0>, <cupboardWidth/2, 2*cupboardThick, cupboardThick>
	pigment { DMFWood1 turbulence 0.2 rotate 90*z translate <2, 2, 2> scale 10 }
	translate <0, cupboardHeight-2*cupboardThick, 0>
	}
    box // horizontal middle
	{
	<0, 0, 0>, <cupboardWidth/2, 2*cupboardThick, cupboardThick>
	pigment { DMFWood1 turbulence 0.2 rotate 90*z translate <2, 2, 2> scale 10 }
	translate <0, (cupboardHeight-2*cupboardThick)/2, 0>
	}
    box // horizontal bottom
	{
	<0, 0, 0>, <cupboardWidth/2, 2*cupboardThick, cupboardThick>
	pigment { DMFWood1 turbulence 0.2 rotate 90*z translate <2, 2, 2> scale 10 }
	translate <0, 0, 0>
	}
    box // glass
	{
	<cupboardThick/2, cupboardThick/2, cupboardThick/2>,
	<cupboardWidth/2-cupboardThick/2, cupboardHeight-cupboardThick/2, cupboardThick*(3/4)>
	texture
	    {
	    pigment { color White filter 0.95 }
	    finish { reflection 0.3 diffuse 0.1 specular 0.2 refraction 1 ior 3.0}
	    }
	}
    }

declare cupboard = union
    {
    box // side
	{
	<0, 0, 0>, <cupboardThick, cupboardHeight, cupboardDepth>
	pigment { DMFWood1 turbulence 0.2 rotate 90*x translate <2, 2, 2> scale 10 }
	translate <0, 0, 0>
	}

    box // side
	{
	<0, 0, 0>, <cupboardThick, cupboardHeight, cupboardDepth>
	pigment { DMFWood1 turbulence 0.2  rotate 90*x translate <2, 2, 2> scale 10}
	translate <cupboardWidth, 0, 0>
	}

    box // bottom shelf
	{
	<cupboardThick, 0, 0>, <cupboardWidth, cupboardThick, cupboardDepth>
	pigment { DMFWood1 turbulence 0.2  rotate 90*y translate <2, 2, 2> scale 10}
	translate <0, 0, 0>
	}

    box // shelf
	{
	<cupboardThick, 0, 0>, <cupboardWidth, cupboardThick, cupboardDepth>
	pigment { DMFWood1 turbulence 0.2 rotate 90*y translate <2, 2, 2> scale 10 }
	translate <0, (cupboardHeight-cupboardThick)/2, 0>
	}

    box // top
	{
	<cupboardThick, 0, 0>, <cupboardWidth, cupboardThick, cupboardDepth>
	pigment { DMFWood1 turbulence 0.2  rotate 90*y translate <2, 2, 2> scale 10}
	translate <0, cupboardHeight-cupboardThick, 0>
	}

    box // back
	{
	<0, 0, 0>, <cupboardWidth, cupboardHeight, cupboardThick>
	pigment { color rgb <0.3, 0.3, 0.1> }
	}

    object { cupboard_door rotate -70*y translate <0, 0, cupboardDepth> }
    object { cupboard_door translate <cupboardWidth/2, 0, cupboardDepth> }
    }
