// ---- Standard POV-Ray Includes ----
include "shapes.inc"
include "colors.inc"
include "textures.inc"

// local sci includes
include "beaker.inc" // definitions of several beakers
include "book.inc"
include "torch.inc"
include "table.inc"
include "cupboard.inc"

// define the center of the top of the table
declare tableX = table_length/2
declare tableY = table_height
declare tableZ = table_width/2

declare camX = 150
declare camY = 75
declare camZ = 120

camera
    {
    location		<camX, camY, camZ>
    direction		<0, 0, 2.5>
    right		<4/3, 0, 0>
    up			<0, 1, 0>
    look_at		<tableX, tableY+4, tableZ>
    }

light_source {<camX, camY, camZ> color rgb <0.4, 0.4, 0.35> } // Ambient light



include "walls.inc"

object { table translate <tableX, tableY, tableZ> }

object { book  rotate 45*y translate <tableX+30, tableY, tableZ+8> }

object { cupboard translate <tableX-10, tableY, 0> }

union
    {
    object { candle }
    light_source { <0, 9.5, 0> color rgb <.8, .5, 0> }
    translate <tableX-10, tableY+cupboardHeight, cupboardDepth/2>
    }

union
    {
    object { candle }
    light_source { <0, 9.5, 0> color rgb <.8, .5, 0> }
    translate <tableX+15, tableY, tableZ-6>
    }

union
    {
    object { candle }
    light_source { <0, 9.5, 0> color rgb <.8, .5, 0> }
    translate <tableX-15, tableY, tableZ-6>
    }

/* Beakers on the table */
union
    {
    object { beaker1_25 }
    object
	{
	beaker_contents1_25_1
	texture
	    {
	    pigment { color rgbf <0.3, 1.0, 0.3, 1.0> }
	    finish { diffuse 0.8 ior 2.0 }
	    }
	}
    translate <tableX-10, tableY, tableZ+3> 
    }

union
    {
    object { beaker2_5 }
    object
	{
	beaker_contents2_5_3
	texture
	    {
	    pigment { color rgbf <1.0, 0.5, 0.3, 1.0> }
	    finish { diffuse 0.8 ior 2.0 }
	    }
	}
    translate <tableX-18, tableY, tableZ-12> 
    }

union
{
    object { beaker2_4 }
    object
	{
	beaker_contents2_4_2
	texture
	    {
	    pigment { color rgbf <1.0, 0.5, 0.3, 1.0> }
	    finish { diffuse 0.8 ior 2.0 }
	    }
	}
    translate <tableX+15, tableY, tableZ+2> 
    }
object { beaker1_3   translate <tableX-6,  tableY, tableZ-8> }
object { beaker15_3  translate <tableX+25, tableY, tableZ+15> }
object { beaker15_25 translate <tableX-30, tableY, tableZ+10> }


/* one beaker tipped over and spilling smokey goo */
include "goo.inc"


/* Some test tubes */
include "testubes.inc"
