// Magnifying Glass (handle on X axis, Origin @ center of glass)
// 6/30/95 John Kolesar (jkolesar@ix.netcom.com)

#declare MGlass =

union {

 // Lens
 sphere { <0, 0, 0>, 1
   pigment {White filter .95 }
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 150
      refraction 1.0
      ior 1.5
          }
   scale <1, 1, .1>
       }
 
 // Rim
 torus {1,.025
   pigment {Brass }
   finish {
      ambient 0.2
      diffuse 0.7
      phong 1
      phong_size 80
          }
   rotate <90, 0, 0>
      }
 
 // Handle
 cylinder {<-1, 0, 0>, <-3, 0, 0>,.15
   pigment { Cherry_Wood scale <.25, .25, .25> }
   finish { Shiny }
          }
 
 // Ring at beginning of Handle
 cylinder {<-1, 0, 0>, <-1.2, 0, 0>,.17
   texture { Polished_Brass }
          }
 
 // Ring at end of Handle
 cylinder {<-2.8, 0, 0>, <-3, 0, 0>,.17
   texture { Polished_Brass }
          }
 
 bounded_by { sphere { <0, 0, 0>, 4 }}

 
      } // end of union
