// Monarch. For May/June Competition.
// 6/30/95 John Kolesar (jkolesar@ix.netcom.com)

#include "colors.inc"
#include "textures.inc"
#include "mglass.inc"
#include "monarch.inc"

camera {
   location  <0, 11, -2>
   direction <0, 0,  1>
   up        <0, 1,  0>
   right   <4/3, 0,  0>
   look_at   <0, 1,  0>
}

// Light
light_source {<10, 30, -30> color White}

// Floor plane
plane { y, 0
   pigment { ForestGreen }
   finish {ambient 0.15 diffuse 0.8}
}

// leaf
#declare Leaf = 
  sphere { <0, 0, 0>, .5
   pigment { image_map { gif "leaf.gif" map_type 1 filter 15,1 } }
   finish { ambient .3 diffuse .6 }
   rotate <0,0,-90>
   scale <2,.25,1>
         }

// branch
#declare Branch=
cylinder {<-6,0,0>,<6,0,0>,.05
           pigment { BakersChoc }
           finish { ambient .4 diffuse .6
                    phong 1 phong_size 80
                  }
         }
//object { Leaf translate <0,3,0> }

object { Branch rotate <0,25,0> translate <0,2,2> }
object { Branch rotate <0,30,0> translate <2,2,3> }
object { Branch rotate <0,140,0> translate <0,2,4> }
object { Branch rotate <0,50,0> translate <0,2,3> }
object { Branch rotate <0,165,0> translate <2,2,4> }
object { Branch rotate <0,70,0> translate <0,2,2> }
object { Branch rotate <0,195,0> translate <0,2,2> }
object { Branch rotate <0,110,0> translate <2,2,-2> }
object { Branch rotate <0,120,0> translate <0,2,-1> }
object { Branch rotate <0,145,0> translate <2,2,-4> }
object { Branch rotate <0,160,0> translate <2,2,-3> }

// Magnifying glass
object { MGlass rotate <90, -135, 0>
       scale .5 translate <.4, 8, -2>
       }

// Monarch - lower right
object { Monarch rotate <90,-30,0> translate <.35,6,-2> }

// Monarch - upper left
object { Monarch rotate <90,120,0> translate <-2,6,0> }

#include "leaves.inc"
