/*
	Reflection and Refraction
	copyright 1995 by Russ Jones
	rjones@southwind.net
*/

#include "colors.inc"
#include "textures.inc"
/* prism */
intersection
{
  plane
  {
    -y,1
  }
  plane
  {
    -y,1
    rotate <0, 0, 120>
  }
  plane
  {
    -y,1
    rotate <0, 0, -120>
  }
  plane
  {
    -z, 1.5
  }
  plane
  {
    -z, 1.5
    rotate <180, 0, 0>
  }
  texture
  {
    Glass3
    ambient 0.1
  }
}

/* white light coming in from the left */
cylinder
{
  <-100, 0.5, 0>
  <0, 0.5, 0>
  0.1
  texture
  {
    pigment { color White}
    finish
    {
      ambient 1
      diffuse 0
    }
  }
  no_shadow
  clipped_by
  {
    plane
    {
      y,-1
      rotate <0, 0, -120>
    }
  }
}

cone
{
  < -0.867, 0.5, 0> 0.1
  < 0, 0, 0> 0
  texture
  {
    pigment 
    {
      gradient x
      color_map
      {
        [0.0 color White filter 1.0]
        [1.0 color White filter 0.0]
      }
      translate <0, 0, 0> 
      rotate <0, 0, -30>
    }
    finish
    {
      ambient 1
      diffuse 0
    }
  }
  no_shadow
  clipped_by
  {
    plane
    {
      -y,1
      rotate <0, 0, -120>
    }
  }
}

/* colored light coming out the right */
cylinder
{
  <100, 0.5, 0>
  <0, 0.5, 0>
  0.5
  texture
  {
    pigment
    {
      gradient y
      color_map
      {
        [0.166 color Violet]
        [0.333 color Blue]
        [0.500 color Green]
        [0.667 color Yellow]
        [0.833 color Orange]
        [1.000 color Red]
      }
    }
    finish
    {
      ambient 1
      diffuse 0
    }
  }
  no_shadow
  clipped_by
  {
    plane
    {
      y,-1
      rotate <0, 0, 120>
    }
  }
  scale <1, 1, 0.05>
}

cone
{
  < 0.867, 0.5, 0> 0.56
  < 0, 0, 0> 0
  texture
  {
    pigment 
    {
      radial
      color_map
      {
        [0.166 color Violet]
        [0.333 color Blue]
        [0.500 color Green]
        [0.667 color Yellow]
        [0.833 color Orange]
        [1.000 color Red ]
      }
      frequency 6.15
      phase 0.35
      rotate <90, 0, -30>
    }
    finish
    {
      ambient 1
      diffuse 0
    }
  }
  texture
  {
    pigment
    {
      gradient x
      color_map
      {
        [0.0 color White filter 0.0]
        [1.0 color Black filter 1.0]
      }
      frequency 1
      phase 1
      rotate <0, 0, 30>
    }
    finish
    {
      ambient 0
      diffuse 1
    }
  }

  no_shadow
  clipped_by
  {
    plane
    {
      -y,1
      rotate <0, 0, 120>
    }
  }
  scale <1, 1, 0.05>
}

/* water underneath */
box
{
  <-0.5, -0.5, -0.5>
  < 0.5,  0.5,  0.5>
  scale <10000, 1, 500>
  translate -2.5*y
  texture
  {
    pigment
    {
      color red 0.0 green 0.0 blue 0.05
    }
    finish
    {
      reflection 0.45
      ambient 0.15
      diffuse 0.6
      phong 1.0
      phong_size 80
    }
    normal
    {
      ripples 0.7
      frequency 1.2
    }
  }
}

light_source
{
  <0, 30, 0>
  color White
  spotlight
  point_at <0, 0, 0>
  radius 5
  falloff 10
  tightness 30
}

camera
{
  location <2, 2.5, -10>
  look_at <0, -1, 0>
}

